/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AdvancedFTPSettings;
import com.enterprisedt.net.ftp.AdvancedGeneralSettings;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPInputStream;
import com.enterprisedt.net.ftp.FTPOutputStream;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileStatistics;
import com.enterprisedt.net.ftp.FileTransferClientInterface;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.a;
import com.enterprisedt.net.ftp.b;
import com.enterprisedt.net.ftp.internal.ConnectionContext;
import com.enterprisedt.net.ftp.internal.EventAggregator;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

public class FileTransferClient
implements FileTransferClientInterface {
    private static Logger a = Logger.getLogger("FileTransferClient");
    protected ConnectionContext masterContext = new ConnectionContext();
    protected EventAggregator eventAggregator = null;
    protected EventListener listener;
    private FTPClient b = new FTPClient();
    private AdvancedFTPSettings c = new AdvancedFTPSettings(this.masterContext);
    private AdvancedGeneralSettings d = new AdvancedGeneralSettings(this.masterContext);
    private FileStatistics e = new FileStatistics();

    public FileTransferClient() {
        this.e.addClient(this.b);
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.isConnected()) {
            throw new FTPException("The file transfer client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.isConnected()) {
            throw new FTPException("The file transfer client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.b.connected();
    }

    @Override
    public synchronized String getRemoteHost() {
        return this.masterContext.getRemoteHost();
    }

    @Override
    public synchronized void setRemoteHost(String remoteHost) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setRemoteHost(remoteHost);
    }

    @Override
    public synchronized int getTimeout() {
        return this.masterContext.getTimeout();
    }

    @Override
    public synchronized void setTimeout(int timeout) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setTimeout(timeout);
    }

    @Override
    public synchronized int getNetworkBufferSize() {
        return this.masterContext.getNetworkBufferSize();
    }

    @Override
    public synchronized void setNetworkBufferSize(int networkBufferSize) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setNetworkBufferSize(networkBufferSize);
    }

    @Override
    public synchronized int getRemotePort() {
        return this.masterContext.getRemotePort();
    }

    @Override
    public synchronized void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setRemotePort(remotePort);
    }

    @Override
    public synchronized void setContentType(FTPTransferType type) throws IOException, FTPException {
        this.masterContext.setContentType(type);
        if (this.b != null && this.b.connected()) {
            this.b.setType(type);
        }
    }

    @Override
    public synchronized FTPTransferType getContentType() {
        return this.masterContext.getContentType();
    }

    @Override
    public void setDetectContentType(boolean detectContentType) {
        this.masterContext.setDetectContentType(detectContentType);
        if (this.b != null) {
            this.b.setDetectTransferMode(detectContentType);
        }
    }

    @Override
    public boolean isDetectContentType() {
        return this.masterContext.getDetectContentType();
    }

    @Override
    public synchronized void setUserName(String userName) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setUserName(userName);
    }

    @Override
    public synchronized String getPassword() {
        return this.masterContext.getPassword();
    }

    @Override
    public synchronized void setPassword(String password) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setPassword(password);
    }

    @Override
    public synchronized String getUserName() {
        return this.masterContext.getUserName();
    }

    @Override
    public synchronized AdvancedFTPSettings getAdvancedFTPSettings() {
        return this.c;
    }

    @Override
    public synchronized AdvancedGeneralSettings getAdvancedSettings() {
        return this.d;
    }

    @Override
    public synchronized void setEventListener(EventListener listener) {
        this.listener = listener;
        this.eventAggregator = new EventAggregator(listener);
        if (this.b != null) {
            this.eventAggregator.setConnId(this.b.getId());
            this.b.setMessageListener(this.eventAggregator);
            this.b.setProgressMonitor(this.eventAggregator);
            this.b.setProgressMonitorEx(this.eventAggregator);
        }
    }

    @Override
    public synchronized void connect() throws FTPException, IOException {
        if (this.eventAggregator != null) {
            this.eventAggregator.setConnId(this.b.getId());
            this.b.setMessageListener(this.eventAggregator);
            this.b.setProgressMonitor(this.eventAggregator);
            this.b.setProgressMonitorEx(this.eventAggregator);
        }
        this.e.clear();
        this.a();
        a.debug("Configured client");
        this.b.connect();
        a.debug("Client connected");
        if (this.masterContext.isAutoLogin()) {
            a.debug("Logging in");
            this.b.login(this.masterContext.getUserName(), this.masterContext.getPassword());
            a.debug("Logged in");
            this.a(this.masterContext.getContentType());
        } else {
            a.debug("Manual login enabled");
        }
    }

    public void manualLogin() throws FTPException, IOException {
        this.checkConnection(true);
        a.debug("Logging in");
        this.b.login(this.masterContext.getUserName(), this.masterContext.getPassword());
        a.debug("Logged in");
        this.a(this.masterContext.getContentType());
    }

    private void a() throws IOException, FTPException {
        this.b.setRemoteHost(this.masterContext.getRemoteHost());
        this.b.setRemotePort(this.masterContext.getRemotePort());
        this.b.setTimeout(this.masterContext.getTimeout());
        this.b.setNetworkBufferSize(this.masterContext.getNetworkBufferSize());
        this.b.setRetryCount(this.masterContext.getRetryCount());
        this.b.setRetryDelay(this.masterContext.getRetryDelay());
        this.b.setControlEncoding(this.masterContext.getControlEncoding());
        this.b.setStrictReturnCodes(this.masterContext.isStrictReturnCodes());
        this.b.setDetectTransferMode(this.masterContext.getDetectContentType());
        this.b.setFileLockingEnabled(this.masterContext.getFileLockingEnabled());
        this.b.setConnectMode(this.masterContext.getConnectMode());
        this.b.setParserLocales(this.masterContext.getParserLocales());
        this.b.setAutoPassiveIPSubstitution(this.masterContext.isAutoPassiveIPSubstitution());
        this.b.setDeleteOnFailure(this.masterContext.isDeleteOnFailure());
        this.b.setActiveIPAddress(this.masterContext.getActiveIPAddress());
        this.b.setMonitorInterval(this.masterContext.getTransferNotifyInterval());
        this.b.setTransferBufferSize(this.masterContext.getTransferBufferSize());
        this.b.setFileNotFoundMessages(this.masterContext.getFileNotFoundMessages());
        this.b.setDirectoryEmptyMessages(this.masterContext.getDirectoryEmptyMessages());
        this.b.setTransferCompleteMessages(this.masterContext.getTransferCompleteMessages());
        if (this.masterContext.getActiveHighPort() >= 0 && this.masterContext.getActiveLowPort() >= 0) {
            this.b.setActivePortRange(this.masterContext.getActiveLowPort(), this.masterContext.getActiveHighPort());
        }
    }

    private void a(FTPTransferType fTPTransferType) throws IOException, FTPException {
        this.b.setDetectTransferMode(this.masterContext.getDetectContentType());
        this.b.setType(fTPTransferType);
    }

    private void b() throws FTPException {
        if (this.b.getDetectTransferMode() != this.masterContext.getDetectContentType()) {
            this.b.setDetectTransferMode(this.masterContext.getDetectContentType());
        }
        if (this.b.isStrictReturnCodes() != this.masterContext.isStrictReturnCodes()) {
            this.b.setStrictReturnCodes(this.masterContext.isStrictReturnCodes());
        }
        if (!this.b.getConnectMode().equals(this.masterContext.getConnectMode())) {
            this.b.setConnectMode(this.masterContext.getConnectMode());
        }
        if (this.b.isAutoPassiveIPSubstitution() != this.masterContext.isAutoPassiveIPSubstitution()) {
            this.b.setAutoPassiveIPSubstitution(this.masterContext.isAutoPassiveIPSubstitution());
        }
        if (this.b.isDeleteOnFailure() != this.masterContext.isDeleteOnFailure()) {
            this.b.setDeleteOnFailure(this.masterContext.isDeleteOnFailure());
        }
        if (this.b.getActiveIPAddress() != this.masterContext.getActiveIPAddress()) {
            this.b.setActiveIPAddress(this.masterContext.getActiveIPAddress());
        }
        if (this.b.getTransferBufferSize() != this.masterContext.getTransferBufferSize()) {
            this.b.setTransferBufferSize(this.masterContext.getTransferBufferSize());
        }
        if (this.b.getMonitorInterval() != (long)this.masterContext.getTransferNotifyInterval()) {
            this.b.setMonitorInterval(this.masterContext.getTransferNotifyInterval());
        }
        if (this.masterContext.getActiveHighPort() != this.b.getActiveHighPort() || this.masterContext.getActiveLowPort() != this.b.getActiveLowPort()) {
            this.b.setActivePortRange(this.masterContext.getActiveLowPort(), this.masterContext.getActiveHighPort());
        }
    }

    private void c() throws FTPException {
        this.b.setParserLocales(this.masterContext.getParserLocales());
        this.b();
    }

    protected static void prepareURLTransfer(URL url, FileTransferClientInterface client) throws IOException, FTPException {
        String string;
        String string2;
        int n2;
        if (!url.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + url.getProtocol());
        }
        client.setRemoteHost(url.getHost());
        if (url.getPort() > 0) {
            client.setRemotePort(url.getPort());
        }
        String string3 = url.getUserInfo();
        String string4 = "anonymous";
        String string5 = "";
        if (string3 != null) {
            int n3 = string3.indexOf(58);
            if (n3 >= 0) {
                string4 = string3.substring(0, n3);
                if (n3 + 1 < string3.length() - 1) {
                    string5 = string3.substring(n3 + 1);
                }
            } else {
                string4 = string3;
            }
        }
        client.setUserName(string4);
        client.setPassword(string5);
        client.setDetectContentType(true);
        if (url.getQuery() != null && (n2 = (string2 = url.getQuery()).indexOf(string = "type=")) >= 0 && string2.length() > n2 + string.length()) {
            char c2 = string2.toUpperCase().charAt(n2 + string.length());
            if (c2 == FTPTransferType.b.charAt(0)) {
                client.setContentType(FTPTransferType.BINARY);
                client.setDetectContentType(true);
            } else if (c2 == FTPTransferType.a.charAt(0)) {
                client.setContentType(FTPTransferType.ASCII);
                client.setDetectContentType(true);
            } else {
                throw new MalformedURLException("Unknown type: " + string2.substring(n2));
            }
        }
    }

    @Override
    public synchronized FileStatistics getStatistics() {
        return this.e;
    }

    @Override
    public synchronized String executeCommand(String command) throws FTPException, IOException {
        return this.b.quote(command);
    }

    @Override
    public void cancelAllTransfers() {
        a.debug("cancelAllTransfers() called");
        this.b.cancelTransfer();
    }

    public FTPReply getLastReply() {
        return this.b.getLastReply();
    }

    @Override
    public synchronized String getSystemType() throws FTPException, IOException {
        return this.b.system();
    }

    @Override
    public synchronized String[] directoryNameList() throws FTPException, IOException {
        return this.directoryNameList("", false);
    }

    @Override
    public synchronized String[] directoryNameList(String directoryName, boolean isLongListing) throws FTPException, IOException {
        this.c();
        return this.b.dir(directoryName, isLongListing);
    }

    @Override
    public synchronized FTPFile[] directoryList() throws FTPException, IOException, ParseException {
        return this.directoryList("");
    }

    @Override
    public synchronized FTPFile[] directoryList(String directoryName) throws FTPException, IOException, ParseException {
        this.c();
        return this.b.dirDetails(directoryName);
    }

    @Override
    public synchronized void directoryList(String directoryName, DirectoryListCallback lister) throws FTPException, IOException, ParseException {
        this.c();
        this.b.dirDetails(directoryName, lister);
    }

    @Override
    public synchronized byte[] downloadByteArray(String remoteFileName) throws FTPException, IOException {
        this.b();
        return this.b.get(remoteFileName);
    }

    @Override
    public synchronized void downloadFile(String localFileName, String remoteFileName) throws FTPException, IOException {
        this.downloadFile(localFileName, remoteFileName, WriteMode.OVERWRITE);
    }

    @Override
    public synchronized void downloadFile(String localFileName, String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        this.b();
        if (writeMode.equals(WriteMode.RESUME)) {
            this.b.resume();
        } else if (writeMode.equals(WriteMode.APPEND)) {
            throw new FTPException("Append not permitted for downloads");
        }
        this.b.get(localFileName, remoteFileName);
    }

    public static FileTransferInputStream downloadURLStream(String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL uRL = new URL(ftpURL);
        if (!uRL.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        FileTransferClient fileTransferClient = new FileTransferClient();
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        return new a(fileTransferClient.downloadStream(uRL.getPath()), fileTransferClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadURLFile(String localFileName, String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL uRL = new URL(ftpURL);
        FileTransferClient fileTransferClient = new FileTransferClient();
        if (!uRL.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        try {
            fileTransferClient.downloadFile(localFileName, uRL.getPath());
        }
        finally {
            fileTransferClient.disconnect();
        }
    }

    @Override
    public synchronized FileTransferInputStream downloadStream(String remoteFileName) throws FTPException, IOException {
        this.b();
        return new FTPInputStream(this.b, remoteFileName);
    }

    @Override
    public synchronized String uploadFile(String localFileName, String remoteFileName) throws FTPException, IOException {
        return this.uploadFile(localFileName, remoteFileName, WriteMode.OVERWRITE);
    }

    @Override
    public synchronized String uploadFile(String localFileName, String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        this.b();
        boolean bl = false;
        if (writeMode.equals(WriteMode.RESUME)) {
            this.b.resume();
        } else if (writeMode.equals(WriteMode.APPEND)) {
            bl = true;
        }
        return this.b.put(localFileName, remoteFileName, bl);
    }

    @Override
    public synchronized FileTransferOutputStream uploadStream(String remoteFileName) throws FTPException, IOException {
        return this.uploadStream(remoteFileName, WriteMode.OVERWRITE);
    }

    @Override
    public synchronized FileTransferOutputStream uploadStream(String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        this.b();
        if (WriteMode.RESUME.equals(writeMode)) {
            throw new FTPException("Resume not supported for stream uploads");
        }
        boolean bl = WriteMode.APPEND.equals(writeMode);
        return new FTPOutputStream(this.b, remoteFileName, bl);
    }

    public static FileTransferOutputStream uploadURLStream(String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL uRL = new URL(ftpURL);
        FileTransferClient fileTransferClient = new FileTransferClient();
        if (!uRL.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        return new b(fileTransferClient.uploadStream(uRL.getPath()), fileTransferClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadURLFile(String localFileName, String ftpURL) throws MalformedURLException, IOException, FTPException {
        URL uRL = new URL(ftpURL);
        FileTransferClient fileTransferClient = new FileTransferClient();
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        try {
            fileTransferClient.uploadFile(localFileName, uRL.getPath());
        }
        finally {
            fileTransferClient.disconnect();
        }
    }

    @Override
    public synchronized long getSize(String remoteFileName) throws FTPException, IOException {
        return this.b.size(remoteFileName);
    }

    @Override
    public synchronized Date getModifiedTime(String remoteFileName) throws FTPException, IOException {
        return this.b.modtime(remoteFileName);
    }

    @Override
    public synchronized void setModifiedTime(String remoteFileName, Date modifiedTime) throws FTPException, IOException {
        this.b.setModTime(remoteFileName, modifiedTime);
    }

    @Override
    public synchronized boolean exists(String remoteFileName) throws FTPException, IOException {
        return this.b.exists(remoteFileName);
    }

    @Override
    public synchronized void deleteFile(String remoteFileName) throws FTPException, IOException {
        this.b.delete(remoteFileName);
    }

    @Override
    public synchronized void rename(String renameFromName, String renameToName) throws FTPException, IOException {
        this.b.rename(renameFromName, renameToName);
    }

    @Override
    public synchronized void changeDirectory(String directoryName) throws FTPException, IOException {
        this.b.chdir(directoryName);
    }

    @Override
    public synchronized void changeToParentDirectory() throws FTPException, IOException {
        this.b.cdup();
    }

    @Override
    public synchronized String getRemoteDirectory() throws IOException, FTPException {
        return this.b.pwd();
    }

    @Override
    public synchronized void createDirectory(String directoryName) throws FTPException, IOException {
        this.b.mkdir(directoryName);
    }

    @Override
    public synchronized void deleteDirectory(String directoryName) throws FTPException, IOException {
        this.b.rmdir(directoryName);
    }

    @Override
    public synchronized void disconnect() throws FTPException, IOException {
        this.e.removeClient(this.b);
        this.b.quit();
    }

    @Override
    public synchronized void disconnect(boolean immediate) throws FTPException, IOException {
        this.e.removeClient(this.b);
        if (immediate) {
            this.b.quitImmediately();
        } else {
            this.b.quit();
        }
    }
}

