/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.internal.ConnectTask;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.pro.ProFTPClient;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public class ConnectFTPTask
extends ConnectTask {
    private static Logger a = Logger.getLogger("ConnectFTPTask");

    public ConnectFTPTask(FTPTaskProcessor taskProcessor, ConnectResult result, AsyncCallback.Connect callback) {
        super(taskProcessor, result, callback);
    }

    @Override
    protected void login(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
        FTPClient fTPClient = (FTPClient)ftp;
        try {
            if (this.getContext().getAccountDetails() == null) {
                fTPClient.login(this.getContext().getUserName(), this.getContext().getPassword());
            } else {
                fTPClient.login(this.getContext().getUserName(), this.getContext().getPassword(), this.getContext().getAccountDetails());
            }
            a.info("Logged in");
        }
        catch (FTPException fTPException) {
            try {
                fTPClient.quitImmediately();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw fTPException;
        }
        catch (IOException iOException) {
            try {
                fTPClient.quitImmediately();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    protected void preConnectConfigure(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
        super.preConnectConfigure(ftp, context);
        FTPClient fTPClient = (FTPClient)ftp;
        fTPClient.setRetryCount(context.getRetryCount());
        fTPClient.setRetryDelay(context.getRetryDelay());
        fTPClient.setStrictReturnCodes(context.isStrictReturnCodes());
        fTPClient.setConnectMode(context.getConnectMode());
        fTPClient.setParserLocales(context.getParserLocales());
        fTPClient.setAutoPassiveIPSubstitution(context.isAutoPassiveIPSubstitution());
        fTPClient.setDeleteOnFailure(context.isDeleteOnFailure());
        fTPClient.setActiveIPAddress(context.getActiveIPAddress());
        fTPClient.setMonitorInterval(context.getTransferNotifyInterval());
        fTPClient.setTransferBufferSize(context.getTransferBufferSize());
        fTPClient.setFileNotFoundMessages(context.getFileNotFoundMessages());
        fTPClient.setDirectoryEmptyMessages(context.getDirectoryEmptyMessages());
        fTPClient.setTransferCompleteMessages(context.getTransferCompleteMessages());
        if (context.getActiveHighPort() >= 0 && context.getActiveLowPort() >= 0) {
            fTPClient.setActivePortRange(context.getActiveLowPort(), context.getActiveHighPort());
        }
        ((ProFTPClient)ftp).setTransferIntegrityCheck(context.isTransferIntegrityCheck());
    }

    @Override
    protected void postConnectConfigure(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
        super.postConnectConfigure(ftp, context);
        ProFTPClient proFTPClient = (ProFTPClient)ftp;
        if (context.isCompressionPreferred()) {
            try {
                proFTPClient.enableModeZCompression();
                a.info("Compression enabled");
            }
            catch (FTPException fTPException) {
                a.warn("Failed to enable MODE Z compression: " + fTPException.getMessage());
            }
        }
    }
}

