/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.internal.ConnectTask;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.ssh.SSHAuthenticationType;
import com.enterprisedt.net.ftp.ssh.SSHFTPAlgorithm;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public class ConnectSCPTask
extends ConnectTask {
    private static Logger a = Logger.getLogger("ConnectSCPTask");

    public ConnectSCPTask(FTPTaskProcessor taskProcessor, ConnectResult result, AsyncCallback.Connect callback) {
        super(taskProcessor, result, callback);
    }

    @Override
    protected void login(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void preConnectConfigure(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
        SSHFTPClient sSHFTPClient = (SSHFTPClient)ftp;
        sSHFTPClient.setConnectionProperties(context.getSSHFTPClient().getConnectionProperties());
        super.preConnectConfigure(ftp, context);
        sSHFTPClient.setTransferBufferSize(context.getTransferBufferSize());
        sSHFTPClient.setMonitorInterval(context.getTransferNotifyInterval());
        sSHFTPClient.setCheckDirReadableForChDir(context.checkDirReadableForChDir());
        sSHFTPClient.setMaxPacketSize(context.getMaxPacketSize());
        String string = context.getRemoteEOL();
        if (string != null) {
            sSHFTPClient.setRemoteEOL(string);
        }
        if (context.isCompressionPreferred()) {
            sSHFTPClient.disableAllAlgorithms(1);
            if (context.isCompressionDelayed()) {
                sSHFTPClient.setAlgorithmEnabled(SSHFTPAlgorithm.COMPRESSION_ZLIB_DELAYED, true);
            } else {
                sSHFTPClient.setAlgorithmEnabled(SSHFTPAlgorithm.COMPRESSION_ZLIB, true);
            }
            sSHFTPClient.setAlgorithmEnabled(SSHFTPAlgorithm.COMPRESSION_NONE, true);
        }
        sSHFTPClient.setValidator(context.getSSHServerValidator());
        sSHFTPClient.getValidator().setHostValidationEnabled(context.isServerValidationEnabled());
        if (context.getSSHAuthenticationType().equals(SSHAuthenticationType.PASSWORD)) {
            sSHFTPClient.setAuthentication(context.getUserName(), context.getPassword());
            return;
        } else if (context.getSSHAuthenticationType().equals(SSHAuthenticationType.PUBLIC_KEY)) {
            if (context.getPrivateKeyFile() != null) {
                sSHFTPClient.setAuthentication(context.getPrivateKeyFile(), context.getUserName(), context.getPrivateKeyFilePassphrase());
                return;
            } else {
                if (context.getPrivateKeyInputStream() == null) throw new FTPException("Authentication is set to 'public key', but no private key has been provided.");
                sSHFTPClient.setAuthentication(context.getPrivateKeyInputStream(), context.getUserName(), context.getPrivateKeyFilePassphrase());
            }
            return;
        } else if (context.getSSHAuthenticationType().equals(SSHAuthenticationType.PUBLIC_KEY_AND_PASSWORD)) {
            sSHFTPClient.setAuthentication(context.getPrivateKeyFile(), context.getUserName(), context.getPrivateKeyFilePassphrase(), context.getPassword());
            return;
        } else {
            if (!context.getSSHAuthenticationType().equals(SSHAuthenticationType.KEYBOARD_INTERACTIVE)) return;
            sSHFTPClient.setAuthentication(context.getUserName(), context.getSSHAuthPrompts());
        }
    }

    @Override
    protected void postConnectConfigure(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
        SSHFTPClient sSHFTPClient = (SSHFTPClient)ftp;
        super.postConnectConfigure(sSHFTPClient, context);
    }
}

