/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DownloadFileResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SingleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class DownloadFileTask
extends SingleTransferTask {
    private static Logger a = Logger.getLogger("DownloadFileTask");
    private AsyncCallback.DownloadFile b;
    private DownloadFileResult c;

    public DownloadFileTask(FTPTaskProcessor taskProcessor, DownloadFileResult result, AsyncCallback.DownloadFile callback) {
        super(taskProcessor, result, TaskType.d);
        this.c = result;
        this.b = callback;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.result.getRemoteFileName() + "=>" + this.c.getLocalFileName() + "]";
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                this.setupProgressMonitoring(this.result.getNotifyInterval());
                if (this.c.getWriteMode().equals(WriteMode.RESUME)) {
                    a.debug("Resuming transfer");
                    conn.getClient().resume();
                }
                conn.getClient().get(this.c.getLocalFileName(), conn.convertPath(this.result.getRemoteFileName()));
                this.result.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.result.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.result.notifyComplete();
        this.result.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onDownloadFile(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
        try {
            if (!this.result.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.result, throwable);
        }
    }
}

