/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.RenameResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class RenameTask
extends Task {
    private static Logger a = Logger.getLogger("RenameTask");
    private RenameResult b;
    private AsyncCallback.Rename c;

    public RenameTask(FTPTaskProcessor taskProcessor, RenameResult result, AsyncCallback.Rename callback) {
        super(taskProcessor, TaskType.j, result);
        this.b = result;
        this.c = callback;
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            this.configureFreeConnRemoteDirs();
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                conn.getClient().rename(this.b.getFromFileName(), this.b.getToFileName());
                this.b.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.b.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.b.notifyComplete();
        this.b.setLocalContext(this.getContext());
        if (this.c != null) {
            try {
                this.c.onRename(this.b);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.b, throwable);
            }
        }
        this.b.setLocalContext(null);
        try {
            if (!this.b.endAsyncCalled()) {
                this.b.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.b, throwable);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getId() + ":" + this.getTaskType().getName());
        stringBuffer.append("[").append(this.b.getFromFileName()).append("=>").append(this.b.getToFileName()).append("]");
        return stringBuffer.toString();
    }
}

