/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh;

import com.enterprisedt.cryptix.util.core.Hex;
import com.enterprisedt.net.ftp.BandwidthThrottler;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.j2ssh.DirectoryOperation;
import com.enterprisedt.net.j2ssh.FileTransferProgress;
import com.enterprisedt.net.j2ssh.SshClient;
import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.io.IOUtil;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.sftp.DirectoryListCallback;
import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.net.j2ssh.sftp.SftpFileInputStream;
import com.enterprisedt.net.j2ssh.sftp.SftpFileOutputStream;
import com.enterprisedt.net.j2ssh.sftp.SftpSubsystemClient;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRead;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.transport.SFTPReadMismatchException;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient {
    private static Logger f = Logger.getLogger("SftpClient");
    public static byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    public static final byte CARRIAGE_RETURN = 13;
    public static final byte LINE_FEED = 10;
    public static final byte[] FTP_LINE_SEPARATOR = new byte[]{13, 10};
    public static final int DISABLE_CHMOD_AFTER_PUT = 1;
    public static final int DISABLE_WAIT_FOR_CHANNEL_CLOSE = 2;
    public static final int DISABLE_CHMOD_AFTER_CREATE_DIR = 4;
    SftpSubsystemClient a;
    String b;
    String c;
    public static int DEFAULT_BLOCKSIZE = 65535;
    private int g = DEFAULT_BLOCKSIZE;
    private int h = 0;
    private long i = 0L;
    int d = 18;
    int e = 511;
    private FTPTransferType j = FTPTransferType.ASCII;
    private String k = Byte.toString((byte)10);
    private BandwidthThrottler l = null;
    private boolean m = true;
    private int n = 32;
    private boolean o = true;
    private boolean p = true;
    private boolean q = true;

    SftpClient(SshClient ssh, String sftpSubsystemPath, int maxPacketSize, int configFlags, ChannelEventListener eventListener) throws IOException, FTPException {
        if (!ssh.isConnected()) {
            throw new IOException("SshClient is not connected");
        }
        this.h = configFlags;
        f.debug("Opening SFTP channel (maxpacketsize=" + maxPacketSize + ")");
        this.a = ssh.openSftpChannel(sftpSubsystemPath, maxPacketSize, eventListener);
        this.b = this.a.getDefaultDirectory();
        this.c = System.getProperty("user.dir");
    }

    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.a.setControlEncoding(controlEncoding);
    }

    public int getMaxQueuedReadRequests() {
        return this.n;
    }

    public void setMaxQueuedReadRequests(int maxQueuedReadRequests) {
        this.n = maxQueuedReadRequests;
    }

    public boolean isParallelMode() {
        return this.m;
    }

    public void setParallelMode(boolean parallelWriteMode) {
        this.m = parallelWriteMode;
    }

    public boolean checkDirReadableForChDir() {
        return this.p;
    }

    public void setCheckDirReadableForChDir(boolean checkDirReadableForChDir) {
        this.p = checkDirReadableForChDir;
    }

    public void setFileLockingEnabled(boolean lockingEnabled) {
        this.q = lockingEnabled;
    }

    public boolean getFileLockingEnabled() {
        return this.q;
    }

    public void setRemoteEOL(String remoteEOL) {
        f.debug("Setting remote EOL to be '" + Hex.toString(remoteEOL.getBytes()) + "'");
        this.k = remoteEOL;
    }

    public void setServerResponseTimeout(long serverResponseTimeout) {
        this.i = serverResponseTimeout;
        this.a.setServerResponseTimeout(serverResponseTimeout);
    }

    public void setMaxTransferRate(int thresholdBytesPerSecond) {
        if (thresholdBytesPerSecond <= 0) {
            this.l = null;
            f.debug("No limit now set on transfers");
        } else if (this.l == null) {
            this.l = new BandwidthThrottler(thresholdBytesPerSecond);
        } else {
            this.l.setThreshold(thresholdBytesPerSecond);
        }
    }

    public int getMaxTransferRate() {
        if (this.l != null) {
            return this.l.getThreshold();
        }
        return -1;
    }

    public int umask(int umask) {
        int n2 = umask;
        this.d = umask;
        return n2;
    }

    public void setType(FTPTransferType transferType) {
        this.j = transferType;
    }

    public void cd(String dir) throws IOException, FTPException {
        f.debug("cd(" + dir + ")");
        String string = dir.equals("") ? "." : this.b(dir);
        if (this.p) {
            SftpFile sftpFile = this.a.openDirectory(string);
            string = sftpFile.getAbsolutePath();
            f.debug("cd(actual=" + string + ")");
            this.a.closeHandle(sftpFile.getHandle());
        } else {
            FileAttributes fileAttributes = this.a.getAttributes(string = this.a.getAbsolutePath(string));
            if (!fileAttributes.isDirectory()) {
                String string2 = "Not a directory: " + string;
                f.debug(string2);
                throw new FTPException(string2);
            }
            f.debug("cd(actual=" + string + ")");
        }
        this.b = string;
    }

    private File a(String string) throws IOException {
        File file = new File(string);
        if (!(string.startsWith("\\") || string.startsWith("/") || file.isAbsolute())) {
            file = new File(this.c, string);
        }
        return file;
    }

    private String b(String string) throws IOException {
        this.b();
        String string2 = !string.startsWith("/") ? this.b + (this.b.endsWith("/") ? "" : "/") + string : string;
        if (string2.endsWith("/.")) {
            string2 = string2.equals("/.") ? "/" : string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    private void b() throws SshException {
        if (this.a.isClosed()) {
            throw new SshException("The SFTP connection has been closed");
        }
    }

    public void mkdir(String dir) throws IOException, FTPException {
        String string = this.b(dir);
        this.a.makeDirectory(string);
        if ((this.h & 4) == 0) {
            this.chmod(this.e & ~this.d, string);
        }
    }

    public void mkdirs(String dir) throws IOException, FTPException {
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer(dir, "/");
        String string2 = string = dir.startsWith("/") ? "/" : "";
        while (stringTokenizer.hasMoreElements()) {
            string = string + (String)stringTokenizer.nextElement();
            try {
                this.stat(string);
            }
            catch (FTPException fTPException) {
                this.mkdir(string);
            }
            string = string + "/";
        }
    }

    public String pwd() {
        return this.b;
    }

    public List ls() throws IOException, FTPException {
        return this.ls(this.b, null);
    }

    public void ls(String path, FileFilter filter, DirectoryListCallback lister) throws IOException, FTPException {
        if (f.isDebugEnabled()) {
            f.debug("Getting listing for " + path);
        }
        String string = this.b(path);
        if (f.isDebugEnabled()) {
            f.debug("Resolved " + path + " => " + string);
        }
        String string2 = this.a.getAbsolutePath(string);
        if (f.isDebugEnabled()) {
            f.debug("Absolute resolve " + string + " => " + string2);
        }
        SftpFile sftpFile = new SftpFile(string2, null, this.a);
        this.a.openDirectory(sftpFile);
        while (this.a.listChildren(sftpFile, null, filter, lister) > -1) {
        }
        sftpFile.close();
    }

    public List ls(String path, FileFilter filter) throws IOException, FTPException {
        if (f.isDebugEnabled()) {
            f.debug("Getting listing for " + path);
        }
        String string = this.b(path);
        if (f.isDebugEnabled()) {
            f.debug("Resolved " + path + " => " + string);
        }
        String string2 = this.a.getAbsolutePath(string);
        if (f.isDebugEnabled()) {
            f.debug("Absolute resolve " + string + " => " + string2);
        }
        SftpFile sftpFile = new SftpFile(string2, null, this.a);
        this.a.openDirectory(sftpFile);
        Vector vector = new Vector();
        while (this.a.listChildren(sftpFile, vector, filter, null) > -1) {
        }
        sftpFile.close();
        return vector;
    }

    public void lcd(String path) throws IOException {
        File file = !SftpClient.c(path) ? new File(this.c, path) : new File(path);
        if (!file.isDirectory()) {
            throw new IOException(path + " is not a directory");
        }
        this.c = file.getCanonicalPath();
    }

    private static boolean c(String string) {
        return new File(string).isAbsolute();
    }

    public String lpwd() {
        return this.c;
    }

    private void a(SftpFile sftpFile, long l2, long l3, OutputStream outputStream, FileTransferProgress fileTransferProgress) throws IOException, FTPException {
        long l4;
        LinkedList<UnsignedInteger32> linkedList = new LinkedList<UnsignedInteger32>();
        HashMap<UnsignedInteger32, Integer> hashMap = new HashMap<UnsignedInteger32, Integer>();
        int n2 = 1;
        int n3 = 1;
        long l5 = l4 = l2;
        long l6 = 0L;
        long l7 = 0L;
        if (fileTransferProgress != null) {
            fileTransferProgress.unCancel();
        }
        if (this.l != null) {
            this.l.reset();
        }
        LinkedList<SubsystemMessage> linkedList2 = new LinkedList<SubsystemMessage>();
        byte[] byArray = new byte[this.g];
        while (l5 < l3) {
            int n4;
            int n5;
            if (l4 < l3 && linkedList.size() < n2) {
                linkedList2.clear();
                for (int i2 = linkedList.size(); i2 < n3 && l4 < l3; l4 += (long)this.g, ++i2) {
                    n5 = (int)Math.min((long)this.g, l3 - l4);
                    SshFxpRead sshFxpRead = sftpFile.getSFTPSubsystem().createReadRequest(sftpFile.getHandle(), l4, n5);
                    linkedList2.add(sshFxpRead);
                    linkedList.add(sshFxpRead.getId());
                    hashMap.put(sshFxpRead.getId(), n5);
                }
                if (linkedList2.size() > 0) {
                    sftpFile.getSFTPSubsystem().sendMessages(linkedList2);
                }
            }
            if (fileTransferProgress != null && fileTransferProgress.isCancelled()) {
                throw new FTPTransferCancelledException();
            }
            if (linkedList.size() == 0) break;
            UnsignedInteger32 unsignedInteger32 = (UnsignedInteger32)linkedList.remove();
            n5 = sftpFile.getSFTPSubsystem().receiveReadResponse(byArray, 0, unsignedInteger32);
            if (n5 != (n4 = ((Integer)hashMap.get(unsignedInteger32)).intValue()) && l4 < l3 && linkedList.size() > 0) {
                throw new SFTPReadMismatchException("FXP_READ mismatch. Requested: " + n4 + " received: " + n5);
            }
            if (n5 <= 0) break;
            if (n3 < this.n) {
                n2 = Math.max(1, ++n3 / 2);
            }
            outputStream.write(byArray, 0, n5);
            l5 += (long)n5;
            l7 += (long)n5;
            l6 += (long)n5;
            if (linkedList.size() == 0) {
                l4 = l5;
            }
            if (this.l != null) {
                this.l.throttleTransfer(l7);
            }
            if (fileTransferProgress == null) continue;
            fileTransferProgress.progressed(l7);
        }
    }

    private void a(InputStream inputStream, OutputStream outputStream, FileTransferProgress fileTransferProgress) throws IOException, FTPException {
        int n2;
        long l2 = 0L;
        byte[] byArray = new byte[this.g];
        if (fileTransferProgress != null) {
            fileTransferProgress.unCancel();
        }
        if (this.l != null) {
            this.l.reset();
        }
        while ((n2 = inputStream.read(byArray)) > -1) {
            if (fileTransferProgress != null && fileTransferProgress.isCancelled()) {
                throw new FTPTransferCancelledException();
            }
            if (n2 <= 0) continue;
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
            if (this.l != null) {
                this.l.throttleTransfer(l2);
            }
            if (fileTransferProgress == null) continue;
            fileTransferProgress.progressed(l2);
        }
    }

    public FileAttributes get(String remote, String local, FileTransferProgress progress, boolean resume, long skipCount) throws IOException, FTPException {
        File file = this.a(local);
        boolean bl = file.exists();
        if (!bl) {
            file.createNewFile();
            f.debug("Created file: " + file.getAbsolutePath());
        }
        boolean bl2 = resume;
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), bl2);
        if (this.q) {
            String string = "Failed to obtain an exclusive write lock: " + file;
            try {
                if (fileOutputStream.getChannel().tryLock() == null) {
                    f.warn(string);
                }
            }
            catch (Exception exception) {
                f.warn(string);
            }
        }
        if (resume) {
            if (skipCount == 0L) {
                skipCount = file.length();
            } else {
                f.debug("Resume marker set explicitly: " + skipCount);
            }
        } else {
            skipCount = 0L;
        }
        try {
            return this.get(remote, fileOutputStream, progress, skipCount);
        }
        catch (FTPException fTPException) {
            if (!bl) {
                f.debug("Deleting file: " + file.getAbsolutePath());
                file.delete();
            }
            throw fTPException;
        }
    }

    public SftpFileInputStream getInputStream(String remote) throws IOException, FTPException {
        String string = this.b(remote);
        this.stat(string);
        return new SftpFileInputStream(this.a.openFile(string, 1));
    }

    public FileAttributes get(String remote, OutputStream local, FileTransferProgress progress, long skipCount) throws IOException, FTPException {
        FileAttributes fileAttributes = null;
        SftpFileInputStream sftpFileInputStream = null;
        String string = this.b(remote);
        f.info("get(" + string + ")");
        f.debug("Read request limit = " + this.n);
        try {
            fileAttributes = this.stat(string);
            long l2 = fileAttributes.getSize().longValue();
            if (progress != null) {
                progress.started(fileAttributes.getSize().longValue(), string);
            }
            if (this.j.equals(FTPTransferType.ASCII) || l2 == 0L || !this.o || this.n == 1) {
                sftpFileInputStream = new SftpFileInputStream(this.a.openFile(string, 1));
                if (skipCount > 0L) {
                    f.debug("Resuming get transfer => skipping " + skipCount + " bytes");
                    sftpFileInputStream.skip(skipCount);
                }
                if (this.j.equals(FTPTransferType.ASCII)) {
                    this.a(sftpFileInputStream, local, this.k.getBytes(), LINE_SEPARATOR, progress);
                } else {
                    this.a(sftpFileInputStream, local, progress);
                }
            } else {
                try (SftpFile sftpFile = this.a.openFile(string, 1);){
                    this.a(sftpFile, skipCount, l2, local, progress);
                }
            }
            if (progress != null) {
                progress.completed();
            }
        }
        catch (FTPException fTPException) {
            f.error("get(" + string + ") failed", fTPException);
            throw fTPException;
        }
        catch (IOException iOException) {
            f.error("get(" + string + ") failed", iOException);
            throw iOException;
        }
        finally {
            try {
                if (sftpFileInputStream != null) {
                    sftpFileInputStream.close();
                }
            }
            catch (IOException iOException) {
                f.error("Failed to close input stream in get()", iOException);
            }
            try {
                if (local != null) {
                    local.close();
                }
            }
            catch (IOException iOException) {
                f.error("Failed to close output stream in get()", iOException);
                throw iOException;
            }
        }
        return fileAttributes;
    }

    private void a(InputStream inputStream, OutputStream outputStream, byte[] byArray, byte[] byArray2, FileTransferProgress fileTransferProgress) throws IOException, FTPException {
        int n2;
        f.debug("ENTRY - getASCIIFile");
        long l2 = 0L;
        byte[] byArray3 = new byte[this.g];
        byte[] byArray4 = new byte[byArray.length];
        int n3 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.g * 2);
        if (fileTransferProgress != null) {
            fileTransferProgress.unCancel();
        }
        if (this.l != null) {
            this.l.reset();
        }
        while ((n2 = inputStream.read(byArray3)) > -1) {
            if (fileTransferProgress != null && fileTransferProgress.isCancelled()) {
                throw new FTPTransferCancelledException();
            }
            byteArrayOutputStream.reset();
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray3[i2] == byArray[n3]) {
                    byArray4[n3] = byArray3[i2];
                    if (++n3 != byArray.length) continue;
                    byteArrayOutputStream.write(byArray2);
                    l2 += (long)byArray2.length;
                    n3 = 0;
                    continue;
                }
                if (n3 > 0) {
                    byteArrayOutputStream.write(byArray4, 0, n3);
                    l2 += (long)n3;
                }
                byteArrayOutputStream.write(byArray3[i2]);
                ++l2;
                n3 = 0;
            }
            byte[] byArray5 = byteArrayOutputStream.toByteArray();
            outputStream.write(byArray5, 0, byArray5.length);
            if (this.l != null) {
                this.l.throttleTransfer(l2);
            }
            if (fileTransferProgress == null) continue;
            fileTransferProgress.progressed(l2);
        }
        if (n3 > 0) {
            outputStream.write(byArray4, 0, n3);
            l2 += (long)n3;
        }
        f.debug("EXIT - getASCIIFile");
    }

    private void a(InputStream inputStream, OutputStream outputStream, byte[] byArray, FileTransferProgress fileTransferProgress) throws IOException, FTPException {
        int n2;
        f.debug("ENTRY - putASCIIFile");
        long l2 = 0L;
        byte[] byArray2 = new byte[this.g];
        byte[] byArray3 = new byte[FTP_LINE_SEPARATOR.length];
        int n3 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.g * 2);
        if (fileTransferProgress != null) {
            fileTransferProgress.unCancel();
        }
        if (this.l != null) {
            this.l.reset();
        }
        while ((n2 = inputStream.read(byArray2)) > -1) {
            if (fileTransferProgress != null && fileTransferProgress.isCancelled()) {
                throw new FTPTransferCancelledException();
            }
            byteArrayOutputStream.reset();
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray2[i2] == 10 && n3 == 0) {
                    byteArrayOutputStream.write(byArray);
                    l2 += (long)byArray.length;
                    continue;
                }
                if (byArray2[i2] == FTP_LINE_SEPARATOR[n3]) {
                    byArray3[n3] = byArray2[i2];
                    if (++n3 != FTP_LINE_SEPARATOR.length) continue;
                    byteArrayOutputStream.write(byArray);
                    l2 += (long)byArray.length;
                    n3 = 0;
                    continue;
                }
                if (n3 > 0) {
                    byteArrayOutputStream.write(byArray);
                    l2 += (long)byArray.length;
                    n3 = 0;
                }
                byteArrayOutputStream.write(byArray2[i2]);
                ++l2;
                n3 = 0;
            }
            byte[] byArray4 = byteArrayOutputStream.toByteArray();
            outputStream.write(byArray4, 0, byArray4.length);
            if (this.l != null) {
                this.l.throttleTransfer(l2);
            }
            if (fileTransferProgress == null) continue;
            fileTransferProgress.progressed(l2);
        }
        if (n3 > 0) {
            outputStream.write(byArray, 0, byArray.length);
            l2 += (long)byArray.length;
            n3 = 0;
        }
        f.debug("EXIT - putASCIIFile");
    }

    public boolean isClosed() {
        return this.a.isClosed();
    }

    public SftpFileOutputStream getOutputStream(String remote, boolean append) throws IOException, FTPException {
        String string = this.b(remote);
        f.debug("remote path=" + string);
        SftpFileOutputStream sftpFileOutputStream = null;
        long l2 = 0L;
        UnsignedInteger32 unsignedInteger32 = null;
        try {
            FileAttributes fileAttributes = this.stat(string);
            l2 = fileAttributes.getSize().longValue();
            if (append && l2 > 0L) {
                f.debug("Appending at position=" + l2);
            }
            int n2 = 0;
            if (!append) {
                n2 = 24;
            }
            FileAttributes fileAttributes2 = new FileAttributes();
            unsignedInteger32 = fileAttributes.getPermissions();
            fileAttributes2.setPermissions(unsignedInteger32);
            try {
                sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, n2 | 2, fileAttributes2), append, l2);
            }
            catch (FTPException fTPException) {
                f.warn("Failed to open file. Trying again with null attributes: " + fTPException.getMessage());
                sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, n2 | 2, null), append, l2);
            }
        }
        catch (FTPException fTPException) {
            f.debug("File " + string + " not found - creating");
            FileAttributes fileAttributes = new FileAttributes();
            unsignedInteger32 = new UnsignedInteger32(this.e & ~this.d);
            fileAttributes.setPermissions(unsignedInteger32);
            try {
                sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, 26, fileAttributes));
            }
            catch (FTPException fTPException2) {
                f.warn("Failed to open file. Trying again with null attributes: " + fTPException2.getMessage());
                sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, 26, null));
            }
        }
        return sftpFileOutputStream;
    }

    public void put(String local, String remote, FileTransferProgress progress, boolean append, boolean resume) throws IOException, FTPException {
        File file = this.a(local);
        f.debug("put(" + file.getAbsolutePath() + "," + remote + ")");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 32768);
        try {
            FileAttributes fileAttributes = this.stat(remote);
            if (fileAttributes.isDirectory()) {
                File file2 = new File(local);
                remote = remote + (remote.endsWith("/") ? "" : "/") + file2.getName();
            }
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
        this.put(bufferedInputStream, remote, progress, append, resume);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress, boolean append, boolean resume) throws IOException, FTPException {
        Object object;
        String string = this.b(remote);
        f.debug("put(remote path=" + string + ", append=" + append + ",resume=" + resume + ")");
        SftpFileOutputStream sftpFileOutputStream = null;
        long l2 = 0L;
        UnsignedInteger32 unsignedInteger32 = null;
        try {
            try {
                object = this.stat(string);
                l2 = ((FileAttributes)object).getSize().longValue();
                if (resume && l2 > 0L) {
                    append = true;
                    f.debug("Resuming at resumepoint=" + l2);
                }
                int n2 = 0;
                if (!append) {
                    n2 = 24;
                }
                FileAttributes fileAttributes = new FileAttributes();
                unsignedInteger32 = ((FileAttributes)object).getPermissions();
                fileAttributes.setPermissions(unsignedInteger32);
                try {
                    sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, n2 | 2, fileAttributes), append, l2);
                }
                catch (FTPException fTPException) {
                    f.warn("Failed to open file. Trying again with null attributes: " + fTPException.getMessage());
                    sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, n2 | 2, null), append, l2);
                }
                if (resume && l2 > 0L) {
                    f.debug("Skip to " + l2);
                    in.skip(l2);
                }
            }
            catch (FTPException fTPException) {
                f.debug("File " + string + " not found - creating");
                FileAttributes fileAttributes = new FileAttributes();
                unsignedInteger32 = new UnsignedInteger32(this.e & ~this.d);
                fileAttributes.setPermissions(unsignedInteger32);
                try {
                    sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, 26, fileAttributes));
                }
                catch (FTPException fTPException2) {
                    f.warn("Failed to open file. Trying again with null attributes: " + fTPException2.getMessage());
                    sftpFileOutputStream = new SftpFileOutputStream(this.m, this.a.openFile(string, 26, null));
                }
            }
            if (progress != null) {
                progress.started(in.available(), string);
            }
            if (this.j.equals(FTPTransferType.ASCII)) {
                this.a(in, sftpFileOutputStream, this.k.getBytes(), progress);
            } else {
                this.a(in, sftpFileOutputStream, progress);
            }
        }
        catch (FTPException fTPException) {
            f.error("put(" + string + ") failed", fTPException);
            throw fTPException;
        }
        catch (IOException iOException) {
            f.error("put(" + string + ") failed", iOException);
            throw iOException;
        }
        finally {
            try {
                if (sftpFileOutputStream != null) {
                    sftpFileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                f.error("Failed to close output stream in put()", iOException);
                throw iOException;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                f.error("Failed to close input stream in put()", iOException);
            }
        }
        if (progress != null) {
            progress.completed();
        }
        if ((this.h & 1) == 0) {
            try {
                object = this.stat(remote).getPermissions();
                if (!unsignedInteger32.equals(object)) {
                    this.chmod(unsignedInteger32.intValue(), string);
                }
            }
            catch (Exception exception) {
                f.warn("Failed to chmod remote file (" + exception.getMessage() + ") - skipping");
            }
        }
    }

    public void chown(int uid, String path) throws IOException, FTPException {
        f.debug("chown(" + uid + "," + path + ")");
        String string = this.b(path);
        f.debug("chown(actual=" + string + ")");
        FileAttributes fileAttributes = this.a.getAttributes(string);
        fileAttributes.setUID(new UnsignedInteger32(uid));
        this.a.setAttributes(string, fileAttributes);
    }

    public void chgrp(int gid, String path) throws IOException, FTPException {
        f.debug("chgrp(" + gid + "," + path + ")");
        String string = this.b(path);
        f.debug("chgrp(actual=" + string + ")");
        FileAttributes fileAttributes = this.a.getAttributes(string);
        fileAttributes.setGID(new UnsignedInteger32(gid));
        this.a.setAttributes(string, fileAttributes);
    }

    public void chmod(int permissions, String path) throws IOException, FTPException {
        f.debug("chmod(" + Integer.toString(permissions, 8) + "," + path + ")");
        String string = this.b(path);
        f.debug("chmod(actual=" + string + ")");
        this.a.changePermissions(string, permissions);
    }

    public Date getModTime(String path) throws IOException, FTPException {
        String string = this.b(path);
        f.debug("getModTime(actual=" + string + ")");
        FileAttributes fileAttributes = this.a.getAttributes(string);
        return new Date(fileAttributes.getModifiedTime().longValue() * 1000L);
    }

    public void setModTime(String path, Date modTime) throws IOException, FTPException {
        String string = this.b(path);
        f.debug("setModTime(actual=" + string + ")");
        FileAttributes fileAttributes = this.a.getAttributes(string);
        FileAttributes fileAttributes2 = new FileAttributes();
        UnsignedInteger32 unsignedInteger32 = new UnsignedInteger32(modTime.getTime() / 1000L);
        fileAttributes2.setTimes(fileAttributes.getAccessedTime(), unsignedInteger32);
        this.a.setAttributes(string, fileAttributes2);
    }

    public void setUmask(String umask) throws FTPException {
        try {
            this.d = Integer.parseInt(umask, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FTPException("umask must be 4 digit octal number e.g. 0022");
        }
    }

    public String getUmask() {
        String string = Integer.toOctalString(this.d);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = string.length(); i2 < 4; ++i2) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void rename(String oldpath, String newpath) throws IOException, FTPException {
        String string = this.b(oldpath);
        String string2 = this.b(newpath);
        this.a.renameFile(string, string2);
    }

    public void rm(String path) throws IOException, FTPException {
        String string = this.b(path);
        FileAttributes fileAttributes = this.a.getAttributes(string);
        if (fileAttributes.isDirectory()) {
            this.a.removeDirectory(string);
        } else {
            this.a.removeFile(string);
        }
    }

    public void removeFile(String path) throws IOException, FTPException {
        String string = this.b(path);
        FileAttributes fileAttributes = this.a.getAttributes(string);
        if (fileAttributes.isDirectory()) {
            throw new FTPException(path + " is a directory.");
        }
        this.a.removeFile(string);
    }

    public void rm(String path, boolean force, boolean recurse) throws IOException, FTPException {
        String string = this.b(path);
        FileAttributes fileAttributes = this.a.getAttributes(string);
        if (fileAttributes.isDirectory()) {
            List list = this.ls(path, null);
            if (!force && list.size() > 0) {
                throw new FTPException("Cannot delete non-empty directory, use force=true to overide");
            }
            for (SftpFile sftpFile : list) {
                if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                    if (recurse) {
                        this.rm(sftpFile.getAbsolutePath(), force, recurse);
                        continue;
                    }
                    throw new IOException("Directory has contents, cannot delete without recurse=true");
                }
                if (!sftpFile.isFile()) continue;
                this.a.removeFile(sftpFile.getAbsolutePath());
            }
            this.a.removeDirectory(string);
        } else {
            this.a.removeFile(string);
        }
    }

    public void symlink(String path, String link) throws IOException, FTPException {
        String string = this.b(path);
        String string2 = this.b(link);
        this.a.createSymbolicLink(string, string2);
    }

    public String getSymbolicLinkTarget(String link) throws IOException, FTPException {
        f.debug("Getting link target for '" + link + "'");
        String string = this.b(link);
        f.debug("Resolved link: " + string);
        return this.a.getSymbolicLinkTarget(string);
    }

    public FileAttributes stat(String path) throws IOException, FTPException {
        String string = this.b(path);
        return this.a.getAttributes(string);
    }

    public String getAbsolutePath(String path) throws IOException, FTPException {
        String string = this.b(path);
        return this.a.getAbsolutePath(string);
    }

    public void quit() throws IOException {
        f.debug("quit() called");
        this.a.close();
        if ((this.h & 2) == 0) {
            long l2 = System.currentTimeMillis();
            while (this.a.isOpen()) {
                if (this.i > 0L && System.currentTimeMillis() - l2 > this.i) {
                    f.debug("Timed out waiting for channel close ack");
                    break;
                }
                try {
                    Thread.sleep(100L);
                    f.debug("Waiting for close channel ack");
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.a.isClosed()) {
                f.debug("Channel close ack received");
            }
        } else {
            f.debug("Not waiting for close channel ack");
        }
        this.a = null;
    }

    public void quitImmediately() throws IOException {
        f.debug("quit() called");
        this.a.close();
        this.a = null;
    }

    SftpSubsystemClient a() {
        return this.a;
    }

    public DirectoryOperation copyLocalDirectory(String localdir, String remotedir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException, FTPException {
        File[] fileArray;
        DirectoryOperation directoryOperation = new DirectoryOperation();
        this.pwd();
        this.lpwd();
        File file = this.a(localdir);
        remotedir = this.b(remotedir);
        remotedir = remotedir + (remotedir.endsWith("/") ? "" : "/");
        remotedir = remotedir + file.getName();
        remotedir = remotedir + (remotedir.endsWith("/") ? "" : "/");
        if (commit) {
            try {
                this.stat(remotedir);
            }
            catch (FTPException fTPException) {
                this.mkdir(remotedir);
            }
        }
        if ((fileArray = file.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                Object object;
                if (fileArray[i2].isDirectory() && !fileArray[i2].getName().equals(".") && !fileArray[i2].getName().equals("..")) {
                    if (!recurse) continue;
                    object = new File(file, fileArray[i2].getName());
                    directoryOperation.addDirectoryOperation(this.copyLocalDirectory(((File)object).getAbsolutePath(), remotedir, recurse, sync, commit, progress), (File)object);
                    continue;
                }
                if (!fileArray[i2].isFile()) continue;
                try {
                    object = this.stat(remotedir + fileArray[i2].getName());
                    if (fileArray[i2].length() == ((FileAttributes)object).getSize().longValue() && fileArray[i2].lastModified() / 1000L == ((FileAttributes)object).getModifiedTime().longValue()) {
                        directoryOperation.addUnchangedFile(fileArray[i2]);
                    } else {
                        directoryOperation.addUpdatedFile(fileArray[i2]);
                    }
                }
                catch (FTPException fTPException) {
                    directoryOperation.addNewFile(fileArray[i2]);
                }
                if (!commit) continue;
                this.put(fileArray[i2].getAbsolutePath(), remotedir + fileArray[i2].getName(), progress, false, false);
                object = this.stat(remotedir + fileArray[i2].getName());
                ((FileAttributes)object).setTimes(new UnsignedInteger32(fileArray[i2].lastModified() / 1000L), new UnsignedInteger32(fileArray[i2].lastModified() / 1000L));
                this.a.setAttributes(remotedir + fileArray[i2].getName(), (FileAttributes)object);
            }
        }
        if (sync) {
            try {
                List list = this.ls(remotedir, null);
                for (Object object : list) {
                    new File(file, ((SftpFile)object).getFilename());
                    if (directoryOperation.containsFile((SftpFile)object) || ((SftpFile)object).getFilename().equals(".") || ((SftpFile)object).getFilename().equals("..")) continue;
                    directoryOperation.addDeletedFile((SftpFile)object);
                    if (!commit) continue;
                    if (((SftpFile)object).isDirectory()) {
                        this.a((SftpFile)object, directoryOperation);
                        if (!commit) continue;
                        this.rm(((SftpFile)object).getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!((SftpFile)object).isFile()) continue;
                    this.rm(((SftpFile)object).getAbsolutePath());
                }
            }
            catch (FTPException fTPException) {
                // empty catch block
            }
        }
        return directoryOperation;
    }

    public void addEventListener(ChannelEventListener eventListener) {
        this.a.addEventListener(eventListener);
    }

    private void a(SftpFile sftpFile2, DirectoryOperation directoryOperation) throws IOException, FTPException {
        List list = this.ls(sftpFile2.getAbsolutePath(), null);
        directoryOperation.addDeletedFile(sftpFile2);
        for (SftpFile sftpFile2 : list) {
            if (sftpFile2.isDirectory() && !sftpFile2.getFilename().equals(".") && !sftpFile2.getFilename().equals("..")) {
                this.a(sftpFile2, directoryOperation);
                continue;
            }
            if (!sftpFile2.isFile()) continue;
            directoryOperation.addDeletedFile(sftpFile2);
        }
    }

    private void a(File file, DirectoryOperation directoryOperation) throws IOException {
        File[] fileArray = file.listFiles();
        directoryOperation.addDeletedFile(file);
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                file = fileArray[i2];
                if (file.isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.a(file, directoryOperation);
                    continue;
                }
                if (!file.isFile()) continue;
                directoryOperation.addDeletedFile(file);
            }
        }
    }

    public DirectoryOperation copyRemoteDirectory(String remotedir, String localdir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException, FTPException {
        File file;
        DirectoryOperation directoryOperation = new DirectoryOperation();
        String string = this.pwd();
        this.lpwd();
        this.cd(remotedir);
        String string2 = remotedir;
        int n2 = string2.lastIndexOf(47);
        if (n2 != -1) {
            string2 = string2.substring(n2 + 1);
        }
        if (!(file = new File(localdir, string2)).isAbsolute()) {
            file = new File(this.lpwd(), localdir);
        }
        if (!file.exists() && commit) {
            file.mkdir();
        }
        List list = this.ls();
        File[] fileArray = list.iterator();
        while (fileArray.hasNext()) {
            File file2;
            SftpFile sftpFile = (SftpFile)fileArray.next();
            if (sftpFile.isDirectory() && !sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) {
                if (!recurse) continue;
                file2 = new File(file, sftpFile.getFilename());
                directoryOperation.addDirectoryOperation(this.copyRemoteDirectory(sftpFile.getFilename(), file.getAbsolutePath(), recurse, sync, commit, progress), file2);
                continue;
            }
            if (!sftpFile.isFile()) continue;
            file2 = new File(file, sftpFile.getFilename());
            if (file2.exists() && file2.length() == sftpFile.getAttributes().getSize().longValue() && file2.lastModified() / 1000L == sftpFile.getAttributes().getModifiedTime().longValue()) {
                if (commit) {
                    directoryOperation.addUnchangedFile(file2);
                    continue;
                }
                directoryOperation.addUnchangedFile(sftpFile);
                continue;
            }
            if (file2.exists()) {
                if (commit) {
                    directoryOperation.addUpdatedFile(file2);
                } else {
                    directoryOperation.addUpdatedFile(sftpFile);
                }
            } else if (commit) {
                directoryOperation.addNewFile(file2);
            } else {
                directoryOperation.addNewFile(sftpFile);
            }
            if (!commit) continue;
            FileAttributes fileAttributes = this.get(sftpFile.getFilename(), file2.getAbsolutePath(), progress, false, 0L);
            file2.setLastModified(fileAttributes.getModifiedTime().longValue() * 1000L);
        }
        if (sync && (fileArray = file.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (directoryOperation.containsFile(fileArray[i2])) continue;
                directoryOperation.addDeletedFile(fileArray[i2]);
                if (fileArray[i2].isDirectory() && !fileArray[i2].getName().equals(".") && !fileArray[i2].getName().equals("..")) {
                    this.a(fileArray[i2], directoryOperation);
                    if (!commit) continue;
                    IOUtil.recurseDeleteDirectory(fileArray[i2]);
                    continue;
                }
                if (!commit) continue;
                fileArray[i2].delete();
            }
        }
        this.cd(string);
        return directoryOperation;
    }

    public int getBlockSize() {
        return this.g;
    }

    public void setBlockSize(int blocksize) {
        this.g = blocksize;
    }
}

