/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolListener;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthFailure;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.Service;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class AuthenticationProtocolClient
extends Service {
    private static Logger a = Logger.getLogger("AuthenticationProtocolClient");
    private int[] b = new int[2];
    private int[] c = new int[3];
    private Vector d = new Vector();

    public AuthenticationProtocolClient() {
        super("ssh-userauth");
        this.b[0] = 52;
        this.b[1] = 51;
        this.c[0] = 52;
        this.c[1] = 51;
    }

    @Override
    protected void onServiceAccept() throws IOException {
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected void onServiceInit(int startMode) throws IOException {
        if (startMode == 2) {
            throw new IOException("The Authentication Protocol client cannot be accepted");
        }
        this.messageStore.registerMessage(51, SshMsgUserAuthFailure.class);
        this.messageStore.registerMessage(52, SshMsgUserAuthSuccess.class);
        this.messageStore.registerMessage(53, SshMsgUserAuthBanner.class);
    }

    @Override
    protected void onServiceRequest() throws IOException {
        throw new IOException("This class implements the client protocol only!");
    }

    public void addEventListener(AuthenticationProtocolListener listener) {
        if (listener != null) {
            this.d.add(listener);
        }
    }

    public List getAvailableAuths(String username, String serviceName) throws IOException {
        a.debug("Requesting authentication methods");
        SshMessage sshMessage = new SshMsgUserAuthRequest(username, serviceName, "none", null);
        this.transport.sendMessage(sshMessage, this);
        try {
            sshMessage = this.messageStore.getMessage(this.b, this.timeout);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new SshException("Timeout whilst waiting for an authentication message", messageNotAvailableException);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            return ((SshMsgUserAuthFailure)sshMessage).getAvailableAuthentications();
        }
        throw new IOException("None request returned success! Insecure feature not supported");
    }

    public int authenticate(SshAuthenticationClient auth, Service serviceToStart) throws IOException {
        try {
            Object object;
            if (!auth.canAuthenticate() && auth.canPrompt() && !(object = auth.getAuthenticationPrompt()).showPrompt(auth)) {
                return 5;
            }
            auth.authenticate(this, serviceToStart.getServiceName());
            object = this.a(this.messageStore.getMessage(this.b, this.timeout));
            throw new AuthenticationProtocolException("Unexpected authentication message " + ((SshMessage)object).getMessageName());
        }
        catch (TerminatedStateException terminatedStateException) {
            if (terminatedStateException.getState() == 4) {
                this.transport.setupCompression(true);
                serviceToStart.init(2, this.transport);
                serviceToStart.start();
                for (AuthenticationProtocolListener authenticationProtocolListener : this.d) {
                    if (authenticationProtocolListener == null) continue;
                    authenticationProtocolListener.onAuthenticationComplete();
                }
            }
            return terminatedStateException.getState();
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new SshException("Timeout whilst waiting for an authentication message", messageNotAvailableException);
        }
    }

    public void sendMessage(SshMessage msg) throws IOException {
        this.transport.sendMessage(msg, this);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public void registerMessage(Class cls, int messageId) {
        this.messageStore.registerMessage(messageId, cls);
    }

    public SshMessage readMessage(int messageId) throws TerminatedStateException, IOException {
        this.c[2] = messageId;
        return this.a(this.c);
    }

    private SshMessage a(int[] nArray) throws TerminatedStateException, IOException {
        try {
            SshMessage sshMessage = this.messageStore.getMessage(nArray, this.timeout);
            return this.a(sshMessage);
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            throw new AuthenticationProtocolException("Failed to read messages", messageStoreEOFException);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new AuthenticationProtocolException("Failed to read messages", messageNotAvailableException);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
    }

    public SshMessage readMessage(int[] messageId) throws TerminatedStateException, IOException {
        int[] nArray = new int[messageId.length + this.b.length];
        System.arraycopy(this.b, 0, nArray, 0, this.b.length);
        System.arraycopy(messageId, 0, nArray, this.b.length, messageId.length);
        return this.a(nArray);
    }

    public void readAuthenticationState() throws IOException, TerminatedStateException {
        this.a(this.b);
    }

    private SshMessage a(SshMessage sshMessage) throws TerminatedStateException, IOException {
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            if (((SshMsgUserAuthFailure)sshMessage).getPartialSuccess()) {
                throw new TerminatedStateException(3);
            }
            throw new TerminatedStateException(2);
        }
        if (sshMessage instanceof SshMsgUserAuthSuccess) {
            throw new TerminatedStateException(4);
        }
        return sshMessage;
    }

    public String getBannerMessage(int timeout) throws IOException {
        try {
            a.debug("getBannerMessage is attempting to read the authentication banner");
            SshMessage sshMessage = this.messageStore.peekMessage(53, timeout);
            return ((SshMsgUserAuthBanner)sshMessage).getBanner();
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            return "";
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            a.error("Failed to retreive banner becasue the message store is EOF");
            return "";
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
    }
}

