/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.ChannelState;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;

public abstract class SocketChannel
extends Channel {
    private static Logger b = Logger.getLogger("SocketChannel");
    protected Socket socket = null;
    Thread a;

    public void bindSocket(Socket socket) throws IOException {
        if (this.state.getValue() != 1) {
            throw new IOException("The socket can only be bound to an unitialized channel");
        }
        this.socket = socket;
    }

    @Override
    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        try {
            this.socket.getOutputStream().write(msg.getChannelData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void onChannelEOF() throws IOException {
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException iOException) {
            b.debug("Failed to shutdown Socket OutputStream in response to EOF event: " + iOException.getMessage());
        }
    }

    @Override
    protected void onChannelClose() throws IOException {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            b.debug("Failed to close socket on channel close event: " + iOException.getMessage());
        }
    }

    @Override
    protected void onChannelOpen() throws IOException {
        if (this.socket == null) {
            throw new IOException("The socket must be bound to the channel before opening");
        }
        this.a = new Thread(new a());
        this.a.start();
    }

    @Override
    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    class a
    implements Runnable {
        a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] byArray = new byte[SocketChannel.this.getMaximumPacketSize()];
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            try {
                SocketChannel.this.socket.setSoTimeout(2000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            try {
                int n2 = 0;
                while (n2 >= 0 && !SocketChannel.this.isClosed()) {
                    try {
                        n2 = SocketChannel.this.socket.getInputStream().read(byArray);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        n2 = interruptedIOException.bytesTransferred;
                    }
                    ChannelState channelState = SocketChannel.this.state;
                    synchronized (channelState) {
                        if (SocketChannel.this.isClosed() || SocketChannel.this.isLocalEOF()) {
                            break;
                        }
                        if (n2 > 0) {
                            byteArrayWriter.write(byArray, 0, n2);
                            SocketChannel.this.sendChannelData(byteArrayWriter.toByteArray());
                            byteArrayWriter.reset();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ChannelState channelState = SocketChannel.this.state;
                synchronized (channelState) {
                    if (!SocketChannel.this.isLocalEOF()) {
                        SocketChannel.this.setLocalEOF();
                    }
                    if (SocketChannel.this.isOpen()) {
                        SocketChannel.this.close();
                    }
                }
            }
            catch (Exception exception) {
                b.debug("Failed to send channel EOF message: " + exception.getMessage());
            }
            SocketChannel.this.a = null;
        }
    }
}

