/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.io;

import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayReader
extends ByteArrayInputStream {
    private String a;

    public ByteArrayReader(byte[] data) {
        super(data);
    }

    public ByteArrayReader(byte[] data, String encoding) {
        super(data);
        this.a = encoding;
    }

    public static long readInt(byte[] data, int start) {
        long l2 = (long)(data[start] & 0xFF) << 24 & 0xFFFFFFFFFFFFFFFFL | (long)((data[start + 1] & 0xFF) << 16) | (long)((data[start + 2] & 0xFF) << 8) | (long)((data[start + 3] & 0xFF) << 0);
        return l2;
    }

    public long readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.read(byArray);
        long l2 = (long)(byArray[0] & 0xFF) << 24 & 0xFFFFFFFFFFFFFFFFL | (long)((byArray[1] & 0xFF) << 16) | (long)((byArray[2] & 0xFF) << 8) | (long)(byArray[3] & 0xFF);
        return l2;
    }

    public UnsignedInteger32 readUINT32() throws IOException {
        return new UnsignedInteger32(this.readInt());
    }

    public UnsignedInteger64 readUINT64() throws IOException {
        byte[] byArray = new byte[8];
        this.read(byArray);
        return new UnsignedInteger64(byArray);
    }

    public static String readString(byte[] data, int start) {
        int n2 = (int)ByteArrayReader.readInt(data, start);
        byte[] byArray = new byte[n2];
        System.arraycopy(data, start + 4, byArray, 0, n2);
        return new String(byArray);
    }

    public BigInteger readBigInteger() throws IOException {
        int n2 = (int)this.readInt();
        byte[] byArray = new byte[n2];
        this.read(byArray);
        return new BigInteger(byArray);
    }

    public BigInteger readBigIntWithBits() throws IOException {
        int n2 = (int)this.readInt();
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        this.read(byArray);
        return new BigInteger(1, byArray);
    }

    public byte[] readBinaryString() throws IOException {
        long l2 = this.readInt();
        if (l2 < 0L) {
            throw new IOException("Negative length reading string");
        }
        byte[] byArray = new byte[(int)l2];
        this.read(byArray);
        return byArray;
    }

    public String readString() throws IOException {
        long l2 = this.readInt();
        if (l2 < 0L) {
            throw new IOException("Negative length reading string");
        }
        byte[] byArray = new byte[(int)l2];
        this.read(byArray);
        if (this.a != null) {
            return new String(byArray, this.a);
        }
        return new String(byArray);
    }

    public String readString(long maxLength) throws IOException {
        long l2 = this.readInt();
        if (l2 < 0L) {
            throw new IOException("Negative length reading string");
        }
        if (l2 > maxLength) {
            throw new IOException("Length of " + l2 + " exceeded maximum (" + maxLength + ")");
        }
        byte[] byArray = new byte[(int)l2];
        this.read(byArray);
        if (this.a != null) {
            return new String(byArray, this.a);
        }
        return new String(byArray);
    }
}

