/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.openssh.DSAKeyInfo;
import com.enterprisedt.net.j2ssh.openssh.ECDSAKeyInfo;
import com.enterprisedt.net.j2ssh.openssh.PEMReader;
import com.enterprisedt.net.j2ssh.openssh.PEMWriter;
import com.enterprisedt.net.j2ssh.openssh.RSAKeyInfo;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import com.enterprisedt.net.j2ssh.util.SimpleASNWriter;
import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;

public class OpenSSHPrivateKeyFormat
implements SshPrivateKeyFormat {
    private static Logger a = Logger.getLogger("OpenSSHPrivateKeyFormat");

    @Override
    public String getFormatType() {
        return "OpenSSH-PrivateKey";
    }

    public String toString() {
        return this.getFormatType();
    }

    @Override
    public byte[] decryptKeyblob(byte[] formattedKey, String passphrase) throws InvalidSshKeyException {
        try {
            a.info("Unpacking OpenSSH formatted private key");
            StringReader stringReader = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            byte[] byArray = pEMReader.decryptPayload(passphrase);
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray);
            if ("DSA PRIVATE KEY".equals(pEMReader.getType())) {
                DSAKeyInfo dSAKeyInfo = DSAKeyInfo.getDSAKeyInfo(simpleASNReader);
                a.info("DSA private key");
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-dss");
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getP());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getQ());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getG());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getX());
                return byteArrayWriter.toByteArray();
            }
            if ("RSA PRIVATE KEY".equals(pEMReader.getType())) {
                RSAKeyInfo rSAKeyInfo = RSAKeyInfo.getRSAKeyInfo(simpleASNReader);
                a.info("RSA private key");
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-rsa");
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPublicExponent());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getModulus());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPrivateExponent());
                return byteArrayWriter.toByteArray();
            }
            if ("EC PRIVATE KEY".equals(pEMReader.getType())) {
                ECDSAKeyInfo eCDSAKeyInfo = ECDSAKeyInfo.getECDSAKeyInfo(simpleASNReader);
                a.info(eCDSAKeyInfo.getAlgorithm() + " private key");
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString(eCDSAKeyInfo.getAlgorithm());
                byteArrayWriter.writeString(eCDSAKeyInfo.getCurveName());
                byteArrayWriter.writeBinaryString(eCDSAKeyInfo.getQSPoint().getEncoded(false));
                byteArrayWriter.writeBigInteger(eCDSAKeyInfo.getD());
                return byteArrayWriter.toByteArray();
            }
            throw new InvalidSshKeyException("Unsupported type: " + pEMReader.getType());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems:", iOException);
        }
    }

    @Override
    public byte[] encryptKeyblob(byte[] keyblob, String passphrase) throws InvalidSshKeyException {
        try {
            byte[] byArray;
            Object object;
            ByteArrayReader byteArrayReader = new ByteArrayReader(keyblob);
            String string = byteArrayReader.readString();
            PEMWriter pEMWriter = new PEMWriter();
            if ("ssh-dss".equals(string)) {
                object = byteArrayReader.readBigInteger();
                BigInteger bigInteger = byteArrayReader.readBigInteger();
                BigInteger bigInteger2 = byteArrayReader.readBigInteger();
                BigInteger bigInteger3 = byteArrayReader.readBigInteger();
                DSAKeyInfo dSAKeyInfo = new DSAKeyInfo((BigInteger)object, bigInteger, bigInteger2, bigInteger3, BigInteger.ZERO);
                SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
                DSAKeyInfo.writeDSAKeyInfo(simpleASNWriter, dSAKeyInfo);
                byArray = simpleASNWriter.toByteArray();
                pEMWriter.setType("DSA PRIVATE KEY");
            } else if ("ssh-rsa".equals(string)) {
                object = byteArrayReader.readBigInteger();
                BigInteger bigInteger = byteArrayReader.readBigInteger();
                BigInteger bigInteger4 = byteArrayReader.readBigInteger();
                RSAKeyInfo rSAKeyInfo = new RSAKeyInfo(bigInteger, bigInteger4, (BigInteger)object, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO);
                SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
                RSAKeyInfo.writeRSAKeyInfo(simpleASNWriter, rSAKeyInfo);
                byArray = simpleASNWriter.toByteArray();
                pEMWriter.setType("RSA PRIVATE KEY");
            } else {
                throw new InvalidSshKeyException("Unsupported algorithm: " + string);
            }
            pEMWriter.setPayload(byArray);
            pEMWriter.encryptPayload(byArray, passphrase);
            object = new StringWriter();
            pEMWriter.write((Writer)object);
            return ((StringWriter)object).toString().getBytes("US-ASCII");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems", iOException);
        }
    }

    @Override
    public boolean isFormatted(byte[] formattedKey) {
        try {
            StringReader stringReader = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            return "DSA PRIVATE KEY".equals(pEMReader.getType()) || "RSA PRIVATE KEY".equals(pEMReader.getType()) || "EC PRIVATE KEY".equals(pEMReader.getType());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isPassphraseProtected(byte[] formattedKey) {
        try {
            StringReader stringReader = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            return pEMReader.getHeader().containsKey("DEK-Info");
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public boolean supportsAlgorithm(String algorithm) {
        return SshKeyPairFactory.DSA.equals(algorithm) || SshKeyPairFactory.RSA.equals(algorithm) || SshKeyPairFactory.ECDSA_SHA2_NISTP256.equals(algorithm) || SshKeyPairFactory.ECDSA_SHA2_NISTP256.equals(algorithm) || SshKeyPairFactory.ECDSA_SHA2_NISTP256.equals(algorithm);
    }

    public static void main(String[] args) {
        try {
            LoadProviders.init();
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(new File(args[0]));
            byte[] byArray = sshPrivateKeyFile.getKeyBlob("test");
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage());
        }
    }
}

