/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroup14Sha1;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroup14Sha256;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroup16Sha512;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroup18Sha512;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroup1Sha1;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroupExchangeSha1;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroupExchangeSha256;
import com.enterprisedt.net.j2ssh.transport.kex.ECDHSha2Nistp256;
import com.enterprisedt.net.j2ssh.transport.kex.ECDHSha2Nistp384;
import com.enterprisedt.net.j2ssh.transport.kex.ECDHSha2Nistp521;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchange;
import com.enterprisedt.util.debug.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshKeyExchangeFactory {
    private static Map a;
    private static String b;
    private static Logger c;
    private ArrayList d = new ArrayList(a.keySet());

    public static void initialize() {
    }

    public static String getDefaultKeyExchange() {
        return b;
    }

    public static List getSupportedKeyExchanges() {
        return new ArrayList(a.keySet());
    }

    public List getEnabledKeyExchanges() {
        return this.d;
    }

    public void disableAllKeyExchanges() {
        this.d.clear();
    }

    public void setKeyExchangeEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!a.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.d.contains(algorithmName)) {
                this.d.add(algorithmName);
            }
        } else {
            this.d.remove(algorithmName);
        }
    }

    public boolean isKeyExchangeEnabled(String algorithmName) {
        return this.d.contains(algorithmName);
    }

    public static SshKeyExchange newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyExchange)((Class)a.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!", exception);
        }
    }

    static {
        c = Logger.getLogger("SshKeyExchangeFactory");
        a = new LinkedHashMap();
        c.debug("Loading key exchange methods");
        a.put(ECDHSha2Nistp256.KEY_EXCHANGE_NAME, ECDHSha2Nistp256.class);
        a.put(ECDHSha2Nistp384.KEY_EXCHANGE_NAME, ECDHSha2Nistp384.class);
        a.put(ECDHSha2Nistp521.KEY_EXCHANGE_NAME, ECDHSha2Nistp521.class);
        a.put(DhGroup1Sha1.KEY_EXCHANGE_NAME, DhGroup1Sha1.class);
        a.put(DhGroup14Sha1.KEY_EXCHANGE_NAME, DhGroup14Sha1.class);
        a.put(DhGroup14Sha256.KEY_EXCHANGE_NAME, DhGroup14Sha256.class);
        a.put(DhGroup16Sha512.KEY_EXCHANGE_NAME, DhGroup16Sha512.class);
        a.put(DhGroup18Sha512.KEY_EXCHANGE_NAME, DhGroup18Sha512.class);
        a.put(DhGroupExchangeSha1.KEY_EXCHANGE_NAME, DhGroupExchangeSha1.class);
        a.put(DhGroupExchangeSha256.KEY_EXCHANGE_NAME, DhGroupExchangeSha256.class);
        b = ECDHSha2Nistp256.KEY_EXCHANGE_NAME;
    }
}

