/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgKexECDhReply
extends SshMessage {
    protected static final int SSH_MSG_KEX_ECDH_REPLY = 31;
    private byte[] a;
    private byte[] b;
    private byte[] c;

    public SshMsgKexECDhReply(byte[] hostKey, byte[] Q_S, byte[] signature) {
        super(31);
        this.a = hostKey;
        this.b = Q_S;
        this.c = signature;
    }

    public SshMsgKexECDhReply() {
        super(31);
    }

    public byte[] getQS() {
        return this.b;
    }

    public byte[] getHostKey() {
        return this.a;
    }

    public byte[] getSignature() {
        return this.c;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEX_ECDH_REPLY";
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeBinaryString(this.a);
            baw.writeBinaryString(this.b);
            baw.writeBinaryString(this.c);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error writing message data", iOException);
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.a = bar.readBinaryString();
            this.b = bar.readBinaryString();
            this.c = bar.readBinaryString();
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error reading message data", iOException);
        }
    }
}

