/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.PuTTYPrivateKeyFormat3;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.ecdsa.SshEcdsaNistpPublicKey;
import com.enterprisedt.net.j2ssh.util.Base64;
import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public abstract class PuTTYPrivateKeyFormat
implements SshPrivateKeyFormat {
    private static Logger a = Logger.getLogger("PuTTYPrivateKeyFormat");
    protected static String ENCRYPTION_HEADER = "Encryption";
    protected static String COMMENT_HEADER = "Comment";
    protected static String PRIVATE_LINES = "Private-Lines";
    protected static String MAC_HEADER = "Private-MAC";
    protected Map headers = new HashMap();
    protected byte[] pubBlob;
    protected byte[] privBlob;
    protected boolean isCipher = false;

    @Override
    public abstract String getFormatType();

    protected void getKeyBlobs(byte[] formattedKey) throws InvalidSshKeyException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(formattedKey)));
        String string = "";
        try {
            String string2;
            String string3;
            String string4;
            int n2;
            String string5;
            do {
                if ((string5 = bufferedReader.readLine()) != null) continue;
                throw new InvalidSshKeyException("Incorrect file format!");
            } while (!string5.startsWith(this.getFormatType()));
            while ((n2 = string5.indexOf(": ")) > 0) {
                while (string5.endsWith("\\")) {
                    string5 = string5.substring(0, string5.length() - 1);
                    String string6 = bufferedReader.readLine();
                    if (string6 == null) {
                        throw new InvalidSshKeyException("Incorrect file format!");
                    }
                    string5 = string5 + string6;
                }
                string4 = string5.substring(0, n2);
                string3 = string5.substring(n2 + 2);
                this.headers.put(string4, string3);
                string5 = bufferedReader.readLine();
                if (string5 != null) continue;
                throw new InvalidSshKeyException("Incorrect file format!");
            }
            boolean bl = false;
            do {
                string = string + string5;
                string5 = bufferedReader.readLine();
                if (string5 != null) continue;
                throw new InvalidSshKeyException("Invalid file format!");
            } while (!string5.startsWith("Private-Lines") && !string5.startsWith(PuTTYPrivateKeyFormat3.KEY_DERIVATION));
            n2 = string5.indexOf(": ");
            string4 = string5.substring(0, n2);
            string3 = string5.substring(n2 + 2);
            this.headers.put(string4, string3);
            if (string4.equals(PuTTYPrivateKeyFormat3.KEY_DERIVATION)) {
                bl = true;
            }
            this.pubBlob = Base64.decode(string);
            string = "";
            if (bl) {
                do {
                    if ((string5 = bufferedReader.readLine()) == null) {
                        throw new InvalidSshKeyException("Incorrect file format!");
                    }
                    n2 = string5.indexOf(": ");
                    if (n2 <= 0) break;
                    while (string5.endsWith("\\")) {
                        string5 = string5.substring(0, string5.length() - 1);
                        string2 = bufferedReader.readLine();
                        if (string2 == null) {
                            throw new InvalidSshKeyException("Incorrect file format!");
                        }
                        string5 = string5 + string2;
                    }
                    string4 = string5.substring(0, n2);
                    string3 = string5.substring(n2 + 2);
                    this.headers.put(string4, string3);
                } while (!string4.equals(PRIVATE_LINES));
            }
            while (true) {
                if ((string5 = bufferedReader.readLine()) == null) {
                    throw new InvalidSshKeyException("Invalid file format!");
                }
                if (string5.startsWith(MAC_HEADER)) break;
                string = string + string5;
            }
            n2 = string5.indexOf(": ");
            string4 = string5.substring(0, n2);
            string3 = string5.substring(n2 + 2);
            this.headers.put(string4, string3);
            this.privBlob = Base64.decode(string);
            string2 = (String)this.headers.get(ENCRYPTION_HEADER);
            if ("aes256-cbc".equals(string2)) {
                this.isCipher = true;
            }
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    protected byte[] readKeyPair(byte[] pubBlob, byte[] decryptedPrivBlob, String algName) throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(pubBlob);
        ByteArrayReader byteArrayReader2 = new ByteArrayReader(decryptedPrivBlob);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        if ("ssh-dss".equals(algName)) {
            String string = byteArrayReader.readString();
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader2.readBigInteger();
            byteArrayWriter.writeString("ssh-dss");
            byteArrayWriter.writeBigInteger(bigInteger);
            byteArrayWriter.writeBigInteger(bigInteger2);
            byteArrayWriter.writeBigInteger(bigInteger3);
            byteArrayWriter.writeBigInteger(bigInteger4);
        } else if ("ssh-rsa".equals(algName)) {
            String string = byteArrayReader.readString();
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger5 = byteArrayReader.readBigInteger();
            BigInteger bigInteger6 = byteArrayReader2.readBigInteger();
            byteArrayWriter.writeString("ssh-rsa");
            byteArrayWriter.writeBigInteger(bigInteger);
            byteArrayWriter.writeBigInteger(bigInteger5);
            byteArrayWriter.writeBigInteger(bigInteger6);
        } else if ("ecdsa-sha2-nistp256".equals(algName) || "ecdsa-sha2-nistp384".equals(algName) || "ecdsa-sha2-nistp521".equals(algName)) {
            SshEcdsaNistpPublicKey sshEcdsaNistpPublicKey = (SshEcdsaNistpPublicKey)SshKeyPairFactory.decodePublicKey(pubBlob);
            ECPublicKeyParameters eCPublicKeyParameters = sshEcdsaNistpPublicKey.getPublicKeyParameters();
            byte[] byArray = byteArrayReader2.readBinaryString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byteArrayWriter.writeString(algName);
            byteArrayWriter.writeString(sshEcdsaNistpPublicKey.getCurveName());
            byteArrayWriter.writeBinaryString(eCPublicKeyParameters.getQ().getEncoded(false));
            byteArrayWriter.writeBigInteger(bigInteger);
        }
        return byteArrayWriter.toByteArray();
    }

    @Override
    public boolean isFormatted(byte[] formattedKey) {
        String string = new String(formattedKey);
        return string.indexOf(this.getFormatType()) >= 0 && string.indexOf(MAC_HEADER) > 0;
    }

    @Override
    public boolean isPassphraseProtected(byte[] formattedKey) {
        try {
            this.getKeyBlobs(formattedKey);
            String string = (String)this.headers.get("Encryption");
            return "aes256-cbc".equals(string);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public abstract byte[] decryptKeyblob(byte[] var1, String var2) throws InvalidSshKeyException;

    @Override
    public byte[] encryptKeyblob(byte[] keyblob, String passphrase) throws InvalidSshKeyException {
        throw new InvalidSshKeyException("encryptKeyblob() not implemented");
    }

    @Override
    public boolean supportsAlgorithm(String algorithm) {
        return true;
    }

    public String toString() {
        return this.getFormatType();
    }

    public static void main(String[] args) {
        try {
            LoadProviders.init();
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(new File(args[0]));
            byte[] byArray = sshPrivateKeyFile.getKeyBlob(null);
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage());
        }
    }
}

