/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.ecdsa;

import com.enterprisedt.bouncycastle.asn1.nist.NISTNamedCurves;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA384Digest;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.ecdsa.SshEcdsaNistpPublicKey;

public class SshEcdsaNistp384PublicKey
extends SshEcdsaNistpPublicKey {
    public SshEcdsaNistp384PublicKey(ECPublicKeyParameters pubkeyParams) {
        super(pubkeyParams);
    }

    public SshEcdsaNistp384PublicKey(byte[] encoded) throws InvalidSshKeyException {
        super(encoded);
    }

    @Override
    protected X9ECParameters getCurve() {
        return NISTNamedCurves.getByName("P-384");
    }

    @Override
    public String getKeyFormatName() {
        return SshKeyPairFactory.ECDSA_SHA2_NISTP384;
    }

    @Override
    public int getBitLength() {
        return 384;
    }

    @Override
    protected Digest getDigest() {
        return new SHA384Digest();
    }

    @Override
    public String getCurveName() {
        return "nistp384";
    }

    @Override
    public String getKeyAlgorithmName() {
        return SshKeyPairFactory.ECDSA_SHA2_NISTP384;
    }

    @Override
    public void setKeyAlgorithmName(String algorithmName) throws InvalidSshKeyException {
        throw new InvalidSshKeyException("Key algorithm must be set to ECDSA_SHA2_NISTP384");
    }
}

