/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.ecdsa;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.ECDSASigner;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;

public abstract class SshEcdsaNistpPublicKey
extends SshPublicKey {
    private static Logger a = Logger.getLogger("SshEcdsaNistpPublicKey");
    protected ECPublicKeyParameters pubkeyParams;
    protected String curve;

    public SshEcdsaNistpPublicKey(ECPublicKeyParameters pubkeyParams) {
        this.pubkeyParams = pubkeyParams;
    }

    public ECPublicKeyParameters getPublicKeyParameters() {
        return this.pubkeyParams;
    }

    public SshEcdsaNistpPublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString(SshKeyPairFactory.MAX_ALGORITHM_NAME_LEN);
            if (!string.equals(this.getKeyFormatName())) {
                String string2 = "Header '" + string + "' does not match algorithm '" + this.getKeyFormatName() + "'";
                a.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            X9ECParameters x9ECParameters = this.getCurve();
            this.curve = byteArrayReader.readString();
            if (!this.curve.equals(this.getCurveName())) {
                throw new InvalidSshKeyException("Curve mismatch: '" + this.curve + "' != '" + this.getCurveName() + "'");
            }
            ECPoint eCPoint = x9ECParameters.getCurve().decodePoint(byteArrayReader.readBinaryString());
            ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            this.pubkeyParams = new ECPublicKeyParameters(eCPoint, eCDomainParameters);
        }
        catch (IOException iOException) {
            a.error("SshEcdsaNistpPublicKey()", iOException);
            throw new InvalidSshKeyException(iOException);
        }
    }

    protected abstract X9ECParameters getCurve();

    public abstract String getCurveName();

    protected abstract Digest getDigest();

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getKeyFormatName());
            byteArrayWriter.writeString(this.getCurveName());
            byteArrayWriter.writeBinaryString(this.pubkeyParams.getQ().getEncoded(false));
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean verifySignature(byte[] signature, byte[] data) throws InvalidSshKeySignatureException {
        try {
            a.debug("Signature length=" + signature.length);
            ByteArrayReader byteArrayReader = new ByteArrayReader(signature);
            String string = new String(byteArrayReader.readBinaryString());
            if (!string.equals(this.getKeyFormatName())) {
                a.error("Sig algorithm (" + string + ") does not match algorithm (" + this.getKeyFormatName() + ")");
                throw new InvalidSshKeySignatureException();
            }
            byte[] byArray = byteArrayReader.readBinaryString();
            BigInteger[] bigIntegerArray = this.a(byArray);
            ECDSASigner eCDSASigner = new ECDSASigner();
            eCDSASigner.init(false, this.pubkeyParams);
            Digest digest = this.getDigest();
            digest.update(data, 0, data.length);
            byte[] byArray2 = new byte[digest.getDigestSize()];
            digest.doFinal(byArray2, 0);
            return eCDSASigner.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            String string = "Failed to read signature";
            a.error(string, iOException);
            throw new InvalidSshKeySignatureException(string);
        }
    }

    private BigInteger[] a(byte[] byArray) throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        BigInteger bigInteger = new ASN1Integer(byteArrayReader.readBinaryString()).getPositiveValue();
        BigInteger bigInteger2 = new ASN1Integer(byteArrayReader.readBinaryString()).getPositiveValue();
        return new BigInteger[]{bigInteger, bigInteger2};
    }
}

