/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaKeyPair;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPublicKey
extends SshPublicKey {
    private static Logger a = Logger.getLogger("SshRsaPublicKey");
    private RSAPublicKey b;
    private String c = SshKeyPairFactory.RSA;
    private String d = SshKeyPairFactory.RSA;

    public SshRsaPublicKey(RSAPublicKey key) {
        this.b = key;
    }

    public SshRsaPublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString(SshKeyPairFactory.MAX_ALGORITHM_NAME_LEN);
            if (!(string.equals(SshKeyPairFactory.RSA) || string.equals(SshKeyPairFactory.RSA_256) || string.equals(SshKeyPairFactory.RSA_512))) {
                String string2 = "Header algorithm '" + string + "' does not match key format '" + this.getKeyFormatName() + "'";
                a.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.b = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                a.error("SshRsaPublicKey()", noSuchAlgorithmException);
                throw new InvalidSshKeyException(noSuchAlgorithmException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                a.error("SshRsaPublicKey()", invalidKeySpecException);
                throw new InvalidSshKeyException(invalidKeySpecException);
            }
        }
        catch (IOException iOException) {
            a.error("SshRsaPublicKey()", iOException);
            throw new InvalidSshKeyException(iOException);
        }
    }

    @Override
    public String getKeyFormatName() {
        return this.c;
    }

    @Override
    public void setKeyAlgorithmName(String algorithmName) throws InvalidSshKeyException {
        this.d = algorithmName;
    }

    @Override
    public String getKeyAlgorithmName() {
        return this.d;
    }

    @Override
    public int getBitLength() {
        return this.b.getModulus().bitLength();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(SshKeyPairFactory.RSA);
            byteArrayWriter.writeBigInteger(this.b.getPublicExponent());
            byteArrayWriter.writeBigInteger(this.b.getModulus());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean verifySignature(byte[] signature, byte[] data) throws InvalidSshKeySignatureException {
        try {
            Object object;
            if (signature.length != 128) {
                a.debug("Signature length=" + signature.length);
                object = new ByteArrayReader(signature);
                byte[] byArray = ((ByteArrayReader)object).readBinaryString();
                String string = new String(byArray);
                if (!(string.equals(SshKeyPairFactory.RSA) || string.equals(SshKeyPairFactory.RSA_256) || string.equals(SshKeyPairFactory.RSA_512))) {
                    String string2 = "Header algorithm '" + string + "' does not match key format '" + this.getKeyFormatName() + "'";
                    a.error(string2);
                    throw new InvalidSshKeyException(string2);
                }
                signature = ((ByteArrayReader)object).readBinaryString();
            }
            object = Signature.getInstance(SshRsaKeyPair.getSignatureName(this.getKeyAlgorithmName()), "CryptixEDT");
            ((Signature)object).initVerify(this.b);
            ((Signature)object).update(data);
            a.debug("Verifying signature (" + object.getClass().getName() + ")");
            return ((Signature)object).verify(signature);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String string = "No such provider found: CryptixEDT";
            a.error(string, noSuchProviderException);
            throw new InvalidSshKeySignatureException(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string = "No such algorithm found: " + SshRsaKeyPair.getSignatureName(this.getKeyFormatName());
            a.error(string, noSuchAlgorithmException);
            throw new InvalidSshKeySignatureException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            String string = "Failed to read signature";
            a.error(string, iOException);
            throw new InvalidSshKeySignatureException(string);
        }
        catch (InvalidKeyException invalidKeyException) {
            a.error("Invalid key signature", invalidKeyException);
            throw new InvalidSshKeySignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            a.error("Signature exception", signatureException);
            throw new InvalidSshKeySignatureException(signatureException);
        }
    }
}

