/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.util;

import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class Hash {
    private MessageDigest a;

    public Hash(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.a = MessageDigest.getInstance(algorithm, "CryptixEDT");
    }

    public int getSize() {
        return this.a.getDigestLength();
    }

    public void putBigInteger(BigInteger bi) {
        byte[] byArray = bi.toByteArray();
        this.putInt(byArray.length);
        this.a.update(byArray);
    }

    public void putByte(byte b2) {
        this.a.update(b2);
    }

    public void putBytes(byte[] data) {
        this.a.update(data);
    }

    public void putInt(int i2) {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        try {
            byteArrayWriter.writeInt(i2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.a.update(byteArrayWriter.toByteArray());
    }

    public void putString(String str) {
        this.putInt(str.length());
        this.a.update(str.getBytes());
    }

    public void reset() {
        this.a.reset();
    }

    public static byte[] simple(byte[] data, String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, "CryptixEDT");
        messageDigest.update(data);
        return messageDigest.digest();
    }

    public byte[] doFinal() {
        return this.a.digest();
    }
}

