/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls;

import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateEntry;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsServerCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.cryptix.provider.rsa.BaseRSAPrivateKey;
import com.enterprisedt.net.puretls.EdtTlsClient;
import com.enterprisedt.net.puretls.SSLContext;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.CertificateDecodeException;
import com.enterprisedt.net.puretls.cert.CertificateVerifyException;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class EdtTlsAuthentication
implements TlsAuthentication {
    private static Logger a = Logger.getLogger("EdtTlsAuthentication");
    private BcTlsCrypto b;
    private SSLContext c;
    private CertContext d;
    private EdtTlsClient e;

    public EdtTlsAuthentication(EdtTlsClient client, SSLContext sslContext, BcTlsCrypto crypto) {
        this.e = client;
        this.c = sslContext;
        this.b = crypto;
        this.d = new CertContext(sslContext.a());
    }

    @Override
    public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
        a.debug("notifyServerCertificate");
        Vector<X509Cert> vector = new Vector<X509Cert>();
        TlsCertificate[] tlsCertificateArray = serverCertificate.getCertificate().getCertificateList();
        for (int i2 = 0; i2 < tlsCertificateArray.length; ++i2) {
            X509Cert x509Cert = new X509Cert(tlsCertificateArray[i2].getEncoded());
            a.debug(x509Cert.toString());
            vector.addElement(x509Cert);
        }
        Vector vector2 = new Vector();
        try {
            vector2 = X509Cert.verifyCertChain(this.d, vector, this.c.getPolicy().getCertVerifyPolicy());
            a.debug(vector.size() + " certificates supplied." + (vector2 != null ? vector2.size() : 0) + " verified certificates.");
        }
        catch (CertificateDecodeException certificateDecodeException) {
            throw new TlsFatalAlert(42);
        }
        catch (CertificateVerifyException certificateVerifyException) {
            throw new TlsFatalAlert(42);
        }
        boolean bl = vector2 != null;
        boolean bl2 = this.c.getPolicy().acceptUnverifiableCertificatesP();
        a.debug("isVerified=" + bl + ", acceptUnverified=" + bl2);
        if (!bl2 && this.c.getVerifier() != null ? !this.c.getVerifier().acceptPeerCertificate(vector, bl) : vector2 == null && !bl2) {
            throw new CertificateVerifyException("Server certificate could not be validated.", vector);
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
        Object object;
        Vector vector = this.c.b();
        X509Certificate x509Certificate = null;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            object = (X509Certificate)vector.elementAt(0);
            if (((X509Certificate)object).getBasicConstraints() != -1) continue;
            x509Certificate = object;
            break;
        }
        if (x509Certificate != null) {
            Object object2;
            a.debug("Client certificate for authentication: " + x509Certificate.getSubjectDN().toString());
            PublicKey publicKey = x509Certificate.getPublicKey();
            object = publicKey.getAlgorithm();
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
            Vector vector2 = certificateRequest.getSupportedSignatureAlgorithms();
            if (vector2 != null) {
                for (int i3 = 0; i3 < vector2.size(); ++i3) {
                    object2 = (SignatureAndHashAlgorithm)vector2.elementAt(i3);
                    if (!(((String)object).equals("RSA") && ((SignatureAndHashAlgorithm)object2).getSignature() == 1 || ((String)object).equals("DSA") && ((SignatureAndHashAlgorithm)object2).getSignature() == 2) && (!((String)object).equals("EC") || ((SignatureAndHashAlgorithm)object2).getSignature() != 3) || ((SignatureAndHashAlgorithm)object2).getHash() != 2 && ((SignatureAndHashAlgorithm)object2).getHash() != 4 && ((SignatureAndHashAlgorithm)object2).getHash() != 5 && ((SignatureAndHashAlgorithm)object2).getHash() != 6) continue;
                    signatureAndHashAlgorithm = object2;
                    break;
                }
                if (signatureAndHashAlgorithm == null) {
                    return null;
                }
            }
            try {
                CertificateEntry[] certificateEntryArray = new CertificateEntry[]{new CertificateEntry(new BcTlsCertificate(this.b, x509Certificate.getEncoded()), null)};
                object2 = new Certificate(certificateRequest.getCertificateRequestContext(), certificateEntryArray);
                BaseRSAPrivateKey baseRSAPrivateKey = (BaseRSAPrivateKey)this.c.c();
                RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(true, baseRSAPrivateKey.getModulus(), baseRSAPrivateKey.getExponent());
                return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.e.getContext()), this.b, rSAKeyParameters, (Certificate)object2, signatureAndHashAlgorithm);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException(certificateEncodingException.getMessage());
            }
        }
        return null;
    }
}

