/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls;

import com.enterprisedt.bouncycastle.tls.DefaultTlsClient;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsClientContext;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.EdtTlsAuthentication;
import com.enterprisedt.net.puretls.SSLContext;
import com.enterprisedt.net.puretls.SSLHandshake;
import com.enterprisedt.net.puretls.SSLSessionData;
import com.enterprisedt.net.puretls.sslg.SSLPolicyInt;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public class EdtTlsClient
extends DefaultTlsClient {
    private static Logger a = Logger.getLogger("EdtTlsClient");
    private EdtTlsAuthentication b;
    private SSLContext c;

    public EdtTlsClient(SSLContext sslContext, BcTlsCrypto crypto) {
        super(crypto);
        this.c = sslContext;
        this.b = new EdtTlsAuthentication(this, sslContext, crypto);
    }

    public TlsClientContext getContext() {
        return this.context;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return this.b;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        int n2 = this.c.getPolicy().getMinSSLVersion();
        int n3 = this.c.getPolicy().getMaxSSLVersion();
        ProtocolVersion protocolVersion = SSLHandshake.getBCProtocolVersion(n2);
        ProtocolVersion protocolVersion2 = SSLHandshake.getBCProtocolVersion(n3);
        return protocolVersion2.downTo(protocolVersion);
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), this.c.getPolicy().getCipherSuites());
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        a.debug("Server version: {0}", serverVersion.toString());
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        a.debug("Handshake complete");
        if (this.context.getServerVersion().isEqualOrEarlierVersionOf(ProtocolVersion.TLSv12)) {
            TlsSession tlsSession = this.context.getResumableSession();
            String string = this.c.getRemoteIPAddress();
            SSLSessionData sSLSessionData = this.c.a(string);
            if (sSLSessionData != null && ArrayUtil.areEqual(sSLSessionData.getSession().getSessionID(), tlsSession.getSessionID())) {
                a.debug("Session ID already stored");
                return;
            }
            SSLSessionData sSLSessionData2 = new SSLSessionData(tlsSession, string);
            this.c.a(sSLSessionData2);
        }
    }

    @Override
    public TlsSession getSessionToResume() {
        String string = this.c.getRemoteIPAddress();
        SSLSessionData sSLSessionData = this.c.a(string);
        if (sSLSessionData != null) {
            a.debug("Found session to resume " + Hex.toHexString(sSLSessionData.getSession().getSessionID()));
            return sSLSessionData.getSession();
        }
        return null;
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        a.debug("Notified session ID: " + Hex.toHexString(sessionID));
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        String string = SSLPolicyInt.getCipherSuiteName(selectedCipherSuite);
        a.debug("Selected cipher suite: {0}", string);
    }
}

