/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls;

import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.SSLPeerCertVerifier;
import com.enterprisedt.net.puretls.SSLSessionData;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.net.puretls.crypto.EAYEncryptedPrivateKey;
import com.enterprisedt.net.puretls.sslg.SSLContextInt;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;
import java.util.Vector;

public class SSLContext
extends SSLContextInt {
    private static Logger e = Logger.getLogger("SSLContext");
    private Hashtable<String, SSLSessionData> f = new Hashtable();
    Vector a = new Vector();
    Vector b = null;
    PrivateKey c = null;
    PublicKey d = null;
    private String g;
    private SSLPeerCertVerifier h = null;

    public SSLContext() {
        LoadProviders.init();
    }

    public void setPrivateKey(PrivateKey key) {
        this.c = key;
    }

    public void setPublicKey(PublicKey key) {
        this.d = key;
    }

    public void setPublicKeyFromCert(byte[] certData) throws IOException {
        X509Cert x509Cert = new X509Cert(certData);
        this.d = x509Cert.getPublicKey();
    }

    public void setCertificateChain(Vector chain) {
        this.b = chain;
    }

    @Override
    public void loadPKCS12File(String path, String passphrase) {
        throw new InternalError("Not implemented");
    }

    @Override
    public void loadEAYKeyFile(String path, String passphrase) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        this.loadEAYKeyFile(fileInputStream, passphrase);
    }

    @Override
    public void loadEAYKeyFile(InputStream is, String passphrase) throws IOException {
        Object object;
        PrivateKey privateKey;
        int n2;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = is.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        StringBuffer stringBuffer = new StringBuffer();
        SSLDebug.debug(16, "Loading key file");
        if (!WrappedObject.findObject(bufferedReader, "PRIVATE KEY", stringBuffer)) {
            throw new IOException("Couldn't find private key in this file");
        }
        try {
            privateKey = EAYEncryptedPrivateKey.createPrivateKey(bufferedReader, stringBuffer.toString(), passphrase.getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        Vector<Certificate> vector = new Vector<Certificate>();
        try {
            byte[] byArray3;
            object = CertificateFactory.getInstance("X.509");
            while ((byArray3 = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
                SSLDebug.debug(16, "Loading certificate", byArray3);
                Certificate certificate = ((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(byArray3));
                vector.addElement(certificate);
            }
        }
        catch (CertificateException certificateException) {
            e.error("Failed to decode certificate", certificateException);
            throw new IOException("Failed to decode certificate: " + certificateException.getMessage());
        }
        if (vector.size() == 0) {
            throw new IOException("Need at least one certificate");
        }
        object = (Certificate)vector.elementAt(0);
        this.d = ((Certificate)object).getPublicKey();
        this.c = privateKey;
        this.b = vector;
    }

    public void setClientCertPrivKey(Certificate[] javaCertChain, PrivateKey javaPrivateKey) throws CertificateException {
        try {
            this.b = new Vector();
            Certificate certificate = javaCertChain[javaCertChain.length - 1];
            this.b.add(certificate);
            this.d = certificate.getPublicKey();
            this.c = EAYEncryptedPrivateKey.createPrivateKey(javaPrivateKey, javaPrivateKey.getAlgorithm());
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    @Override
    public void loadRootCertificates(String path) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        this.loadRootCertificates(fileInputStream);
        fileInputStream.close();
    }

    @Override
    public void loadRootCertificates(InputStream is) throws IOException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading root", byArray);
            this.a.addElement(byArray);
        }
    }

    public void setRootCertificates(Vector certs) {
        this.a = certs;
    }

    Vector a() {
        return this.a;
    }

    Vector b() {
        return this.b;
    }

    PrivateKey c() {
        return this.c;
    }

    public void setRemoteIPAddress(String ipAddress) {
        this.g = ipAddress;
    }

    public String getRemoteIPAddress() {
        return this.g;
    }

    synchronized void a(SSLSessionData sSLSessionData) {
        e.debug("Storing session under IP address " + sSLSessionData.getIPAddress());
        this.f.put(sSLSessionData.getIPAddress(), sSLSessionData);
    }

    synchronized SSLSessionData a(String string) {
        SSLSessionData sSLSessionData = this.f.get(string);
        if (sSLSessionData != null) {
            if (sSLSessionData.isExpired()) {
                this.b(sSLSessionData.getIPAddress());
            } else {
                return sSLSessionData;
            }
        }
        return null;
    }

    synchronized void b(String string) {
        e.debug("Expiring session" + string);
        this.f.remove(string);
    }

    public SSLPeerCertVerifier getVerifier() {
        return this.h;
    }

    public void setVerifier(SSLPeerCertVerifier verifier) {
        this.h = verifier;
    }
}

