/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.cert.DERUtils;
import com.enterprisedt.net.puretls.cert.EAYDSAPrivateKey;
import com.enterprisedt.net.puretls.cert.EAYRSAPrivateKey;
import com.enterprisedt.net.puretls.crypto.a;
import com.enterprisedt.net.puretls.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;

public class EAYEncryptedPrivateKey {
    private static final byte[] a = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] b = new byte[]{42, -122, 72, -50, 56, 4, 1};

    public static PrivateKey createPrivateKey(BufferedReader in, String type, byte[] password) throws IOException, IllegalArgumentException {
        return EAYEncryptedPrivateKey.createPrivateKey(com.enterprisedt.net.puretls.crypto.a.a(in, password), type, password);
    }

    public static PrivateKey createPrivateKey(PrivateKey key, String type) throws IOException, IllegalArgumentException {
        if (type.equals("DSA")) {
            return new EAYDSAPrivateKey((DSAPrivateKey)key);
        }
        if (type.equals("RSA")) {
            return new EAYRSAPrivateKey((RSAPrivateCrtKey)key);
        }
        throw new InternalError("Couldn't find key type" + type);
    }

    public static PrivateKey createPrivateKey(byte[] plainKey, String type, byte[] password) throws IOException, IllegalArgumentException {
        if (type.equals("DSA")) {
            return new EAYDSAPrivateKey(plainKey);
        }
        if (type.equals("RSA")) {
            return new EAYRSAPrivateKey(plainKey);
        }
        if (type.length() == 0) {
            byte[] byArray = DERUtils.decodeSequence(new ByteArrayInputStream(plainKey));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n2 = DERUtils.decodeIntegerX(byteArrayInputStream);
            byte[] byArray2 = DERUtils.decodeSequence(byteArrayInputStream);
            byte[] byArray3 = DERUtils.decodeOID(new ByteArrayInputStream(byArray2));
            byte[] byArray4 = DERUtils.decodeOctetString(byteArrayInputStream);
            if (Util.areEqual(byArray3, a)) {
                return new EAYRSAPrivateKey(byArray4);
            }
            if (Util.areEqual(byArray3, b)) {
                return new EAYDSAPrivateKey(byArray4);
            }
        }
        throw new InternalError("Couldn't find key type" + type);
    }

    public static void writePrivateKey(PrivateKey priv, byte[] password, BufferedWriter out) throws IOException {
        String string = priv.getAlgorithm();
        byte[] byArray = priv.getEncoded();
        String string2 = string + " PRIVATE KEY";
        com.enterprisedt.net.puretls.crypto.a.a(byArray, password, string2, out);
    }
}

