/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.SSLDebug;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class PKCS1Pad {
    public static final int ENCRYPT = 1;
    public static final int SIGN = 2;
    public static final int DECRYPT = 1;
    public static final int VERIFY = 2;

    public static byte[] pkcs1PadBuf(SecureRandom rnd, byte[] input, PublicKey key) {
        BigInteger bigInteger = ((CryptixRSAPublicKey)key).getModulus();
        return PKCS1Pad.pkcs1PadBuf(rnd, input, bigInteger, 1);
    }

    public static byte[] pkcs1PadBuf(byte[] input, PrivateKey key) {
        BigInteger bigInteger = ((CryptixRSAPrivateKey)key).getModulus();
        return PKCS1Pad.pkcs1PadBuf(input, bigInteger, 2);
    }

    public static byte[] pkcs1PadBuf(byte[] input, BigInteger modulus, int how) {
        SecureRandom secureRandom = null;
        if (how == 1) {
            secureRandom = new SecureRandom();
        }
        return PKCS1Pad.pkcs1PadBuf(secureRandom, input, modulus, how);
    }

    public static byte[] pkcs1PadBuf(SecureRandom rnd, byte[] input, BigInteger modulus, int how) {
        SSLDebug.debug(8, "PKCS1 pad input", input);
        int n2 = modulus.bitLength() / 8;
        n2 += modulus.bitLength() % 8 > 0 ? 1 : 0;
        int n3 = how == 1 ? --n2 - (2 + input.length) : n2 - (3 + input.length);
        byte[] byArray = new byte[n2];
        if (n3 < 8) {
            throw new InternalError("Input too long");
        }
        int n4 = 0;
        if (how == 1) {
            byArray[n4++] = 2;
            byte[] byArray2 = new byte[1];
            for (int i2 = 0; i2 < n3; ++i2) {
                do {
                    rnd.nextBytes(byArray2);
                } while (byArray2[0] == 0);
                byArray[n4++] = byArray2[0];
            }
        } else {
            byArray[n4++] = 0;
            byArray[n4++] = 1;
            for (int i3 = 0; i3 < n3; ++i3) {
                byArray[n4++] = -1;
            }
        }
        byArray[n4++] = 0;
        System.arraycopy(input, 0, byArray, n4, input.length);
        SSLDebug.debug(8, "PKCS1 padded output", byArray);
        return byArray;
    }

    public static byte[] pkcs1UnpadBuf(byte[] input, int how, CryptixRSAPrivateKey key) {
        return PKCS1Pad.pkcs1UnpadBuf(input, how, key.getModulus());
    }

    public static byte[] pkcs1UnpadBuf(byte[] input, int how, BigInteger modulus) {
        int n2 = 0;
        SSLDebug.debug(8, "PKCS1 padded input", input);
        int n3 = modulus.bitLength() / 8;
        if ((n3 += modulus.bitLength() % 8 > 0 ? 1 : 0) - 1 != input.length) {
            SSLDebug.debug(8, "Encryption block wrong length");
            throw new IllegalBlockSizeException("Bad RSA padding: wrong length" + input.length);
        }
        if (how == 1 ? input[0] != 2 : input[0] != 1) {
            throw new IllegalBlockSizeException("Bad RSA padding");
        }
        for (int i2 = 1; i2 < input.length; ++i2) {
            if (input[i2] == 0) {
                if (n2 < 8) {
                    SSLDebug.debug(8, "Bad RSA padding" + n2 + "bytes");
                    throw new IllegalBlockSizeException("Bad RSA padding");
                }
                byte[] byArray = new byte[input.length - (i2 + 1)];
                System.arraycopy(input, i2 + 1, byArray, 0, byArray.length);
                SSLDebug.debug(8, "PKCS1 unpadded output", byArray);
                return byArray;
            }
            ++n2;
            if (how == 1 || input[i2] == -1) continue;
            throw new IllegalBlockSizeException("Bad RSA padding");
        }
        throw new IllegalBlockSizeException("Bad RSA padding");
    }
}

