/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.config.spi;

import com.izforge.izpack.api.config.spi.ServiceFinder;

public class EscapeTool {
    private static final String ESCAPE_LETTERS = "\\tnfbr";
    private static final String ESCAPEABLE_CHARS = "\\\t\n\f\b\r";
    private static final char ESCAPE_CHAR = '\\';
    static final char[] HEX = "0123456789abcdef".toCharArray();
    private static final EscapeTool INSTANCE = ServiceFinder.findService(EscapeTool.class);
    private static final char ASCII_MIN = ' ';
    private static final char ASCII_MAX = '~';
    static final int HEX_DIGIT_MASK = 15;
    static final int HEX_DIGIT_3_OFFSET = 4;
    static final int HEX_DIGIT_2_OFFSET = 8;
    static final int HEX_DIGIT_1_OFFSET = 12;
    static final int HEX_RADIX = 16;
    private static final int UNICODE_HEX_DIGITS = 4;
    static final char DOUBLE_QUOTE = '\"';

    public static EscapeTool getInstance() {
        return INSTANCE;
    }

    public String escape(String line) {
        int len = line.length();
        StringBuilder buffer = new StringBuilder(len * 2);
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = line.charAt(i2);
            int idx = ESCAPEABLE_CHARS.indexOf(c2);
            if (idx >= 0) {
                buffer.append('\\');
                buffer.append(ESCAPE_LETTERS.charAt(idx));
                continue;
            }
            if (c2 < ' ' || c2 > '~') {
                this.escapeBinary(buffer, c2);
                continue;
            }
            buffer.append(c2);
        }
        return buffer.toString();
    }

    public String quote(String value) {
        String ret = value;
        if (value != null && value.length() != 0) {
            StringBuilder buff = new StringBuilder();
            buff.append('\"');
            for (int i2 = 0; i2 < value.length(); ++i2) {
                char c2 = value.charAt(i2);
                if (c2 == '\\' || c2 == '\"') {
                    buff.append('\\');
                }
                buff.append(c2);
            }
            buff.append('\"');
            ret = buff.toString();
        }
        return ret;
    }

    public String unescape(String line) {
        int n2 = line.length();
        StringBuilder buffer = new StringBuilder(n2);
        int i2 = 0;
        while (i2 < n2) {
            char c2;
            if ((c2 = line.charAt(i2++)) == '\\') {
                int next;
                if ((next = this.unescapeBinary(buffer, c2 = line.charAt(i2++), line, i2)) == i2) {
                    int idx = ESCAPE_LETTERS.indexOf(c2);
                    if (idx >= 0) {
                        c2 = ESCAPEABLE_CHARS.charAt(idx);
                    }
                    buffer.append(c2);
                    continue;
                }
                i2 = next;
                continue;
            }
            buffer.append(c2);
        }
        return buffer.toString();
    }

    public String unquote(String value) {
        StringBuilder buff = new StringBuilder();
        boolean escape = false;
        for (int i2 = 1; i2 < value.length() - 1; ++i2) {
            char c2 = value.charAt(i2);
            if (c2 == '\\') {
                if (!escape) {
                    escape = true;
                    continue;
                }
                escape = false;
            }
            buff.append(c2);
        }
        return buff.toString();
    }

    void escapeBinary(StringBuilder buff, char c2) {
        buff.append("\\u");
        buff.append(HEX[c2 >>> 12 & 0xF]);
        buff.append(HEX[c2 >>> 8 & 0xF]);
        buff.append(HEX[c2 >>> 4 & 0xF]);
        buff.append(HEX[c2 & 0xF]);
    }

    int unescapeBinary(StringBuilder buff, char escapeType, String line, int index) {
        int ret = index;
        if (escapeType == 'u') {
            try {
                buff.append((char)Integer.parseInt(line.substring(index, index + 4), 16));
                ret = index + 4;
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Malformed \\uxxxx encoding.", x);
            }
        }
        return ret;
    }
}

