/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.data;

import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.data.ValueFilter;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.PlainValue;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicVariableImpl
implements DynamicVariable {
    private static final long serialVersionUID = -7985397187206803090L;
    private static final transient Logger logger = Logger.getLogger(DynamicVariableImpl.class.getName());
    private String name;
    private Value value;
    private String conditionid;
    private List<ValueFilter> filters;
    private boolean checkonce = false;
    private boolean autounset = true;
    private boolean ignorefailure = true;
    private transient String currentValue;
    private transient boolean checked = false;

    public DynamicVariableImpl() {
    }

    public DynamicVariableImpl(String name, String value) {
        this.setName(name);
        this.setValue(new PlainValue(value));
    }

    @Override
    public void addFilter(ValueFilter filter) {
        if (this.filters == null) {
            this.filters = new LinkedList<ValueFilter>();
        }
        this.filters.add(filter);
    }

    @Override
    public List<ValueFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("No dynamic variable name defined");
        }
        if (this.value == null) {
            throw new Exception("No dynamic variable value defined for variable " + this.name);
        }
        this.value.validate();
        if (this.filters != null) {
            for (ValueFilter filter : this.filters) {
                filter.validate();
            }
        }
    }

    private String filterValue(String value, VariableSubstitutor ... substitutors) throws Exception {
        String newValue = value;
        if (value != null && this.filters != null) {
            logger.fine("Dynamic variable before filtering: " + this.name + "=" + newValue);
            for (ValueFilter filter : this.filters) {
                newValue = filter.filter(newValue, substitutors);
                logger.fine("Dynamic variable after applying filter " + filter.getClass().getSimpleName() + ": " + this.name + "=" + newValue);
            }
        }
        return newValue;
    }

    @Override
    public String evaluate(VariableSubstitutor ... substitutors) throws Exception {
        String newValue = this.currentValue;
        if (this.value == null) {
            return null;
        }
        if (this.checkonce && this.checked) {
            return this.filterValue(this.currentValue, substitutors);
        }
        try {
            newValue = this.value.resolve(substitutors);
            if (this.checkonce) {
                this.currentValue = newValue;
            }
            newValue = this.filterValue(newValue, substitutors);
        }
        catch (Exception e2) {
            if (!this.isIgnoreFailure()) {
                throw e2;
            }
            logger.log(Level.FINE, "Error evaluating dynamic variable '" + this.getName() + "': " + e2, e2);
            return null;
        }
        return newValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public void setValue(Value value) {
        if (value != null) {
            this.value = value;
        }
    }

    @Override
    public String getConditionid() {
        return this.conditionid;
    }

    @Override
    public void setConditionid(String conditionid) {
        if (conditionid != null) {
            this.conditionid = conditionid;
        }
    }

    @Override
    public boolean isCheckonce() {
        return this.checkonce;
    }

    @Override
    public void setCheckonce(boolean checkonce) {
        this.checkonce = checkonce;
    }

    @Override
    public boolean isAutoUnset() {
        return this.autounset;
    }

    @Override
    public void setAutoUnset(boolean autounset) {
        this.autounset = autounset;
    }

    public boolean isIgnoreFailure() {
        return this.ignorefailure;
    }

    @Override
    public void setIgnoreFailure(boolean ignore) {
        this.ignorefailure = ignore;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DynamicVariable)) {
            return false;
        }
        DynamicVariable compareObj = (DynamicVariable)obj;
        if (!this.name.equals(compareObj.getName())) {
            return false;
        }
        if (!(this.conditionid == null && compareObj.getConditionid() == null || this.conditionid != null && this.conditionid.equals(compareObj.getConditionid()))) {
            return false;
        }
        if (this.checkonce != compareObj.isCheckonce()) {
            return false;
        }
        if (this.autounset != compareObj.isAutoUnset()) {
            return false;
        }
        if (!(this.value == null && compareObj.getValue() == null || this.value != null && this.value.equals(compareObj.getValue()))) {
            return false;
        }
        List<ValueFilter> compareFilters = compareObj.getFilters();
        return !(this.filters != null && compareFilters != null ? !this.filters.containsAll(compareFilters) || !compareFilters.containsAll(this.filters) : this.filters != null && compareFilters == null || this.filters == null && compareFilters != null);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("name: " + this.name + ", condition: " + this.conditionid + ", checkonce: " + this.checkonce + ", unset: " + this.autounset);
        if (this.value != null) {
            ret.append(", value: " + this.value.toString());
        }
        if (this.filters != null) {
            ret.append(", filters: ");
            boolean appended = false;
            for (ValueFilter valueFilter : this.filters) {
                if (appended) {
                    ret.append(",");
                }
                ret.append(valueFilter.toString());
                appended = true;
            }
        }
        return ret.toString();
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setChecked() {
        this.checked = true;
    }

    @Override
    public Set<String> getVarRefs(RulesEngine rulesEngine) {
        Condition condition;
        Set<String> vars = this.value.getVarRefs();
        if (this.conditionid != null && (condition = rulesEngine.getCondition(this.conditionid)) != null) {
            vars.addAll(condition.getVarRefs());
        }
        return vars;
    }
}

