/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.substitutor;

import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.util.IoHelper;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;

public class VariableSubstitutorReader
extends Reader {
    private PushbackReader pushbackReader = null;
    private final Variables variables;
    private SubstitutionType type;
    private boolean bracesRequired = false;
    private char variable_start = (char)36;
    private char variable_end = '\u0000';
    private boolean inBraces = false;
    private final StringBuilder varNameBuffer = new StringBuilder();
    private String varValue = null;
    private int varValueIndex = 0;

    public VariableSubstitutorReader(Reader source, Variables variables, SubstitutionType type, boolean bracesRequired) {
        this(source, variables, type);
        this.bracesRequired = bracesRequired;
    }

    public VariableSubstitutorReader(Reader source, Variables variables, SubstitutionType type) {
        this.pushbackReader = new PushbackReader(source);
        this.variables = variables;
        this.type = type;
        if (type == null) {
            type = SubstitutionType.getDefault();
        }
        switch (type) {
            case TYPE_SHELL: {
                this.variable_start = (char)37;
                break;
            }
            case TYPE_AT: {
                this.variable_start = (char)64;
                break;
            }
            case TYPE_ANT: {
                this.variable_start = (char)64;
                this.variable_end = (char)64;
                break;
            }
        }
    }

    public boolean isBracesRequired() {
        return this.bracesRequired;
    }

    public void setBracesRequired(boolean braces) {
        this.bracesRequired = braces;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw new RuntimeException("Operation Not Supported");
    }

    @Override
    public int read() throws IOException {
        int data;
        if (this.varValue != null) {
            if (this.varValueIndex < this.varValue.length()) {
                return this.varValue.charAt(this.varValueIndex++);
            }
            if (this.varValueIndex == this.varValue.length()) {
                this.varValue = null;
                this.varValueIndex = 0;
            }
        }
        if ((data = this.pushbackReader.read()) != this.variable_start) {
            return data;
        }
        data = this.pushbackReader.read();
        if (data == 123) {
            this.inBraces = true;
        } else if (this.bracesRequired) {
            this.pushbackReader.unread(data);
            return this.variable_start;
        }
        this.varNameBuffer.delete(0, this.varNameBuffer.length());
        if (!this.inBraces && data != -1) {
            this.varNameBuffer.append((char)data);
        }
        data = this.pushbackReader.read();
        while (data >= 32 && this.inBraces && data != 125 || this.inBraces && (data == 91 || data == 93) || VariableSubstitutorReader.isAllowedCharInVariableName(data)) {
            this.varNameBuffer.append((char)data);
            data = this.pushbackReader.read();
        }
        boolean variable = this.wasItPlausibleVariableName(data);
        String name = this.varNameBuffer.toString();
        if (variable && name.length() > 0) {
            if (this.inBraces && name.startsWith("ENV[") && name.lastIndexOf(93) == name.length() - 1) {
                this.varValue = IoHelper.getenv(name.substring(4, name.length() - 1));
                if (this.varValue == null) {
                    this.varValue = "";
                }
            } else {
                this.varValue = this.inBraces && name.startsWith("SYSTEM[") && name.lastIndexOf(93) == name.length() - 1 ? System.getProperty(name.substring(7, name.length() - 1)) : (this.inBraces && name.startsWith("SYSTEM_") && name.length() > 7 ? System.getProperty(name.substring(7).replace('_', '.')) : this.variables.get(name));
            }
        }
        boolean unclosedBraces = false;
        if (data <= 32) {
            if (data != -1) {
                this.pushbackReader.unread(data);
            }
            unclosedBraces = true;
        } else if (data == this.variable_start && this.variable_start != this.variable_end || !VariableSubstitutorReader.isAllowedCharInVariableName(data) && data != 125 && data != this.variable_end) {
            this.pushbackReader.unread(data);
        }
        this.varValue = this.varValue == null ? this.variable_start + (this.inBraces ? "{" : "") + this.varNameBuffer.toString() + (this.inBraces && !unclosedBraces ? "}" : "") + (this.variable_end != '\u0000' && variable ? Character.valueOf(this.variable_end) : "") : this.escapeSpecialChars(this.varValue);
        this.inBraces = false;
        if (this.varValue.length() == 0) {
            return this.read();
        }
        return this.varValue.charAt(this.varValueIndex++);
    }

    private boolean wasItPlausibleVariableName(int data) throws IOException {
        if (this.variable_end == '\u0000') {
            return !this.inBraces || data == 125;
        }
        if (this.inBraces) {
            if (data != 125) {
                return false;
            }
            int nextData = this.pushbackReader.read();
            if (nextData == -1) {
                return false;
            }
            if (this.variable_end == nextData) {
                return true;
            }
            this.pushbackReader.unread(nextData);
            return false;
        }
        return this.variable_end == data;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int charsRead = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int nextChar = this.read();
            if (nextChar == -1) {
                if (charsRead != 0) break;
                charsRead = -1;
                break;
            }
            charsRead = i2 + 1;
            cbuf[off + i2] = (char)nextChar;
        }
        return charsRead;
    }

    @Override
    public void close() throws IOException {
        this.pushbackReader.close();
    }

    @Override
    public long skip(long n2) throws IOException {
        throw new RuntimeException("Operation Not Supported");
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushbackReader.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new RuntimeException("Operation Not Supported");
    }

    @Override
    public void reset() throws IOException {
        throw new RuntimeException("Operation Not Supported");
    }

    private static boolean isAllowedCharInVariableName(int c2) {
        return c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 >= 48 && c2 <= 57 || c2 == 95 || c2 == 46 || c2 == 45;
    }

    private String escapeSpecialChars(String str) {
        if (this.type == null) {
            this.type = SubstitutionType.getDefault();
        }
        switch (this.type) {
            case TYPE_AT: 
            case TYPE_ANT: 
            case TYPE_PLAIN: {
                return str;
            }
            case TYPE_SHELL: {
                return str.replace("\r", "");
            }
            case TYPE_JAVA_PROPERTIES: 
            case TYPE_JAVA: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                boolean leading = true;
                for (int i2 = 0; i2 < len; ++i2) {
                    char c2 = buffer.charAt(i2);
                    if (this.type.equals((Object)SubstitutionType.TYPE_JAVA_PROPERTIES)) {
                        if (c2 == '\t' || c2 == '\n' || c2 == '\r') {
                            char tag = c2 == '\t' ? (char)'t' : (c2 == '\n' ? (char)'n' : 'r');
                            buffer.replace(i2, i2 + 1, "\\" + tag);
                            ++len;
                            ++i2;
                            continue;
                        }
                        if (c2 == ' ') {
                            if (!leading) continue;
                            buffer.insert(i2, '\\');
                            ++len;
                            ++i2;
                            continue;
                        }
                        if (c2 == '\\' || c2 == '\"' || c2 == '\'') {
                            leading = false;
                            buffer.insert(i2, '\\');
                            ++len;
                            ++i2;
                            continue;
                        }
                        leading = false;
                        continue;
                    }
                    if (c2 != '\\') continue;
                    buffer.replace(i2, i2 + 1, "\\\\");
                    ++len;
                    ++i2;
                }
                return buffer.toString();
            }
            case TYPE_XML: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i3 = 0; i3 < len; ++i3) {
                    String r2 = null;
                    char c3 = buffer.charAt(i3);
                    switch (c3) {
                        case '<': {
                            r2 = "&lt;";
                            break;
                        }
                        case '>': {
                            r2 = "&gt;";
                            break;
                        }
                        case '&': {
                            r2 = "&amp;";
                            break;
                        }
                        case '\'': {
                            r2 = "&apos;";
                            break;
                        }
                        case '\"': {
                            r2 = "&quot;";
                        }
                    }
                    if (r2 == null) continue;
                    buffer.replace(i3, i3 + 1, r2);
                    len = buffer.length();
                    i3 += r2.length() - 1;
                }
                return buffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + (Object)((Object)this.type));
    }
}

