/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class FlowLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int align) {
        this(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int align) {
        this.newAlign = align;
        switch (align) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = align;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component component = target.getComponent(i2);
                if (!component.isVisible()) continue;
                Dimension preferredSize = component.getPreferredSize();
                dimension.height = Math.max(dimension.height, preferredSize.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dimension.width += this.hgap;
                }
                dimension.width += preferredSize.width;
            }
            Insets insets = target.getInsets();
            dimension.width += insets.left + insets.right + this.hgap * 2;
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component component = target.getComponent(i2);
                if (!component.isVisible()) continue;
                Dimension minimumSize = component.getMinimumSize();
                dimension.height = Math.max(dimension.height, minimumSize.height);
                if (i2 > 0) {
                    dimension.width += this.hgap;
                }
                dimension.width += minimumSize.width;
            }
            Insets insets = target.getInsets();
            dimension.width += insets.left + insets.right + this.hgap * 2;
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            for (int i2 = rowStart; i2 < rowEnd; ++i2) {
                Component component = target.getComponent(i2);
                if (!component.isVisible()) continue;
                if (ltr) {
                    component.setLocation(x, y + (height - component.getSize().height) / 2);
                } else {
                    component.setLocation(target.getSize().width - x - component.getSize().width, y + (height - component.getSize().height) / 2);
                }
                x += component.getSize().width + this.hgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxWidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
            int nMembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.vgap;
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i2 = 0; i2 < nMembers; ++i2) {
                Component component = target.getComponent(i2);
                if (!component.isVisible()) continue;
                Dimension preferredSize = component.getPreferredSize();
                component.setSize(preferredSize.width, preferredSize.height);
                if (x == 0 || x + preferredSize.width <= maxWidth) {
                    if (x > 0) {
                        x += this.hgap;
                    }
                    x += preferredSize.width;
                    rowh = Math.max(rowh, preferredSize.height);
                    continue;
                }
                this.moveComponents(target, insets.left, y, maxWidth - x, rowh, start, i2, ltr);
                x = preferredSize.width;
                y += this.vgap + rowh;
                rowh = preferredSize.height;
                start = i2;
            }
            this.moveComponents(target, insets.left, y, maxWidth - x, rowh, start, nMembers, ltr);
        }
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
                break;
            }
            case 3: {
                str = ",align=leading";
                break;
            }
            case 4: {
                str = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

