/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.panels.packs.PacksPanelAutomationHelper;
import com.izforge.izpack.util.Console;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class PacksConsolePanel
extends AbstractConsolePanel
implements ConsolePanel {
    private Messages messages;
    private HashMap<String, Pack> names;
    private List<Pack> selectedPacks;
    private final Prompt prompt;
    private final InstallData installData;

    public PacksConsolePanel(PanelView<ConsolePanel> panel, InstallData installData, Prompt prompt) {
        super(panel);
        this.prompt = prompt;
        this.installData = installData;
        try {
            this.messages = installData.getMessages().newMessages("packsLang.xml");
        }
        catch (ResourceNotFoundException exception) {
            this.messages = installData.getMessages();
        }
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        this.out(Prompt.Type.INFORMATION, installData.getMessages().get("PacksPanel.info", new Object[0]));
        this.out(Prompt.Type.INFORMATION, "");
        this.selectedPacks = new LinkedList<Pack>();
        this.computePacks(installData.getAvailablePacks());
        for (String key : this.names.keySet()) {
            this.drawHelper(key);
        }
        this.out(Prompt.Type.INFORMATION, "Done!");
        installData.setSelectedPacks(this.selectedPacks);
        if (this.selectedPacks.isEmpty()) {
            this.out(Prompt.Type.WARNING, "You have not selected any packs!");
            return this.promptRerunPanel(installData, console);
        }
        return this.promptEndPanel(installData, console);
    }

    private void out(Prompt.Type type, String message) {
        this.prompt.message(type, message);
    }

    private void drawHelper(String pack) {
        Pack p2 = this.names.get(pack);
        String packName = PackHelper.getPackName(p2, this.messages);
        if (this.installData.getRules().canInstallPack(pack, this.installData.getVariables())) {
            if (p2.isRequired()) {
                if (!p2.isHidden()) {
                    this.out(Prompt.Type.INFORMATION, "  [x] Pack '" + packName + "' required");
                }
                this.selectedPacks.add(p2);
            } else {
                boolean contained = this.installData.getSelectedPacks().contains(p2);
                String cbView = contained ? "x" : " ";
                if (this.askUser("  [" + cbView + "] Include optional pack '" + packName + "'", contained ? Prompt.Option.YES : Prompt.Option.NO)) {
                    this.selectedPacks.add(p2);
                }
            }
        }
    }

    private boolean askUser(String message, Prompt.Option defaultOption) {
        return Prompt.Option.YES == this.prompt.confirm(Prompt.Type.QUESTION, message, Prompt.Options.YES_NO, defaultOption);
    }

    private void computePacks(List<Pack> packs) {
        this.names = new LinkedHashMap<String, Pack>();
        for (Pack pack : packs) {
            this.names.put(pack.getName(), pack);
        }
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        new PacksPanelAutomationHelper().createInstallationRecord(this.installData, panelRoot);
    }
}

