/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.search;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.GUIPrompt;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.userinput.field.search.ResultType;
import com.izforge.izpack.panels.userinput.field.search.SearchField;
import com.izforge.izpack.panels.userinput.field.search.SearchType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SearchInputField
implements ActionListener {
    private static final Logger logger = Logger.getLogger(SearchInputField.class.getName());
    private final SearchField field;
    private final String filename;
    private final String checkFilename;
    private final JButton autodetectButton;
    private final JButton browseButton;
    private final JComboBox pathComboBox;
    private final SearchType searchType;
    private final ResultType resultType;
    private final InstallerFrame parent;
    private final InstallData installData;

    public SearchInputField(final SearchField field, final InstallerFrame parent, JComboBox combobox, JButton autobutton, JButton browsebutton, InstallData installData) {
        this.field = field;
        this.filename = field.getFilename();
        this.checkFilename = field.getCheckFilename();
        this.parent = parent;
        this.autodetectButton = autobutton;
        this.browseButton = browsebutton;
        this.pathComboBox = combobox;
        this.searchType = field.getType();
        this.resultType = field.getResultType();
        this.installData = installData;
        this.autodetectButton.addActionListener(this);
        this.browseButton.addActionListener(this);
        final JTextField editor = (JTextField)this.pathComboBox.getEditor().getEditorComponent();
        editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e2) {
                this.checkNextButtonState();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.checkNextButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.checkNextButtonState();
            }

            private void checkNextButtonState() {
                Document doc = editor.getDocument();
                try {
                    if (field.pathMatches(doc.getText(0, doc.getLength()))) {
                        parent.unlockNextButton(false);
                    } else {
                        parent.lockNextButton();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean autodetect() {
        String selected;
        for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
            if (!this.field.pathMatches((String)this.pathComboBox.getItemAt(x))) continue;
            this.pathComboBox.setSelectedIndex(x);
            break;
        }
        if ((selected = (String)this.pathComboBox.getSelectedItem()) == null) {
            this.parent.lockNextButton();
            return false;
        }
        boolean found = false;
        for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
            if (!this.pathComboBox.getItemAt(x).equals(selected)) continue;
            found = true;
        }
        if (!found) {
            this.pathComboBox.addItem(selected);
        }
        ArrayList<String> currentItems = new ArrayList<String>();
        for (int i2 = 0; i2 < this.pathComboBox.getItemCount(); ++i2) {
            currentItems.add((String)this.pathComboBox.getItemAt(i2));
        }
        List<String> items = this.field.getChoices(currentItems);
        items = new ArrayList<String>(new LinkedHashSet<String>(items));
        this.pathComboBox.removeAllItems();
        for (String item : items) {
            item = this.installData.getVariables().replace(item);
            this.pathComboBox.addItem(item);
        }
        for (int i3 = 0; i3 < this.pathComboBox.getItemCount(); ++i3) {
            String path = (String)this.pathComboBox.getItemAt(i3);
            if (!this.field.pathMatches(path)) continue;
            this.pathComboBox.setSelectedIndex(i3);
            this.parent.unlockNextButton();
            return true;
        }
        if (this.field.pathMatches((String)this.pathComboBox.getSelectedItem())) {
            this.parent.unlockNextButton();
            return true;
        }
        this.parent.lockNextButton();
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.autodetectButton) {
            if (!this.autodetect()) {
                this.warning("UserInputPanel.search.autodetect.failed.caption", "UserInputPanel.search.autodetect.failed.message");
            }
        } else if (source == this.browseButton) {
            int result;
            File dir;
            String startingPath;
            JFileChooser chooser = new JFileChooser();
            if (this.resultType != ResultType.FILE) {
                chooser.setFileSelectionMode(1);
            }
            if ((startingPath = (String)this.pathComboBox.getSelectedItem()) == null && this.pathComboBox.getItemCount() != 0) {
                startingPath = (String)this.pathComboBox.getItemAt(0);
            }
            if (startingPath != null && (dir = new File(startingPath)).exists()) {
                chooser.setCurrentDirectory(dir);
            }
            if ((result = chooser.showOpenDialog(this.parent)) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.pathComboBox.setSelectedItem(selectedFile.getAbsolutePath());
                if (this.resultType != ResultType.FILE && !this.field.pathMatches(selectedFile.getAbsolutePath())) {
                    this.warning("UserInputPanel.search.wrongselection.caption", "UserInputPanel.search.wrongselection.message");
                }
            }
        }
    }

    public String getResult() {
        return this.field.getResult((String)this.pathComboBox.getSelectedItem());
    }

    public void setResult(String item) {
        this.pathComboBox.setSelectedItem(item);
    }

    private void warning(String title, String message) {
        Messages messages = this.parent.getMessages();
        title = messages.get(title, new Object[0]);
        message = messages.get(message, new Object[0]);
        new GUIPrompt().message(Prompt.Type.WARNING, title, message);
    }
}

