/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.util.Strings;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    public Map<String, PluginEntry> getCategory(String category) {
        String key = Strings.toRootLowerCase(category);
        return this.categories.computeIfAbsent(key, ignored -> new TreeMap());
    }

    public void writeCache(OutputStream os) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(os));){
            out.writeInt(this.categories.size());
            for (Map.Entry<String, Map<String, PluginEntry>> category : this.categories.entrySet()) {
                out.writeUTF(category.getKey());
                Map<String, PluginEntry> m2 = category.getValue();
                out.writeInt(m2.size());
                for (Map.Entry<String, PluginEntry> entry : m2.entrySet()) {
                    PluginEntry plugin = entry.getValue();
                    out.writeUTF(plugin.getKey());
                    out.writeUTF(plugin.getClassName());
                    out.writeUTF(plugin.getName());
                    out.writeBoolean(plugin.isPrintable());
                    out.writeBoolean(plugin.isDefer());
                }
            }
        }
    }

    public void loadCacheFiles(Enumeration<URL> resources) throws IOException {
        this.categories.clear();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(url.openStream()));){
                int count = in.readInt();
                for (int i2 = 0; i2 < count; ++i2) {
                    String category = in.readUTF();
                    Map<String, PluginEntry> m2 = this.getCategory(category);
                    int entries = in.readInt();
                    for (int j2 = 0; j2 < entries; ++j2) {
                        String key = in.readUTF();
                        String className = in.readUTF();
                        String name = in.readUTF();
                        boolean printable = in.readBoolean();
                        boolean defer = in.readBoolean();
                        m2.computeIfAbsent(key, k2 -> {
                            PluginEntry entry = new PluginEntry();
                            entry.setKey((String)k2);
                            entry.setClassName(className);
                            entry.setName(name);
                            entry.setPrintable(printable);
                            entry.setDefer(defer);
                            entry.setCategory(category);
                            return entry;
                        });
                    }
                }
            }
        }
    }

    public int size() {
        return this.categories.size();
    }
}

