/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.InjectionFactory;
import org.picocontainer.Injector;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.MethodInjection;
import org.picocontainer.injectors.Reinjection;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reinjector {
    private final PicoContainer parent;
    private final ComponentMonitor monitor;
    private static NullLifecycleStrategy NO_LIFECYCLE = new NullLifecycleStrategy();
    private static Properties NO_PROPERTIES = new Properties();

    public Reinjector(PicoContainer parentContainer) {
        this(parentContainer, parentContainer instanceof ComponentMonitorStrategy ? ((ComponentMonitorStrategy)((Object)parentContainer)).currentMonitor() : new NullComponentMonitor());
    }

    public Reinjector(PicoContainer parentContainer, ComponentMonitor monitor) {
        this.parent = parentContainer;
        this.monitor = monitor;
    }

    public Object reinject(Class<?> key, Method reinjectionMethod) {
        return this.reinject(key, key, this.parent.getComponent(key), NO_PROPERTIES, new MethodInjection(reinjectionMethod));
    }

    public Object reinject(Class<?> key, Enum reinjectionMethodEnum) {
        return this.reinject(key, key, this.parent.getComponent(key), NO_PROPERTIES, new MethodInjection(this.toMethod(reinjectionMethodEnum)));
    }

    private Method toMethod(final Enum reinjectionMethodEnum) {
        Object methodOrException = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return reinjectionMethodEnum.getClass().getMethod("toMethod", new Class[0]).invoke((Object)reinjectionMethodEnum, new Object[0]);
                }
                catch (IllegalAccessException e2) {
                    return new PicoCompositionException("Illegal access to " + reinjectionMethodEnum.name());
                }
                catch (InvocationTargetException e3) {
                    return new PicoCompositionException("Invocation Target Exception " + reinjectionMethodEnum.name(), e3.getCause());
                }
                catch (NoSuchMethodException e4) {
                    return new PicoCompositionException("Expected generated method toMethod() on enum");
                }
            }
        });
        if (methodOrException instanceof Method) {
            return (Method)methodOrException;
        }
        throw (PicoCompositionException)methodOrException;
    }

    public Object reinject(Class<?> key, InjectionFactory reinjectionFactory) {
        Object o2 = this.reinject(key, key, this.parent.getComponent(key), NO_PROPERTIES, reinjectionFactory);
        return o2;
    }

    public Object reinject(Class<?> key, Class<?> impl, InjectionFactory reinjectionFactory) {
        return this.reinject(key, impl, this.parent.getComponent(key), NO_PROPERTIES, reinjectionFactory);
    }

    public Object reinject(Class<?> key, Class implementation, Object instance, InjectionFactory reinjectionFactory) {
        return this.reinject(key, implementation, instance, NO_PROPERTIES, reinjectionFactory);
    }

    public Object reinject(Class<?> key, Class implementation, Object instance, Properties properties, InjectionFactory reinjectionFactory) {
        Reinjection reinjection = new Reinjection(reinjectionFactory, this.parent);
        Injector injector = (Injector)reinjection.createComponentAdapter(this.monitor, NO_LIFECYCLE, properties, key, implementation, null);
        return injector.decorateComponentInstance(this.parent, null, instance);
    }
}

