/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.parameters.AbstractParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultConstructorParameter
extends AbstractParameter
implements Parameter,
Serializable {
    public static final DefaultConstructorParameter INSTANCE = new DefaultConstructorParameter();

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    @Override
    public Parameter.Resolver resolve(PicoContainer container, ComponentAdapter<?> forAdapter, ComponentAdapter<?> injecteeAdapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        return new Parameter.NotResolved();
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        if (!(expectedType instanceof Class)) {
            throw new ClassCastException("Unable to use except for class types.  Offending type: " + expectedType);
        }
        Class type = (Class)expectedType;
        try {
            Constructor constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalArgumentException("No default constructor for type " + expectedType, e2);
        }
    }

    public String toString() {
        return "Force Default Constructor Parameter";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other.getClass().getName().equals(this.getClass().getName());
    }
}

