/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher;

import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebClient;
import au.com.nemmco.Util.WebContent;
import au.com.nemmco.Util.WebHttpResponse;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrBatcherAPIExecuteThread {
    private static Logger logger = LoggerFactory.getLogger(AppPdrBatcherAPIExecuteThread.class);

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        try {
            String string;
            Object object;
            Options options = new Options();
            options.addRequiredOption("t", "thread", true, "Thread ID to execute");
            options.addOption("c", "configuration", true, "The properties configuration file");
            options.addOption("h", "host", true, "The host on which the applications is running");
            options.addOption("p", "port", true, "The port on which the applications web services are exposed");
            options.addOption("a", "api", true, "The aPI key to access the applications web services");
            DefaultParser defaultParser = new DefaultParser();
            CommandLine commandLine = null;
            try {
                commandLine = defaultParser.parse(options, stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                object = new HelpFormatter();
                object.printHelp("AppPdrBatcherAPIExecuteThread", options);
                System.exit(1);
            }
            String string2 = commandLine.getOptionValue("thread");
            if (!Util.isInteger(string2)) {
                throw new Exception("Thread ID Parameter must be an integer");
            }
            object = new Properties();
            String string3 = commandLine.getOptionValue("configuration", pdrBatcher.PROPERTIES_FILE);
            if (!Util.isBlank(string3)) {
                try {
                    object = Util.getPropertiesObject(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Util.isBlank(string = commandLine.getOptionValue("host", "localhost"))) {
                throw new Exception("Host is not defined");
            }
            String string4 = commandLine.getOptionValue("port", Util.getProperty((Properties)object, "web_server_port", null));
            if (Util.isBlank(string4)) {
                throw new Exception("Port is not defined");
            }
            if (!Util.isInteger(string4)) {
                throw new Exception("Port parameter must be an integer");
            }
            String string5 = null;
            try {
                string5 = Util.getProperty("pdr_key.properties", "hash", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string5 = commandLine.getOptionValue("api", string5);
            if (Util.isBlank(string5)) {
                throw new Exception("API key is not defined");
            }
            String string6 = null;
            Integer n2 = null;
            Integer n3 = null;
            Integer n4 = null;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("http://");
            stringBuilder.append(string);
            stringBuilder.append(":");
            stringBuilder.append(string4);
            stringBuilder.append("/api/app/control");
            String string7 = "action=execute&thread_id=" + string2;
            WebClient webClient = new WebClient(string6, n2, n3, n4);
            WebHttpResponse webHttpResponse = webClient.doPost(new URL(stringBuilder.toString()), string5, WebContent.MediaType.TEXT_PLAIN, string7);
            if (webHttpResponse.ReturnCode != 200) {
                throw new Exception(webHttpResponse.Body);
            }
            bl = true;
            Util_Logger.info(logger, webHttpResponse.Body);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error calling batcher thread execution API: " + exception.getMessage(), exception);
        }
        System.exit(bl ? 0 : 1);
    }
}

