/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.Util;

import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherTokenResolver {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherTokenResolver.class);

    public static String process(String string, FtpFileInfo ftpFileInfo) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", ftpFileInfo.getName());
        hashMap.put("ext", ftpFileInfo.getExtension());
        return pdrBatcherTokenResolver.process(string, hashMap);
    }

    public static String process(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return pdrBatcherTokenResolver.process(string, hashMap);
    }

    public static String process(String string, Map<String, String> map) {
        Pattern pattern = Pattern.compile("\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = null;
            if (string2.toLowerCase().startsWith("date:")) {
                String[] stringArray = string2.split(":");
                Date date = new Date();
                String string4 = stringArray[stringArray.length - 1];
                if (stringArray.length == 3) {
                    int n3 = Integer.parseInt(stringArray[1]);
                    date = Util.dateOffset(date, n3, 5);
                }
                string3 = Util.dateToStr(date, string4);
            } else if (map != null) {
                string3 = map.get(string2.toLowerCase());
            }
            stringBuilder.append(string.substring(n2, matcher.start()));
            if (string3 == null) {
                stringBuilder.append(matcher.group(0));
                Util_Logger.warning(logger, "Unable to resolve token [" + matcher.group(0) + "] in [" + string + "]");
            } else {
                stringBuilder.append(string3);
            }
            n2 = matcher.end();
        }
        stringBuilder.append(string.substring(n2, string.length()));
        return stringBuilder.toString();
    }
}

