/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process;

import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessBase;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Process.pdrBatcherHandlerAseXMLProcessInt;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.ZipFileInfo;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.xmlTransactionFileParser;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerAseXMLProcessSend
extends pdrBatcherHandlerAseXMLProcessBase
implements pdrBatcherHandlerAseXMLProcessInt {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLProcessSend.class);
    private String dataSource;
    private String holdingDirectory;
    private String aemoInboxDirectory;
    private Map<String, Date> aemoStopbox;

    public pdrBatcherHandlerAseXMLProcessSend(String string, String string2, Map<String, Date> map, int n2) throws Exception {
        super(n2);
        this.dataSource = string;
        this.holdingDirectory = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_holding_dir");
        this.aemoInboxDirectory = string2;
        this.aemoStopbox = map;
    }

    private boolean isB2BFileType(FtpFileInfo ftpFileInfo) {
        boolean bl = false;
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        for (String string : batcherDOMParserFactory.getB2BFileTypes(this.dataSource)) {
            if (!ftpFileInfo.getName().toUpperCase().startsWith(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkReceivingParticipantIsStopped(pdrConnectionInt pdrConnectionInt2, FtpFileInfo ftpFileInfo) {
        boolean bl = false;
        if (this.isB2BFileType(ftpFileInfo) && this.aemoStopbox.size() > 0) {
            String string = this.holdingDirectory + "/" + ftpFileInfo.getFilename();
            try {
                pdrConnectionInt2.getFile(ftpFileInfo.getDirectory(), this.holdingDirectory, ftpFileInfo.getFilename(), ftpFileInfo.getModifiedDate());
                xmlTransactionFileParser xmlTransactionFileParser2 = new xmlTransactionFileParser(this.dataSource, this.holdingDirectory);
                ZipFileInfo zipFileInfo = xmlTransactionFileParser2.Parse(string);
                Date date = this.aemoStopbox.get(zipFileInfo.getToName().toUpperCase());
                if (date != null) {
                    Util_Logger.warning(logger, "Not sending B2B file " + ftpFileInfo.getFilename() + " as participant " + zipFileInfo.getToName() + " was stopped as of " + Util.dateToStr(date, "dd-MM-yyyy HH:mm:ss"));
                    bl = true;
                }
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error checking B2B stopbox status for delivery of file " + ftpFileInfo.getFilename() + ": " + exception.getMessage());
                bl = true;
            }
            finally {
                try {
                    FileUtilities.deleteFile(string);
                }
                catch (Exception exception) {
                    Util_Logger.warning(logger, "Error removing temporary B2B file " + string + " from holding directory: " + exception.getMessage(), exception);
                }
            }
        }
        return false;
    }

    @Override
    public void doProcessing(pdrConnectionInt pdrConnectionInt2, pdrConnectionInt pdrConnectionInt3, FtpFileInfo ftpFileInfo, List<pdrFileTranslationInt> list) throws Exception {
        if (!this.checkReceivingParticipantIsStopped(pdrConnectionInt3, ftpFileInfo)) {
            pdrConnectionInt2.putFile(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename(), this.aemoInboxDirectory, ftpFileInfo.getModifiedDate(), false);
            String string = this.calcFilename(ftpFileInfo, "SENT");
            pdrConnectionInt3.renameFile(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename(), ftpFileInfo.getDirectory(), string);
        }
    }
}

