/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml;

import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParser;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.Xml.BatcherDOMParserFactory;
import au.com.nemmco.Util.Util_Logger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class AckFileParser {
    private static Logger logger = LoggerFactory.getLogger(AckFileParser.class);
    private String itsDataSource;

    public AckFileParser(String string) {
        this.itsDataSource = string;
    }

    public String validateAckFile(String string) {
        String string2 = "Negative";
        try {
            BatcherDOMParser batcherDOMParser = BatcherDOMParserFactory.getInstance().getParser(this.itsDataSource);
            Document document = batcherDOMParser.createDocument(string, true);
            if (this.isAcceptMessageStatus(document)) {
                string2 = "Positive";
            } else if (this.isResendMessageStatus(document)) {
                string2 = "Resend";
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Can not parse ACK file - " + string, exception);
        }
        return string2;
    }

    private boolean isAcceptMessageStatus(Document document) {
        boolean bl = false;
        NodeList nodeList = document.getElementsByTagName("MessageAcknowledgement");
        if (nodeList == null || nodeList.getLength() <= 0) {
            return bl;
        }
        int n2 = nodeList.getLength();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            Element element = (Element)nodeList.item(i2);
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap.getNamedItem("status") == null) continue;
            int n3 = namedNodeMap.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                Attr attr = (Attr)namedNodeMap.item(i3);
                if (!attr.getNodeName().equals("status")) continue;
                if (attr.getNodeValue().equals("Accept")) {
                    bl = true;
                    continue block0;
                }
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    private boolean isResendMessageStatus(Document document) {
        boolean bl = false;
        NodeList nodeList = document.getElementsByTagName("Code");
        if (nodeList == null || nodeList.getLength() <= 0) {
            return bl;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element element = (Element)nodeList.item(i2);
            if (!"111".equalsIgnoreCase(element.getFirstChild().getNodeValue())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isAcceptTransactionStatus(Document document) {
        boolean bl = false;
        NodeList nodeList = document.getElementsByTagName("TransactionAcknowledgement");
        if (nodeList == null || nodeList.getLength() <= 0) {
            return bl;
        }
        int n2 = nodeList.getLength();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            Element element = (Element)nodeList.item(i2);
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap.getNamedItem("status") == null) continue;
            int n3 = namedNodeMap.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                Attr attr = (Attr)namedNodeMap.item(i3);
                if (!attr.getNodeName().equals("status")) continue;
                if (attr.getNodeValue().equals("Accept")) {
                    bl = true;
                    continue block0;
                }
                bl = false;
                continue block0;
            }
        }
        return bl;
    }
}

