/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.nemmco.Pdr.Batcher.Processor.Util.pdrBatcherHandlerDownloadFile;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerInt;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrDataSourceFactory;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockInt;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import au.com.nemmco.Pdr.Batcher.pdrFileEventInt;
import au.com.nemmco.Pdr.Common.pdrLockManager;
import au.com.nemmco.Pdr.Common.pdrMonitorManager;
import au.com.nemmco.Pdr.Common.pdrPerformanceJobSizeUnits;
import au.com.nemmco.Pdr.Common.pdrPerformanceRec;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpException;
import au.com.nemmco.Util.FtpFileComparatorInt;
import au.com.nemmco.Util.FtpFileComparatorManager;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.threadMonitorCPU;
import au.com.nemmco.Util.threadMonitorStatusItem;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class pdrBatcherHandlerBase
implements pdrBatcherHandlerInt {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerBase.class);
    private pdrBatcherHandlerConfig itsConfig;
    private int itsId;
    private String itsDelivery;
    private String itsOperation;
    private String[] itsIncludeFileMask;
    private String[] itsExcludeFileMask;
    private String itsFileMaskMode;
    private int itsMinFileSizeBytes;
    private int itsMaxFileSizeKB;
    private int itsPollingInterval;
    private String itsSchedulingMode;
    private String itsCronJobSchedule;
    private int itsPauseInterval;
    private int itsFailWaitInterval;
    private String itsDestinationDir;
    private String itsSourceDir;
    private String itsHoldingDir;
    private String itsSourceArchiveDir;
    private volatile boolean itsIsRunning = true;
    private volatile boolean itsIsActive = true;
    private volatile boolean itsIsReady = true;
    private volatile boolean itsIsProcessing = false;
    private volatile boolean itsIsRunningInThread = false;
    private pdrBatcher itsParent;
    private boolean itsActivityMonitor;
    private List<String> itsSubDirList;
    private boolean itsSubDirListDest;
    private char itsSourceSeparator;
    private char itsDestinationSeparator;
    private boolean itsDirectoryRecurse;
    private boolean itsDirectoryCreate;
    private int itsTrottleBytesPerSecond;
    private int itsTransferBufferSize;
    private int itsProcessLimitFiles;
    private String itsProcessOrder;
    private pdrConnectionFactoryInt itsDataSource;
    private pdrConnectionFactoryInt itsDataDestination;
    private String itsDataSourceId;
    private String itsDataDestinationId;
    private pdrFileEventInt itsFileEventHandler;
    private volatile long itsTotalFilesProcessed;
    private volatile double itsSourceTotalKiloBytesTransferred;
    private volatile double itsDestinationTotalKiloBytesTransferred;
    private volatile Date itsLastProcessTime;
    private volatile threadMonitorCPU itsCpuProcessStats;
    private String itsDestinationDirListingFile;
    private List<pdrFileTranslationInt> itsFileTranslator;
    private boolean itsCheckFileIntegrity;
    private String itsJobType;

    public pdrBatcherHandlerBase(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        this.configOverride(pdrBatcherHandlerConfig2);
        this.itsConfig = pdrBatcherHandlerConfig2;
        this.itsId = pdrBatcherHandlerConfig2.ThreadId;
        this.itsDelivery = pdrBatcherHandlerConfig2.ThreadDelivery;
        this.itsOperation = pdrBatcherHandlerConfig2.Operation;
        this.itsPollingInterval = pdrBatcherHandlerConfig2.PollingIntervalMilliSecs;
        this.itsPauseInterval = pdrBatcherHandlerConfig2.PauseIntervalSecs * 1000;
        this.itsFailWaitInterval = pdrBatcherHandlerConfig2.FailWaitIntervalSecs * 1000;
        this.itsSchedulingMode = pdrBatcherHandlerConfig2.SchedulingMode;
        this.itsCronJobSchedule = pdrBatcherHandlerConfig2.CronJobSchedule;
        this.itsTrottleBytesPerSecond = pdrBatcherHandlerConfig2.TrottleBytesPerSecond;
        this.itsTransferBufferSize = pdrBatcherHandlerConfig2.TransferBufferSize;
        this.itsProcessLimitFiles = pdrBatcherHandlerConfig2.ProcessLimitFiles;
        this.itsProcessOrder = pdrBatcherHandlerConfig2.FileProcessOrder;
        this.itsHoldingDir = pdrBatcherHandlerConfig2.HoldingDir;
        this.itsParent = pdrBatcherHandlerConfig2.Parent;
        this.itsActivityMonitor = pdrBatcherHandlerConfig2.ThreadActivityMonitor;
        this.itsFileEventHandler = pdrBatcherHandlerConfig2.FileEventHandler;
        this.itsCheckFileIntegrity = pdrBatcherHandlerConfig2.CheckFileIntegrity;
        if (pdrBatcherHandlerConfig2.SubDirList != null) {
            this.itsSubDirList = pdrBatcherHandlerConfig2.SubDirList;
        }
        this.itsSubDirListDest = pdrBatcherHandlerConfig2.SubDirListDest;
        this.itsDirectoryRecurse = pdrBatcherHandlerConfig2.DirectoryRecurse;
        this.itsDirectoryCreate = pdrBatcherHandlerConfig2.DirectoryCreate;
        if (pdrBatcherHandlerConfig2.IncludeFileMask != null) {
            this.itsIncludeFileMask = pdrBatcherHandlerConfig2.IncludeFileMask.split(",");
        }
        if (pdrBatcherHandlerConfig2.ExcludeFileMask != null) {
            this.itsExcludeFileMask = pdrBatcherHandlerConfig2.ExcludeFileMask.split(",");
        }
        this.itsFileMaskMode = pdrBatcherHandlerConfig2.FileMaskMode;
        this.itsMinFileSizeBytes = pdrBatcherHandlerConfig2.MinFileSizeBytes;
        this.itsMaxFileSizeKB = pdrBatcherHandlerConfig2.MaxFileSizeKB;
        pdrDataSourceFactory pdrDataSourceFactory2 = pdrDataSourceFactory.getInstance();
        this.itsDataSourceId = pdrBatcherHandlerConfig2.DataSource;
        this.itsDataDestinationId = pdrBatcherHandlerConfig2.DataDestination;
        this.itsDataSource = pdrDataSourceFactory2.getFactory(Util.isBlank(pdrBatcherHandlerConfig2.DataSourceProtocol, "LOCAL"));
        if (this.itsDataSource == null) {
            Util_Logger.error(logger, "Invalid data source in thread " + this.itsId);
        }
        this.itsDataDestination = pdrDataSourceFactory2.getFactory(Util.isBlank(pdrBatcherHandlerConfig2.DataDestinationProtocol, "LOCAL"));
        if (this.itsDataDestination == null) {
            Util_Logger.error(logger, "Invalid data destination in thread " + this.itsId);
        }
        this.itsSourceDir = pdrBatcherHandlerConfig2.SourceDir;
        this.itsSourceSeparator = this.itsSourceDir.endsWith("\\") ? (char)92 : (char)47;
        this.itsDestinationDir = pdrBatcherHandlerConfig2.DestinationDir;
        this.itsDestinationSeparator = this.itsDestinationDir.endsWith("\\") ? (char)92 : (char)47;
        this.itsSourceArchiveDir = pdrBatcherHandlerConfig2.SourceArchiveDir;
        this.itsDestinationDirListingFile = pdrBatcherHandlerConfig2.DestinationDirListingFile;
        this.itsFileTranslator = pdrBatcherHandlerConfig2.FileTranslator;
        this.itsJobType = pdrBatcherHandlerConfig2.JobType;
        this.itsTotalFilesProcessed = 0L;
        this.itsSourceTotalKiloBytesTransferred = 0.0;
        this.itsDestinationTotalKiloBytesTransferred = 0.0;
        this.itsCpuProcessStats = new threadMonitorCPU(0L);
        this.itsIsReady = true;
    }

    protected void configOverride(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) {
    }

    protected abstract boolean requiresDestinationDirectoryListing();

    protected abstract boolean processFileCheck(FtpFileInfo var1, Map<String, FtpFileInfo> var2);

    protected abstract boolean removeSourceFileAfterProcessing();

    protected abstract boolean downloadSourceFile();

    protected abstract boolean processSingleFileAction(FtpFileInfo var1, pdrConnectionInt var2, String var3, Map<String, FtpFileInfo> var4, boolean var5);

    protected abstract boolean logDirectoryEntry();

    protected abstract void startPollCycle(String var1);

    protected abstract void completePollCycle(String var1);

    protected abstract void startPollCycleDirectory(String var1);

    private void logStart(String string, List<String> list) {
        int n2;
        String string2 = "Getting ";
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (this.itsIncludeFileMask == null) {
            stringBuffer.append("*");
        } else {
            for (n2 = 0; n2 < this.itsIncludeFileMask.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.itsIncludeFileMask[n2]);
            }
        }
        if (this.itsExcludeFileMask != null) {
            stringBuffer.append(" excluding ");
            for (n2 = 0; n2 < this.itsExcludeFileMask.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.itsExcludeFileMask[n2]);
            }
        }
        stringBuffer.append(" from directory " + string);
        stringBuffer.append(" to");
        for (String string3 : list) {
            stringBuffer.append(" ");
            stringBuffer.append(string3);
        }
        stringBuffer.append(" in thread ID " + this.getId());
        Util_Logger.info(logger, stringBuffer.toString());
    }

    @Override
    public int getId() {
        return this.itsId;
    }

    @Override
    public String getOperation() {
        return this.itsOperation;
    }

    @Override
    public pdrBatcherHandlerConfig getConfig() {
        return this.itsConfig;
    }

    private boolean getIsRunning() {
        return this.itsIsRunning;
    }

    @Override
    public String getDelivery() {
        return this.itsDelivery;
    }

    @Override
    public boolean getActivityMonitor() {
        return this.itsActivityMonitor;
    }

    private void updateProcessStats() {
        long l2 = 0L;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isCurrentThreadCpuTimeSupported()) {
            l2 = threadMXBean.getCurrentThreadCpuTime();
        }
        this.itsCpuProcessStats = new threadMonitorCPU(l2);
    }

    private String getDataTransferred(double d2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (d2 < 1024.0) {
            stringBuilder.append(String.format("%,d", (long)d2));
            stringBuilder.append(" kB");
        } else if (d2 < 1048576.0) {
            stringBuilder.append(String.format("%,d", (long)d2 / 1024L));
            stringBuilder.append(" MB");
        } else {
            stringBuilder.append(String.format("%,d", (long)d2 / 0x100000L));
            stringBuilder.append(" GB");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = new threadMonitorStatusItem(this.itsConfig.Name);
        StringBuilder stringBuilder = new StringBuilder();
        threadMonitorStatusItem2.addItem("Description", this.itsConfig.Description);
        threadMonitorStatusItem2.addItem("Files processed", this.itsTotalFilesProcessed);
        threadMonitorStatusItem2.addItem("Data transferred (from source)", this.getDataTransferred(this.itsSourceTotalKiloBytesTransferred));
        threadMonitorStatusItem2.addItem("Data transferred (to destination)", this.getDataTransferred(this.itsDestinationTotalKiloBytesTransferred));
        if (this.itsLastProcessTime != null) {
            threadMonitorStatusItem2.addItem("Last Active", Util.dateToStr(this.itsLastProcessTime, "dd/MM/yyyy HH:mm:ss"));
        }
        if (this.itsCpuProcessStats != null) {
            threadMonitorCPU threadMonitorCPU2 = this.itsCpuProcessStats;
            synchronized (threadMonitorCPU2) {
                if (this.itsCpuProcessStats.getCPUTime() > 0L) {
                    threadMonitorStatusItem2.addItem("CPU time", Long.toString(this.itsCpuProcessStats.getCPUTime()) + " " + this.itsCpuProcessStats.getCPUTimeValue());
                }
            }
        }
        threadMonitorStatusItem2.addItem("Delivery", this.itsDelivery);
        threadMonitorStatusItem2.addItem("Status", this.getIsActive() ? "ACTIVE" : "INACTIVE");
        return threadMonitorStatusItem2;
    }

    private int getPollingInterval() {
        return this.itsPollingInterval;
    }

    @Override
    public String getSchedulingMode() {
        return this.itsSchedulingMode;
    }

    @Override
    public String getCronJobSchedule() {
        return this.itsCronJobSchedule;
    }

    @Override
    public int getFailWaitInterval() {
        return this.itsFailWaitInterval;
    }

    private int getPauseInterval() {
        return this.itsPauseInterval;
    }

    private int getTrottleBytesPerSecond() {
        return this.itsTrottleBytesPerSecond;
    }

    private int getProcessLimitFiles() {
        return this.itsProcessLimitFiles;
    }

    private String getProcessOrder() {
        return this.itsProcessOrder;
    }

    protected boolean getDirectoryRecurse() {
        return this.itsDirectoryRecurse;
    }

    protected String getHoldingDir() {
        return this.itsHoldingDir;
    }

    protected boolean getCheckFileIntegrity() {
        return this.itsCheckFileIntegrity;
    }

    protected List<String> getDestinationDir(String string) throws ApplicationException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = Util.getColumns(this.itsDestinationDir, ',')) {
            Object object = string2;
            if (!Util.isBlank(string)) {
                object = string2.endsWith(Character.toString(this.itsDestinationSeparator)) ? string2 + string : string2 + this.itsDestinationSeparator + string;
            }
            arrayList.add((String)object);
        }
        return arrayList;
    }

    protected String getSourceDir(String string, String string2) {
        if (Util.isBlank(string2)) {
            return string;
        }
        if (string.endsWith(Character.toString(this.itsSourceSeparator))) {
            return string + string2;
        }
        return string + this.itsSourceSeparator + string2;
    }

    @Override
    public boolean getIsShutdown() {
        if (this.itsIsRunningInThread) {
            return !this.itsIsReady;
        }
        return !this.itsIsProcessing;
    }

    @Override
    public void stop() {
        this.itsIsRunning = false;
    }

    @Override
    public boolean getIsActive() {
        return this.itsIsActive;
    }

    @Override
    public void setIsActive(boolean bl) {
        this.itsIsActive = bl;
    }

    public List<pdrFileTranslationInt> getFileTranslator() {
        return this.itsFileTranslator;
    }

    private FtpFileInfo getSourceFile(pdrConnectionInt pdrConnectionInt2, String string, FtpFileInfo ftpFileInfo) throws ApplicationException {
        pdrBatcherHandlerDownloadFile pdrBatcherHandlerDownloadFile2 = new pdrBatcherHandlerDownloadFile(this.getHoldingDir(), this.itsCheckFileIntegrity);
        return pdrBatcherHandlerDownloadFile2.getSourceFile(pdrConnectionInt2, string, ftpFileInfo, this.itsFileTranslator, this.itsId);
    }

    private List<FtpFileInfo> transformSourceFile(FtpFileInfo ftpFileInfo) throws ApplicationException {
        pdrBatcherHandlerDownloadFile pdrBatcherHandlerDownloadFile2 = new pdrBatcherHandlerDownloadFile(this.getHoldingDir(), this.itsCheckFileIntegrity);
        return pdrBatcherHandlerDownloadFile2.transformSourceFile(ftpFileInfo, this.itsFileTranslator, this.itsId);
    }

    private boolean isGasCSV(String string, String string2) {
        boolean bl = false;
        if (!Util.isBlank(string) && !Util.isBlank(string2) && string.toUpperCase().startsWith("INT") && string.length() > 3 && string2.toUpperCase().startsWith("V")) {
            bl = true;
        }
        return bl;
    }

    public String deriveFileIdFromFilename(String string) {
        String string2 = null;
        String[] stringArray = string.split("_");
        if (stringArray.length > 1) {
            boolean bl = this.isGasCSV(stringArray[0], stringArray[1]);
            if (bl) {
                for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                    if (!this.isGasCSV(stringArray[i2], stringArray[i2 + 1])) continue;
                    string2 = stringArray[i2].toUpperCase();
                    break;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i3 = 1; i3 < stringArray.length && !Util.isInteger(stringArray[i3]); ++i3) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("_");
                    }
                    stringBuilder.append(stringArray[i3]);
                }
                if (stringBuilder.length() > 0) {
                    string2 = stringBuilder.toString();
                }
            }
        }
        return string2;
    }

    private Map<String, FtpFileInfo> pollSourceMap(pdrConnectionInt pdrConnectionInt2, String string) throws Exception {
        Map<String, FtpFileInfo> map;
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        String string2 = null;
        if (!this.itsDirectoryRecurse) {
            boolean bl = false;
            bl = this.itsExcludeFileMask != null ? this.itsExcludeFileMask.length == 0 : true;
            boolean bl2 = false;
            if (this.itsIncludeFileMask != null) {
                boolean bl3 = bl2 = this.itsIncludeFileMask.length == 1;
            }
            if (bl && bl2) {
                string2 = this.itsIncludeFileMask[0];
            }
        }
        if ((map = pdrConnectionInt2.listFiles(string, string2)) != null) {
            for (FtpFileInfo ftpFileInfo : map.values()) {
                if (ftpFileInfo.isDirectory()) {
                    if (!this.itsDirectoryRecurse) continue;
                    hashMap.put(ftpFileInfo.getFilename(), ftpFileInfo);
                    continue;
                }
                boolean bl = false;
                bl = pdrConnectionInt2.supportsFileMasks() ? Util.checkFileMask(ftpFileInfo.getFilename(), this.itsIncludeFileMask, this.itsExcludeFileMask, this.itsFileMaskMode) : true;
                boolean bl4 = false;
                if (this.itsMinFileSizeBytes < 0) {
                    bl4 = true;
                } else if (ftpFileInfo.getSize() > (long)this.itsMinFileSizeBytes) {
                    bl4 = true;
                } else {
                    Util_Logger.debug(logger, "Skipping file " + ftpFileInfo.getFilename() + ", size = " + ftpFileInfo.getSize() + " bytes, minimum size > " + this.itsMinFileSizeBytes + " bytes");
                }
                boolean bl5 = false;
                if (this.itsMaxFileSizeKB < 0) {
                    bl5 = true;
                } else if (ftpFileInfo.getSize() <= (long)(this.itsMaxFileSizeKB * 1024)) {
                    bl5 = true;
                } else {
                    Util_Logger.debug(logger, "Skipping file " + ftpFileInfo.getFilename() + ", size = " + ftpFileInfo.getSize() + " bytes, maximum size <= " + this.itsMaxFileSizeKB + " kB");
                }
                if (!bl || !bl4 || !bl5) continue;
                hashMap.put(ftpFileInfo.getFilename(), ftpFileInfo);
            }
        }
        return hashMap;
    }

    protected List<FtpFileInfo> pollSource(pdrConnectionInt pdrConnectionInt2, String string, String string2) throws Exception {
        ArrayList<FtpFileInfo> arrayList = new ArrayList<FtpFileInfo>(this.pollSourceMap(pdrConnectionInt2, string2).values());
        FtpFileComparatorInt ftpFileComparatorInt = FtpFileComparatorManager.getComparator(this.getProcessOrder());
        if (ftpFileComparatorInt.requiresTimestamp()) {
            if (pdrConnectionInt2.supportsFileTimestamps()) {
                Collections.sort(arrayList, ftpFileComparatorInt);
            } else {
                Util_Logger.warning(logger, "Sort order of " + this.getProcessOrder() + " not supported in source " + pdrConnectionInt2.getDataSourceId());
            }
        } else {
            Collections.sort(arrayList, ftpFileComparatorInt);
        }
        return arrayList;
    }

    protected void fileProcessSuccess(FtpFileInfo ftpFileInfo) {
        if (this.itsActivityMonitor) {
            this.itsParent.updateLastBusyTime(this.getDataSourceId());
        }
        this.itsLastProcessTime = new Date();
        if (this.itsFileEventHandler != null) {
            try {
                this.itsFileEventHandler.fileProcess(ftpFileInfo.getFilename());
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error calling batcher event handler: " + exception.getMessage(), exception);
            }
        }
    }

    private void fileProcessTargetSuccess(String string, String string2) {
        if (this.itsFileEventHandler != null) {
            try {
                this.itsFileEventHandler.fileProcessToTarget(string, string2);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error calling batcher targetted event handler: " + exception.getMessage(), exception);
            }
        }
    }

    private void processSingleDirectory(pdrConnectionInt pdrConnectionInt2, String string, String string2, FtpFileInfo ftpFileInfo, List<String> list) throws ApplicationException {
        if (ftpFileInfo.isDirectory() && this.getDirectoryRecurse()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = string2 + "/" + ftpFileInfo.getFilename();
            for (String string4 : list) {
                Object object = string4;
                if (this.itsSubDirListDest) {
                    object = (String)object + "/" + ftpFileInfo.getFilename();
                }
                arrayList.add((String)object);
            }
            this.pollAndProcessDirectory(string, string3, arrayList, pdrConnectionInt2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleFile(pdrConnectionInt pdrConnectionInt2, String string, String string2, FtpFileInfo ftpFileInfo, pdrConnectionInt pdrConnectionInt3, List<String> list, List<Map<String, FtpFileInfo>> list2) throws ApplicationException {
        block39: {
            pdrLockManager pdrLockManager2 = pdrLockManager.getInstance();
            try {
                if (!pdrLockManager2.addTask(ftpFileInfo.getName())) break block39;
                pdrFileLockInt pdrFileLockInt2 = null;
                try {
                    if (pdrConnectionInt2.exists(ftpFileInfo) && (pdrFileLockInt2 = pdrConnectionInt2.lockFile(ftpFileInfo)).isValid()) {
                        Date date = new Date();
                        boolean bl = false;
                        FtpFileInfo ftpFileInfo2 = null;
                        List<FtpFileInfo> list3 = null;
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            String string3 = list.get(i2);
                            Map<String, FtpFileInfo> map = null;
                            if (this.requiresDestinationDirectoryListing()) {
                                map = list2.get(i2);
                            }
                            if (!this.processFileCheck(ftpFileInfo, map)) continue;
                            if (this.downloadSourceFile()) {
                                if (ftpFileInfo2 == null) {
                                    ftpFileInfo2 = this.getSourceFile(pdrConnectionInt2, string2, ftpFileInfo);
                                }
                            } else {
                                ftpFileInfo2 = ftpFileInfo;
                            }
                            if (ftpFileInfo2 == null) continue;
                            if (list3 == null) {
                                list3 = this.transformSourceFile(ftpFileInfo2);
                            }
                            boolean bl2 = i2 == list.size() - 1;
                            boolean bl3 = false;
                            if (list3 != null) {
                                bl3 = true;
                                for (FtpFileInfo ftpFileInfo3 : list3) {
                                    bl3 = bl3 && this.processSingleFileAction(ftpFileInfo3, pdrConnectionInt3, string3, map, bl2);
                                }
                            }
                            if (!bl3) continue;
                            this.fileProcessTargetSuccess(ftpFileInfo2.getFilename(), string3);
                            bl = true;
                        }
                        FileUtilities.deleteFile(this.getHoldingDir() + "/" + ftpFileInfo.getFilename());
                        if (bl) {
                            block40: {
                                ++this.itsTotalFilesProcessed;
                                double d2 = (double)ftpFileInfo.getSize().longValue() / 1024.0;
                                this.itsSourceTotalKiloBytesTransferred += d2;
                                double d3 = (double)ftpFileInfo2.getSize().longValue() / 1024.0;
                                this.itsDestinationTotalKiloBytesTransferred += d3;
                                if (!Util.isBlank(this.itsSourceArchiveDir)) {
                                    try {
                                        Object object = this.itsSourceArchiveDir;
                                        if (string2.length() > string.length()) {
                                            int n2 = string.length();
                                            object = (String)object + string2.substring(n2);
                                        }
                                        if (this.itsDirectoryRecurse) {
                                            pdrConnectionInt2.makeDir((String)object);
                                        }
                                        if (pdrConnectionInt2.exists((String)object, ftpFileInfo.getFilename())) {
                                            pdrConnectionInt2.deleteFile((String)object, ftpFileInfo.getFilename());
                                        }
                                        pdrConnectionInt2.renameFile(string2, ftpFileInfo.getFilename(), (String)object, ftpFileInfo.getFilename());
                                    }
                                    catch (FtpException ftpException) {
                                        if (ftpException.getReplyCode() == 550) {
                                            Util_Logger.debug(logger, "Detected FTP get file contention error: " + ftpException.getReplyCode() + ", " + ftpException.getMessage() + " in thread " + this.getId());
                                            break block40;
                                        }
                                        Util_Logger.warning(logger, "Detected problem with archive of " + ftpFileInfo.getFilename() + " in thread ID " + this.getId() + ": " + ftpException.getMessage(), ftpException);
                                    }
                                    catch (Exception exception) {
                                        Util_Logger.warning(logger, "Detected problem with archive of " + ftpFileInfo.getFilename() + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                                    }
                                } else if (this.removeSourceFileAfterProcessing()) {
                                    if (pdrConnectionInt2.logOperations()) {
                                        Util_Logger.info(logger, "Now deleting " + ftpFileInfo.getFilename() + " in thread " + this.getId());
                                    }
                                    try {
                                        pdrConnectionInt2.deleteFile(string2, ftpFileInfo.getFilename());
                                    }
                                    catch (FtpException ftpException) {
                                        if (ftpException.getReplyCode() == 550) {
                                            Util_Logger.debug(logger, "Detected FTP get file contention error: " + ftpException.getReplyCode() + ", " + ftpException.getMessage() + " in thread " + this.getId());
                                        } else {
                                            Util_Logger.warning(logger, "Detected problem with delete of " + ftpFileInfo.getFilename() + " in thread ID " + this.getId() + ": " + ftpException.getMessage(), ftpException);
                                        }
                                    }
                                    catch (Exception exception) {
                                        Util_Logger.warning(logger, "Detected problem with delete of " + ftpFileInfo.getFilename() + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                                    }
                                }
                            }
                            Date date2 = new Date();
                            long l2 = date2.getTime() - date.getTime();
                            Util_Logger.info(logger, "Completed processing of " + ftpFileInfo.getFilename() + " [" + ftpFileInfo.getSize() + " bytes, " + l2 + " ms] in thread " + this.getId());
                            this.fileProcessSuccess(ftpFileInfo);
                            pdrPerformanceRec pdrPerformanceRec2 = new pdrPerformanceRec();
                            pdrPerformanceRec2.setDataSource(this.getDataSourceId());
                            pdrPerformanceRec2.setThreadId(Integer.toString(this.getId()));
                            pdrPerformanceRec2.setStartDate(date);
                            pdrPerformanceRec2.setEndDate(date2);
                            if (!Util.isBlank(ftpFileInfo.getExtension())) {
                                pdrPerformanceRec2.setFilename(ftpFileInfo.getFilename().substring(0, ftpFileInfo.getFilename().length() - ftpFileInfo.getExtension().length() - 1));
                                pdrPerformanceRec2.setFileExtension(ftpFileInfo.getExtension());
                            } else {
                                pdrPerformanceRec2.setFilename(ftpFileInfo.getFilename());
                            }
                            pdrPerformanceRec2.setFileId(this.deriveFileIdFromFilename(pdrPerformanceRec2.getFilename()));
                            pdrPerformanceRec2.setJobType(this.itsJobType);
                            pdrPerformanceRec2.setJobSize(ftpFileInfo.getSize());
                            pdrPerformanceRec2.setJobSizeUnits(pdrPerformanceJobSizeUnits.BYTES);
                            if (ftpFileInfo.getModifiedDateExact()) {
                                pdrPerformanceRec2.setContentCreationDate(ftpFileInfo.getModifiedDate());
                            }
                            pdrMonitorManager.getInstance().addRecord(pdrPerformanceRec2);
                        } else if (ftpFileInfo2 == null || list3 == null) {
                            // empty if block
                        }
                    }
                    pdrConnectionInt2.releaseFileLock(pdrFileLockInt2);
                    pdrLockManager2.deleteTask(ftpFileInfo.getName());
                }
                catch (Exception exception) {
                    try {
                        pdrConnectionInt2.releaseFileLock(pdrFileLockInt2);
                        pdrLockManager2.deleteTask(ftpFileInfo.getName());
                        Util_Logger.error(logger, "Detected error processing file " + ftpFileInfo.getFilename() + " in thread ID " + this.getId(), exception);
                        pdrConnectionInt2.releaseFileLock(pdrFileLockInt2);
                        pdrLockManager2.deleteTask(ftpFileInfo.getName());
                    }
                    catch (Throwable throwable) {
                        pdrConnectionInt2.releaseFileLock(pdrFileLockInt2);
                        pdrLockManager2.deleteTask(ftpFileInfo.getName());
                        throw throwable;
                    }
                }
                try {
                    Thread.sleep(this.getPauseInterval());
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Detected problem consuming files from " + string2 + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirectoryListingFile(pdrConnectionInt pdrConnectionInt2, List<String> list) throws Exception {
        if (!Util.isBlank(this.itsDestinationDirListingFile)) {
            for (String string : list) {
                Map<String, FtpFileInfo> map = pdrConnectionInt2.listFiles(string, null);
                File file = new File(this.getHoldingDir() + "/" + this.getId() + "/");
                file.mkdirs();
                OutputStreamWriter outputStreamWriter = null;
                PrintWriter printWriter = null;
                try {
                    File file2 = new File(file, this.itsDestinationDirListingFile);
                    FileUtilities.deleteFile(file2);
                    outputStreamWriter = new FileWriter(file2);
                    printWriter = new PrintWriter(outputStreamWriter);
                    if (this.itsDestinationDirListingFile.toLowerCase().endsWith(".xml")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                        printWriter.print("<FILES modified='");
                        printWriter.print(simpleDateFormat.format(new Date()));
                        printWriter.println("'>");
                        for (FtpFileInfo ftpFileInfo : map.values()) {
                            if (ftpFileInfo.isDirectory()) continue;
                            printWriter.print("<FILE name='");
                            printWriter.print(ftpFileInfo.getFilename());
                            printWriter.print("' modified='");
                            printWriter.print(simpleDateFormat.format(ftpFileInfo.getModifiedDate()));
                            printWriter.println("'/>");
                        }
                        printWriter.println("</FILES>");
                    } else {
                        for (FtpFileInfo ftpFileInfo : map.values()) {
                            if (ftpFileInfo.isDirectory()) continue;
                            printWriter.println(ftpFileInfo.getFilename());
                        }
                    }
                    printWriter.flush();
                    outputStreamWriter.flush();
                    printWriter.close();
                    outputStreamWriter.close();
                    pdrConnectionInt2.putFile(file2.getParent(), file2.getName(), string, null, true);
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Detected problem wirting directory listing file for " + string + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                }
                finally {
                    try {
                        printWriter.close();
                    }
                    catch (Exception exception) {}
                    try {
                        outputStreamWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private void pollAndProcessDirectory(String string, String string2, List<String> list, pdrConnectionInt pdrConnectionInt2) throws ApplicationException {
        try {
            Util_Logger.debug(logger, "Commencing poll cycle in thread " + this.getId());
            this.startPollCycleDirectory(string2);
            boolean bl = true;
            while (bl && this.getIsRunning()) {
                bl = false;
                List<FtpFileInfo> list2 = this.pollSource(pdrConnectionInt2, string, string2);
                if (list2 != null) {
                    Util_Logger.debug(logger, "Processing directory listing in thread " + this.getId());
                    if (list2.size() <= 0) continue;
                    if (this.logDirectoryEntry()) {
                        this.logStart(string2, list);
                    }
                    int n2 = list2.size();
                    if (this.getProcessLimitFiles() > 0 && n2 > this.getProcessLimitFiles()) {
                        n2 = this.getProcessLimitFiles();
                        bl = false;
                    }
                    if (n2 <= 0) continue;
                    pdrConnectionInt pdrConnectionInt3 = null;
                    try {
                        Util_Logger.debug(logger, "Waiting for data source connection from pool in thread " + this.getId());
                        pdrConnectionInt3 = this.getDestinationConnection();
                        Util_Logger.debug(logger, "Got data connection from pool in thread " + this.getId());
                        pdrConnectionInt2.changeDir(string2);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (list != null) {
                            for (Object object : list) {
                                boolean bl2 = false;
                                try {
                                    pdrConnectionInt3.changeDir((String)object);
                                    bl2 = true;
                                }
                                catch (Exception exception) {
                                    if (this.itsDirectoryCreate) {
                                        try {
                                            pdrConnectionInt3.makeDir((String)object);
                                            pdrConnectionInt3.changeDir((String)object);
                                            bl2 = true;
                                        }
                                        catch (Exception exception2) {
                                            Util_Logger.warning(logger, "Error creating destination directory: " + exception2.getMessage(), exception2);
                                        }
                                    }
                                    if (this.itsDirectoryRecurse) {
                                        Util_Logger.warning(logger, "Skipping processing of directory " + list + " as not present in destination");
                                    }
                                    Util_Logger.error(logger, "Error destination directory " + list + " does not exist: " + exception.getMessage(), exception);
                                }
                                if (!bl2) continue;
                                arrayList.add((String)object);
                            }
                        }
                        if (arrayList.size() > 0) {
                            ArrayList arrayList2 = new ArrayList();
                            if (this.requiresDestinationDirectoryListing()) {
                                Object object;
                                object = arrayList.iterator();
                                while (object.hasNext()) {
                                    String string3 = (String)object.next();
                                    arrayList2.add(pdrConnectionInt3.listFiles(string3, null));
                                }
                            }
                            for (int i2 = 0; i2 < n2 && this.getIsRunning(); ++i2) {
                                FtpFileInfo ftpFileInfo = list2.get(i2);
                                if (ftpFileInfo.isDirectory()) continue;
                                this.processSingleFile(pdrConnectionInt2, string, string2, ftpFileInfo, pdrConnectionInt3, arrayList, arrayList2);
                            }
                            try {
                                this.writeDirectoryListingFile(pdrConnectionInt3, arrayList);
                            }
                            catch (Exception exception) {
                                Util_Logger.errorNoRaise(logger, "Detected problem writing directory listing file in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                            }
                            this.freeDestinationConnection(pdrConnectionInt3);
                            pdrConnectionInt3 = null;
                            for (int i3 = 0; i3 < n2 && this.getIsRunning(); ++i3) {
                                FtpFileInfo ftpFileInfo = list2.get(i3);
                                if (!ftpFileInfo.isDirectory()) continue;
                                this.processSingleDirectory(pdrConnectionInt2, string, string2, ftpFileInfo, arrayList);
                            }
                        }
                        this.freeDestinationConnection(pdrConnectionInt3);
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            try {
                                pdrConnectionInt3.disconnect();
                            }
                            catch (Exception exception3) {
                                // empty catch block
                            }
                            Util_Logger.error(logger, "Detected problem processing files from " + string2 + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
                            this.freeDestinationConnection(pdrConnectionInt3);
                            continue;
                        }
                        catch (Throwable throwable) {
                            this.freeDestinationConnection(pdrConnectionInt3);
                            throw throwable;
                        }
                    }
                }
                Util_Logger.error(logger, "Detected network problem accessing " + string2 + " in thread ID " + this.getId(), null);
            }
            if (bl) {
                Util_Logger.info(logger, "Reached file process limit of " + this.getProcessLimitFiles() + " files in thread " + this.getId() + ", repolling source directory");
            } else {
                Util_Logger.debug(logger, "Successfully completed file process in thread ID " + this.getId());
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected problem processing files from " + string2 + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
        }
    }

    protected String getDataSourceId() {
        return this.itsDataSourceId;
    }

    protected pdrConnectionInt getSourceConnection() {
        pdrConnectionFactoryInt pdrConnectionFactoryInt2 = this.itsDataSource;
        pdrConnectionInt pdrConnectionInt2 = pdrConnectionFactoryInt2.getConnection(this.itsDataSourceId);
        if (this.getTrottleBytesPerSecond() > 0) {
            pdrConnectionInt2.setBandwidthThrottle(this.getTrottleBytesPerSecond());
        }
        if (this.itsTransferBufferSize > 0) {
            pdrConnectionInt2.setTransferBufferSize(this.itsTransferBufferSize);
        }
        return pdrConnectionInt2;
    }

    protected void freeSourceConnection(pdrConnectionInt pdrConnectionInt2) {
        if (pdrConnectionInt2 != null) {
            pdrConnectionFactoryInt pdrConnectionFactoryInt2 = this.itsDataSource;
            pdrConnectionFactoryInt2.freeConnection(pdrConnectionInt2);
        }
    }

    protected pdrConnectionInt getDestinationConnection() {
        pdrConnectionFactoryInt pdrConnectionFactoryInt2 = this.itsDataDestination;
        pdrConnectionInt pdrConnectionInt2 = pdrConnectionFactoryInt2.getConnection(this.itsDataDestinationId);
        if (this.getTrottleBytesPerSecond() > 0) {
            pdrConnectionInt2.setBandwidthThrottle(this.getTrottleBytesPerSecond());
        }
        if (this.itsTransferBufferSize > 0) {
            pdrConnectionInt2.setTransferBufferSize(this.itsTransferBufferSize);
        }
        return pdrConnectionInt2;
    }

    protected void freeDestinationConnection(pdrConnectionInt pdrConnectionInt2) {
        if (pdrConnectionInt2 != null) {
            pdrConnectionFactoryInt pdrConnectionFactoryInt2 = this.itsDataDestination;
            pdrConnectionFactoryInt2.freeConnection(pdrConnectionInt2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAndProcessDirectory(String string, String string2, String string3) throws ApplicationException {
        pdrConnectionInt pdrConnectionInt2 = null;
        try {
            pdrConnectionInt2 = this.getSourceConnection();
            if (this.itsSubDirListDest) {
                this.pollAndProcessDirectory(string, this.getSourceDir(string2, string3), this.getDestinationDir(string3), pdrConnectionInt2);
            } else {
                this.pollAndProcessDirectory(string, this.getSourceDir(string2, string3), this.getDestinationDir(null), pdrConnectionInt2);
            }
        }
        catch (Exception exception) {
            try {
                pdrConnectionInt2.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Detected problem processing files from " + this.getSourceDir(string2, string3) + " in thread ID " + this.getId() + ": " + exception.getMessage(), exception);
        }
        finally {
            this.freeSourceConnection(pdrConnectionInt2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCycle() throws ApplicationException {
        try {
            if (this.getIsActive()) {
                if (this.getIsRunning()) {
                    String[] stringArray;
                    this.itsIsProcessing = true;
                    for (String string : stringArray = Util.getColumns(this.itsSourceDir, ',')) {
                        if (!this.logDirectoryEntry()) {
                            Util_Logger.info(logger, "Commencing poll cycle of " + string + " in thread " + this.getId());
                        }
                        this.startPollCycle(string);
                        if (this.itsSubDirList == null) {
                            this.pollAndProcessDirectory(string, string, null);
                        } else if (this.itsSubDirList.size() == 0) {
                            this.pollAndProcessDirectory(string, string, null);
                        } else {
                            for (String string2 : this.itsSubDirList) {
                                if (Util.isBlank(string2)) {
                                    this.pollAndProcessDirectory(string, string, null);
                                    continue;
                                }
                                this.pollAndProcessDirectory(string, string, string2);
                            }
                        }
                        this.completePollCycle(string);
                        if (this.logDirectoryEntry()) continue;
                        Util_Logger.info(logger, "Completed poll cycle of " + string + " in thread " + this.getId());
                    }
                    this.updateProcessStats();
                } else {
                    Util_Logger.info(logger, "Skipping thread execution as shutdown is in progress");
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected file download error: " + exception.getMessage(), exception);
        }
        finally {
            this.itsIsProcessing = false;
        }
    }

    @Override
    public void run() {
        this.itsIsRunningInThread = true;
        Util_Logger.info(logger, "Initiated thread " + this.getId() + " from source directory: " + this.itsSourceDir + " via " + this.itsDataSource.getName() + " to destination diectory: " + this.itsDestinationDir + " via " + this.itsDataDestination.getName());
        while (this.getIsRunning()) {
            int n2 = this.getPollingInterval();
            try {
                this.executeCycle();
            }
            catch (Exception exception) {
                pdrLockManager.getInstance().cleanQueue(Thread.currentThread());
                n2 = this.getFailWaitInterval();
            }
            if (!this.getIsRunning()) continue;
            try {
                Thread.sleep(n2);
            }
            catch (Exception exception) {}
        }
        Util_Logger.info(logger, "Batcher thread " + this.getId() + " stopped");
        this.itsIsReady = false;
    }
}

