/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileCacheManager;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerConsumerCache
extends pdrBatcherHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerConsumerCache.class);
    private String CurrentSource;
    private String CurrentDirectory;
    private boolean DoesCompleteDirectoryList;

    public pdrBatcherHandlerConsumerCache(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
        this.DoesCompleteDirectoryList = Util.isBlank(pdrBatcherHandlerConfig2.IncludeFileMask) && Util.isBlank(pdrBatcherHandlerConfig2.ExcludeFileMask);
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    @Override
    protected boolean logDirectoryEntry() {
        return true;
    }

    @Override
    protected boolean processFileCheck(FtpFileInfo ftpFileInfo, Map<String, FtpFileInfo> map) {
        return true;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return true;
    }

    @Override
    protected void startPollCycle(String string) {
    }

    @Override
    protected void completePollCycle(String string) {
    }

    @Override
    protected void startPollCycleDirectory(String string) {
    }

    @Override
    protected List<FtpFileInfo> pollSource(pdrConnectionInt pdrConnectionInt2, String string, String string2) throws Exception {
        List<FtpFileInfo> list = super.pollSource(pdrConnectionInt2, string, string2);
        this.CurrentSource = pdrConnectionInt2.getDataSourceId();
        this.CurrentDirectory = string2;
        pdrFileCacheManager pdrFileCacheManager2 = pdrFileCacheManager.getInstance();
        List<FtpFileInfo> list2 = pdrFileCacheManager2.processDirectoryList(this.CurrentSource, this.CurrentDirectory, list, this.DoesCompleteDirectoryList);
        return list2;
    }

    @Override
    protected void fileProcessSuccess(FtpFileInfo ftpFileInfo) {
        pdrFileCacheManager.getInstance().processedFile(this.CurrentSource, this.CurrentDirectory, ftpFileInfo);
        super.fileProcessSuccess(ftpFileInfo);
    }

    @Override
    protected boolean processSingleFileAction(FtpFileInfo ftpFileInfo, pdrConnectionInt pdrConnectionInt2, String string, Map<String, FtpFileInfo> map, boolean bl) {
        boolean bl2 = false;
        if (pdrConnectionInt2.logOperations()) {
            Util_Logger.info(logger, "Now putting " + ftpFileInfo.getFilename() + " to " + string + " in thread " + this.getId());
        }
        try {
            if (this.getConfig().AllowOverwrite && pdrConnectionInt2.exists(string, ftpFileInfo.getFilename())) {
                pdrConnectionInt2.deleteFile(string, ftpFileInfo.getFilename());
            }
            pdrConnectionInt2.putFile(this.getHoldingDir(), ftpFileInfo.getFilename(), string, null, bl);
            bl2 = true;
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Detected FTP error: " + exception.getMessage() + " in thread " + this.getId(), exception);
        }
        return bl2;
    }
}

