/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerInt;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerManager;
import au.com.nemmco.Pdr.Common.pdrLockManager;
import au.com.nemmco.Util.Util_Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerJob
implements Job {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        pdrLockManager pdrLockManager2 = pdrLockManager.getInstance();
        int n2 = 60000;
        String string = null;
        boolean bl = false;
        try {
            JobDetail jobDetail = jobExecutionContext.getJobDetail();
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            int n3 = jobDataMap.getInt("ID");
            String string2 = jobDataMap.getString("NAME");
            string = "THREAD_" + n3;
            bl = pdrLockManager2.addTask(string);
            if (bl) {
                Util_Logger.info(logger, "Detected quartz job for thread " + string2);
                pdrBatcherHandlerManager pdrBatcherHandlerManager2 = pdrBatcherHandlerManager.getInstance();
                pdrBatcherHandlerInt pdrBatcherHandlerInt2 = pdrBatcherHandlerManager2.getHandler(n3);
                if (pdrBatcherHandlerInt2 != null) {
                    n2 = pdrBatcherHandlerInt2.getFailWaitInterval();
                    pdrBatcherHandlerInt2.executeCycle();
                    Util_Logger.info(logger, "Completed quartz job for thread " + string2);
                } else {
                    Util_Logger.errorNoRaise(logger, "Internal application error with quartz job scheduling system, batcher thread ID " + n3 + " not found in handler manager");
                }
                pdrLockManager2.deleteTask(string);
            } else {
                Util_Logger.info(logger, "Skipping scheduled execution of batcher thread " + n3 + " as previous job is still in progress");
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Detected error: " + exception.getMessage(), exception);
            if (bl) {
                pdrLockManager2.deleteTask(string);
            }
            try {
                Thread.sleep(n2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            JobExecutionException jobExecutionException = new JobExecutionException((Throwable)exception);
            jobExecutionException.refireImmediately();
            throw jobExecutionException;
        }
    }
}

