/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class pdrFileTranslationBase {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationBase.class);
    private String itsId;
    private Options options = new Options();
    private CommandLine cmd;

    public pdrFileTranslationBase(String string) {
        this.itsId = string;
    }

    public String getId() {
        return this.itsId;
    }

    public void registerParam(String string, String string2, boolean bl, String string3) {
        if (bl) {
            this.options.addRequiredOption(string, string2, true, string3);
        } else {
            this.options.addOption(string, string2, true, string3);
        }
    }

    public void registerOption(String string, String string2, String string3) {
        this.options.addOption(string, string2, false, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseParams(String[] stringArray) throws ApplicationException {
        try {
            DefaultParser defaultParser = new DefaultParser();
            this.cmd = defaultParser.parse(this.options, stringArray);
        }
        catch (Exception exception) {
            try (StringWriter stringWriter = new StringWriter();
                 PrintWriter printWriter = new PrintWriter(stringWriter);){
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp(printWriter, helpFormatter.getWidth(), this.itsId, null, this.options, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), null, true);
                printWriter.flush();
                Util_Logger.info(logger, stringWriter.toString());
            }
            catch (Exception exception2) {
            }
            finally {
                Util_Logger.error(logger, "Error processing parameters for translator ID " + this.getId() + ": " + exception.getMessage(), exception);
            }
        }
    }

    public String getParam(String string) {
        String string2 = null;
        if (!Util.isBlank(string) && this.cmd != null) {
            string2 = this.cmd.getOptionValue(string);
        }
        return string2;
    }

    public boolean hasParam(String string) {
        boolean bl = false;
        if (!Util.isBlank(string) && this.cmd != null) {
            bl = this.cmd.hasOption(string);
        }
        return bl;
    }

    protected boolean isTextFile(FtpFileInfo ftpFileInfo) {
        return ftpFileInfo.getFilename().toUpperCase().endsWith(".CSV") || ftpFileInfo.getFilename().toUpperCase().endsWith(".TXT") || ftpFileInfo.getFilename().toUpperCase().endsWith(".LOG");
    }
}

