/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.nemmco.Pdr.Batcher.Processor.Util.pdrBatcherTokenResolver;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationFileRename
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationFileRename.class);
    private static final String PARAM_NAME = "name";

    public pdrFileTranslationFileRename() {
        super("RENAME");
        super.registerParam("n", PARAM_NAME, true, "The new filename specification");
    }

    @Override
    public boolean acceptFile(FtpFileInfo ftpFileInfo) {
        return true;
    }

    @Override
    public List<FtpFileInfo> translateFile(FtpFileInfo ftpFileInfo, String string, int n2) throws Exception {
        ArrayList<FtpFileInfo> arrayList = new ArrayList<FtpFileInfo>();
        String string2 = this.getParam(PARAM_NAME);
        if (Util.isBlank(string2)) {
            Util_Logger.warning(logger, "Missing parameter name in " + this.getId() + " translator, ignoring action");
            arrayList.add(ftpFileInfo);
        } else {
            FtpFileInfo ftpFileInfo2 = (FtpFileInfo)ftpFileInfo.clone();
            ftpFileInfo2.setDirectory(string);
            String string3 = pdrBatcherTokenResolver.process(string2, ftpFileInfo);
            FileUtilities.renameFile(ftpFileInfo2.getDirectory() + "/" + ftpFileInfo2.getFilename(), ftpFileInfo2.getDirectory() + "/" + string3);
            ftpFileInfo2.setFilename(string3);
            arrayList.add(ftpFileInfo2);
        }
        return arrayList;
    }
}

