/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationInsert
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationInsert.class);
    private static final String PARAM_LINE = "line";
    private static final String PARAM_TEXT = "text";

    public pdrFileTranslationInsert() {
        super("INSERT");
        super.registerParam("l", PARAM_LINE, true, "Line number of the source file");
        super.registerParam("t", PARAM_TEXT, true, "The text to insert");
    }

    @Override
    public boolean acceptFile(FtpFileInfo ftpFileInfo) {
        return this.isTextFile(ftpFileInfo);
    }

    @Override
    public List<FtpFileInfo> translateFile(FtpFileInfo ftpFileInfo, String string, int n2) throws Exception {
        ArrayList<FtpFileInfo> arrayList = new ArrayList<FtpFileInfo>();
        Long l2 = null;
        String string2 = this.getParam(PARAM_LINE);
        try {
            l2 = Util.isBlank(string2) ? null : Long.valueOf(string2);
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Invalid line parameter (" + string2 + "), assuming +1");
            l2 = 1L;
        }
        String string3 = this.getParam(PARAM_TEXT);
        if (Util.isBlank(string3) || l2 == null) {
            Util_Logger.warning(logger, "Missing parameters line and text in " + this.getId() + " translator, ignoring action");
            arrayList.add(ftpFileInfo);
        } else {
            String string4 = string + "/" + ftpFileInfo.getFilename();
            String string5 = string + "/" + ftpFileInfo.getFilename() + ".tmp";
            boolean bl = false;
            long l3 = 0L;
            String string6 = "";
            try (Object object = Files.newBufferedWriter(Paths.get(string5, new String[0]), new OpenOption[0]);){
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));){
                    while ((string6 = bufferedReader.readLine()) != null) {
                        if (++l3 > l2) {
                            ((BufferedWriter)object).newLine();
                        }
                        if (l3 == l2) {
                            ((Writer)object).write(string3);
                            ((BufferedWriter)object).newLine();
                            bl = true;
                        }
                        ((Writer)object).write(string6);
                    }
                    bufferedReader.close();
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                catch (Exception exception) {
                    Util_Logger.error(logger, "Error processing insert translation: " + exception.getMessage(), exception);
                }
            }
            if (!bl) {
                Util_Logger.warning(logger, "Reached end of file " + ftpFileInfo.getFilename() + " [lines = " + l3 + "] before INSERT translator specified at line " + l2);
            }
            FileUtilities.renameFile(string5, string4);
            object = (FtpFileInfo)ftpFileInfo.clone();
            ((FtpFileInfo)object).setDirectory(string);
            ((FtpFileInfo)object).setSize(new File(string4).length());
            arrayList.add((FtpFileInfo)object);
        }
        return arrayList;
    }
}

