/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.Util_Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationOSScript
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationOSScript.class);
    private static final String PARAM_NAME = "name";
    private static final String PARAM_DELETE = "delete";

    public pdrFileTranslationOSScript() {
        super("SCRIPT");
        super.registerParam("l", PARAM_NAME, true, "Operating system script file to execute");
        super.registerOption("d", PARAM_DELETE, "Set this option if the external script can remove the input file (e.g. virus scan)");
    }

    @Override
    public boolean acceptFile(FtpFileInfo ftpFileInfo) {
        return true;
    }

    @Override
    public List<FtpFileInfo> translateFile(FtpFileInfo ftpFileInfo, String string, int n2) throws Exception {
        ArrayList<FtpFileInfo> arrayList = new ArrayList<FtpFileInfo>();
        String string2 = this.getParam(PARAM_NAME);
        boolean bl = this.hasParam(PARAM_DELETE);
        if (string2 == null) {
            Util_Logger.warning(logger, "Missing parameter name in " + this.getId() + " translator, ignoring action");
            arrayList.add(ftpFileInfo);
        } else {
            Object object;
            Comparable<StringBuilder> comparable;
            boolean bl2 = System.getProperty("os.name").toLowerCase().startsWith("windows");
            if (logger.isDebugEnabled()) {
                Util_Logger.debug(logger, "Command: " + string2.toString());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (bl2) {
                arrayList2.add("cmd");
                arrayList2.add("/c");
            } else {
                arrayList2.add("/bin/bash");
                arrayList2.add("-c");
            }
            arrayList2.add(string2);
            String string3 = string + "/" + ftpFileInfo.getFilename();
            if (bl2) {
                arrayList2.add(string3.replace('/', '\\'));
            } else {
                arrayList2.add(string3);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(arrayList2);
            Process process = processBuilder.start();
            process.waitFor();
            if (process.exitValue() != 0) {
                comparable = new StringBuilder();
                object = new Scanner(process.getErrorStream());
                while (((Scanner)object).hasNextLine()) {
                    String string4 = ((Scanner)object).nextLine();
                    if (!comparable.isEmpty()) {
                        ((StringBuilder)comparable).append("\r\n");
                    }
                    ((StringBuilder)comparable).append(string4);
                }
                Util_Logger.error(logger, "Error processing OS script translation: " + ((StringBuilder)comparable).toString());
            }
            if (((File)(comparable = new File(string3))).exists()) {
                object = (FtpFileInfo)ftpFileInfo.clone();
                ((FtpFileInfo)object).setDirectory(string);
                ((FtpFileInfo)object).setSize(((File)comparable).length());
                arrayList.add((FtpFileInfo)object);
            } else if (bl) {
                Util_Logger.warning(logger, "Input file [" + ftpFileInfo.getFilename() + "] removed following OS script [" + string2 + "] translation");
            } else {
                Util_Logger.error(logger, "Detected file [" + ftpFileInfo.getFilename() + "] no longer available following OS script [" + string2 + "] translation");
            }
        }
        return arrayList;
    }
}

