/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.AWSBlob;
import au.com.nemmco.Pdr.Batcher.Transport.AWSDirectoryWrapper;
import au.com.nemmco.Pdr.Batcher.Transport.AWSRequestParameters;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionLocal;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockNone;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebClient;
import au.com.nemmco.Util.XmlUtilities;
import au.com.nemmco.Util.xStreamDateConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import uk.co.lucasweb.aws.v4.signer.HttpRequest;
import uk.co.lucasweb.aws.v4.signer.Signer;
import uk.co.lucasweb.aws.v4.signer.credentials.AwsCredentials;

public class pdrConnectionAWS
implements pdrConnectionInt {
    private static String AWS_DATE_FOMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static Logger logger = LoggerFactory.getLogger(pdrConnectionAWS.class);
    private String itsDataSourceId;
    private String itsAPIAccessKey;
    private String itsAPISecretKey;
    private String itsRegion;
    private String itsCurrentDir;
    private boolean itsGetFileModifiedTime;
    private SimpleDateFormat DateFormatter;
    private pdrConnectionLocal itsLocal;
    private WebClient itsWebClient;

    public pdrConnectionAWS(String string, String string2, String string3, String string4, int n2, int n3, Proxy proxy, boolean bl) {
        this.itsDataSourceId = string;
        this.itsAPIAccessKey = string3;
        this.itsAPISecretKey = string4;
        this.itsRegion = string2;
        this.itsGetFileModifiedTime = bl;
        this.DateFormatter = new SimpleDateFormat(AWS_DATE_FOMAT, Locale.US);
        this.DateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.itsLocal = new pdrConnectionLocal(string);
        this.itsWebClient = new WebClient(proxy, n2, n3);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("AWS connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = string;
    }

    private String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            if (string.length() == 1) {
                stringBuilder.append("0");
            } else if (string.length() == 8) {
                string = string.substring(6);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toLowerCase(Locale.getDefault());
    }

    private HttpsURLConnection getHttpURLConnection(String string, byte[] byArray, AWSRequestParameters aWSRequestParameters) throws ApplicationException {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpsURLConnection)this.itsWebClient.getHttpURLConnection(aWSRequestParameters.method, uRL);
            httpURLConnection.setRequestProperty("Accept", "*/*");
            String string2 = uRL.getHost();
            httpURLConnection.setRequestProperty("host", string2);
            String string3 = this.DateFormatter.format(Calendar.getInstance().getTime());
            httpURLConnection.setRequestProperty("x-amz-date", string3);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            if (byArray == null) {
                messageDigest.update(new String("").getBytes());
            } else {
                messageDigest.update(byArray);
            }
            String string4 = this.toHex(messageDigest.digest());
            httpURLConnection.setRequestProperty("x-amz-content-sha256", string4);
            if (!Util.isBlank(aWSRequestParameters.content_type)) {
                httpURLConnection.setRequestProperty("Content-Type", aWSRequestParameters.content_type);
            }
            if (!Util.isBlank(aWSRequestParameters.content_length)) {
                httpURLConnection.setRequestProperty("Content-Length", aWSRequestParameters.content_length);
            }
            String string5 = URLDecoder.decode(string, "UTF-8");
            HttpRequest httpRequest = new HttpRequest(aWSRequestParameters.method, new URI(string5));
            String string6 = Signer.builder().awsCredentials(new AwsCredentials(this.itsAPIAccessKey, this.itsAPISecretKey)).header("host", string2).header("x-amz-date", string3).header("x-amz-content-sha256", string4).region(this.itsRegion).buildS3(httpRequest, string4).getSignature();
            httpURLConnection.setRequestProperty("Authorization", string6);
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.error(logger, "Error connecting to HTTP URL " + string, exception);
        }
        return httpURLConnection;
    }

    private Date getFileModifiedDate(String string, String string2) throws Exception {
        throw new Exception("AWS connection does not support a get modified date operation");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, FtpFileInfo> listFiles(String string, String string2) throws Exception {
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        HttpURLConnection httpURLConnection = null;
        try {
            CharSequence charSequence;
            AWSRequestParameters aWSRequestParameters = new AWSRequestParameters();
            aWSRequestParameters.method = "GET";
            aWSRequestParameters.parameters.put("list-type", "2");
            aWSRequestParameters.parameters.put("delimiter", "/");
            String[] stringArray = Util.getColumns(string, '/');
            if (stringArray.length > 1) {
                charSequence = new StringBuilder();
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    ((StringBuilder)charSequence).append(stringArray[i2]);
                    ((StringBuilder)charSequence).append("/");
                }
                aWSRequestParameters.parameters.put("prefix", ((StringBuilder)charSequence).toString());
            }
            charSequence = this.getURL(string, aWSRequestParameters);
            Util_Logger.debug(logger, "Polling directory: " + ((String)charSequence).toString());
            httpURLConnection = this.getHttpURLConnection((String)charSequence, null, aWSRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                if (!httpURLConnection.getContentType().toLowerCase().startsWith("application/xml")) throw new Exception("Invalid response type " + httpURLConnection.getContentType() + " detected in listFiles");
                AWSDirectoryWrapper aWSDirectoryWrapper = new AWSDirectoryWrapper();
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(httpURLConnection.getInputStream());
                XStream xStream = XmlUtilities.getConverter();
                xStream.alias("ListBucketResult", AWSDirectoryWrapper.class);
                xStream.alias("CommonPrefixes", AWSBlob.class);
                xStream.processAnnotations(AWSDirectoryWrapper.class);
                xStream.processAnnotations(AWSBlob.class);
                xStream.addImplicitCollection(AWSDirectoryWrapper.class, "Blobs");
                xStream.registerConverter((Converter)new xStreamDateConverter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
                xStream.unmarshal((HierarchicalStreamReader)new DomReader(document), (Object)aWSDirectoryWrapper);
                if (aWSDirectoryWrapper.Blobs != null) {
                    for (AWSBlob aWSBlob : aWSDirectoryWrapper.Blobs) {
                        Object object;
                        Object object2;
                        if (Util.isBlank(aWSBlob.Prefix)) {
                            if (aWSBlob.Key.endsWith("/")) continue;
                            object2 = aWSBlob.Key;
                            if (aWSBlob.Key.lastIndexOf("/") > 0) {
                                object2 = aWSBlob.Key.substring(aWSBlob.Key.lastIndexOf("/") + 1);
                            }
                            object = new FtpFileInfo();
                            ((FtpFileInfo)object).setFilename((String)object2);
                            ((FtpFileInfo)object).setDirectory(string);
                            ((FtpFileInfo)object).setFileType(FtpFileTypeEnum.FILE);
                            ((FtpFileInfo)object).setModifiedDate(aWSBlob.LastModified, true);
                            ((FtpFileInfo)object).setSize(aWSBlob.Size);
                            hashMap.put(((FtpFileInfo)object).getFilename(), (FtpFileInfo)object);
                            continue;
                        }
                        object2 = new FtpFileInfo();
                        object = aWSBlob.Prefix;
                        if (((String)object).endsWith("/")) {
                            object = aWSBlob.Prefix.substring(0, aWSBlob.Prefix.length() - 1);
                        }
                        if (((String)object).lastIndexOf("/") > 0) {
                            object = ((String)object).substring(((String)object).lastIndexOf("/") + 1);
                        }
                        ((FtpFileInfo)object2).setFilename((String)object);
                        ((FtpFileInfo)object2).setDirectory(string);
                        ((FtpFileInfo)object2).setFileType(FtpFileTypeEnum.DIRECTORY);
                        hashMap.put(((FtpFileInfo)object2).getFilename(), (FtpFileInfo)object2);
                    }
                }
            } else {
                String string3 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in AWS List Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string3);
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
            return hashMap;
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error listing directory " + string + " from web: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    private String getURL(String string, AWSRequestParameters aWSRequestParameters) throws Exception {
        String[] stringArray = Util.getColumns(string, '/');
        String string2 = stringArray[0];
        StringBuilder stringBuilder = new StringBuilder("https://" + string2 + ".s3-" + this.itsRegion + ".amazonaws.com/");
        String string3 = "?";
        if (aWSRequestParameters != null) {
            if (!Util.isBlank(aWSRequestParameters.resource)) {
                stringBuilder.append(aWSRequestParameters.resource);
            }
            ArrayList<String> arrayList = new ArrayList<String>(aWSRequestParameters.parameters.keySet());
            Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
            for (String string4 : arrayList) {
                stringBuilder.append(string3);
                stringBuilder.append(string4);
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(aWSRequestParameters.parameters.get(string4), "UTF-8"));
                string3 = "&";
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Date getFile(String string, String string2, String string3, Date date) throws Exception {
        block17: {
            HttpURLConnection httpURLConnection = null;
            File file = null;
            try {
                AWSRequestParameters aWSRequestParameters = new AWSRequestParameters();
                aWSRequestParameters.method = "GET";
                String[] stringArray = Util.getColumns(string, '/');
                StringBuilder stringBuilder = new StringBuilder();
                if (stringArray.length > 1) {
                    for (int i2 = 1; i2 < stringArray.length; ++i2) {
                        if (i2 > 1) {
                            stringBuilder.append("/");
                        }
                        stringBuilder.append(stringArray[i2]);
                    }
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(string3);
                aWSRequestParameters.resource = stringBuilder.toString();
                String string4 = this.getURL(string, aWSRequestParameters);
                Util_Logger.debug(logger, "Downloading blob: " + string4);
                httpURLConnection = this.getHttpURLConnection(string4, null, aWSRequestParameters);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    try (InputStream inputStream = httpURLConnection.getInputStream();){
                        file = new File(string2 + "/" + string3);
                        Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        file.setLastModified(date.getTime());
                        break block17;
                    }
                }
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in AWS Get Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
            catch (Exception exception) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    FileUtilities.deleteFile(file);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                Util_Logger.error(logger, "Error transferring file " + string3 + " from AWS blob: " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    @Override
    public void putFile(String string, String string2, String string3, Date date, boolean bl) throws Exception {
        block10: {
            HttpURLConnection httpURLConnection = null;
            try {
                byte[] byArray = Files.readAllBytes(Paths.get(string, string2));
                AWSRequestParameters aWSRequestParameters = new AWSRequestParameters();
                aWSRequestParameters.method = "PUT";
                aWSRequestParameters.content_type = "application/octet-stream";
                aWSRequestParameters.content_length = Integer.toString(byArray.length);
                String[] stringArray = Util.getColumns(string3, '/');
                StringBuilder stringBuilder = new StringBuilder();
                if (stringArray.length > 1) {
                    for (int i2 = 1; i2 < stringArray.length; ++i2) {
                        if (i2 > 1) {
                            stringBuilder.append("/");
                        }
                        stringBuilder.append(stringArray[i2]);
                    }
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(string2);
                aWSRequestParameters.resource = stringBuilder.toString();
                String string4 = this.getURL(string3, aWSRequestParameters);
                Util_Logger.debug(logger, "Putting blob: " + string4);
                httpURLConnection = this.getHttpURLConnection(string4, byArray, aWSRequestParameters);
                httpURLConnection.getOutputStream().write(byArray);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    if (bl) {
                        this.itsLocal.deleteFile(string, string2);
                    }
                    break block10;
                }
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in AWS Put Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
            catch (Exception exception) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Util_Logger.error(logger, "Error putting file " + string2 + " to AWS blob: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            AWSRequestParameters aWSRequestParameters = new AWSRequestParameters();
            aWSRequestParameters.method = "DELETE";
            String[] stringArray = Util.getColumns(string, '/');
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray.length > 1) {
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    if (i2 > 1) {
                        stringBuilder.append("/");
                    }
                    stringBuilder.append(stringArray[i2]);
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string2);
            aWSRequestParameters.resource = stringBuilder.toString();
            String string3 = this.getURL(string, aWSRequestParameters);
            Util_Logger.debug(logger, "Deleting blob: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, null, aWSRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 204) {
                String string4 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in AWS Delete Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string4);
            }
        }
        catch (Exception exception) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error deleting file " + string2 + " from AWS blob: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws Exception {
        return this.exists(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("AWS connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public pdrFileLockInt lockFile(FtpFileInfo ftpFileInfo) {
        return new pdrFileLockNone();
    }

    @Override
    public void releaseFileLock(pdrFileLockInt pdrFileLockInt2) {
    }
}

