/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionLocalFilter;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileLockLocal;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.FtpFileTypeEnum;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrConnectionLocal
implements pdrConnectionInt {
    private static Logger logger = LoggerFactory.getLogger(pdrConnectionLocal.class);
    private String itsDataSourceId;
    private String itsCurrentDir;
    private String itsPathSeparator;

    public pdrConnectionLocal(String string) {
        this.itsDataSourceId = string;
        this.itsPathSeparator = Character.toString(File.separatorChar);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return true;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    protected String fixDir(String string) {
        return Util.replaceAll(string, "/", this.itsPathSeparator);
    }

    @Override
    public void makeDir(String string) throws Exception {
        File file = new File(this.fixDir(string));
        if (!file.exists()) {
            Util_Logger.info(logger, "Creating local directory: " + file.getPath());
            if (!file.mkdirs()) {
                throw new Exception("Error creating new directory " + file.getPath());
            }
        }
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = this.fixDir(string);
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("Error changing to non-existant local directory " + string);
        }
        if (!file.isDirectory()) {
            throw new Exception("Error changing to local directory " + string + ", this is not a directory");
        }
    }

    @Override
    public Map<String, FtpFileInfo> listFiles(String string, String string2) throws Exception {
        HashMap<String, FtpFileInfo> hashMap = new HashMap<String, FtpFileInfo>();
        String string3 = this.fixDir(string);
        File file = new File(string3);
        File[] fileArray = file.listFiles(new pdrConnectionLocalFilter(string2));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                FtpFileInfo ftpFileInfo = new FtpFileInfo();
                ftpFileInfo.setDirectory(new String(string3));
                ftpFileInfo.setFilename(new String(file2.getName()));
                ftpFileInfo.setSize(file2.length());
                ftpFileInfo.setModifiedDate(new Date(file2.lastModified()), true);
                if (file2.isDirectory()) {
                    ftpFileInfo.setFileType(FtpFileTypeEnum.DIRECTORY);
                } else {
                    ftpFileInfo.setFileType(FtpFileTypeEnum.FILE);
                }
                hashMap.put(ftpFileInfo.getFilename(), ftpFileInfo);
            }
            fileArray = null;
        }
        return hashMap;
    }

    private void copyFile(String string, String string2, String string3, Date date) throws Exception {
        File file = new File(this.fixDir(string) + this.itsPathSeparator + string3);
        File file2 = new File(this.fixDir(string2) + this.itsPathSeparator + string3);
        try {
            FileUtilities.copy(file, file2);
        }
        catch (Exception exception) {
            throw new Exception("Error copying " + file.getPath() + " to " + file2.getPath() + ": " + exception.getMessage());
        }
        if (date != null) {
            file2.setLastModified(date.getTime());
        }
    }

    private void moveFile(String string, String string2, String string3, Date date) throws Exception {
        File file = new File(this.fixDir(string) + this.itsPathSeparator + string3);
        File file2 = new File(this.fixDir(string2) + this.itsPathSeparator + string3);
        try {
            FileUtilities.renameFile(file, file2);
        }
        catch (Exception exception) {
            throw new Exception("Error moving " + file.getPath() + " to " + file2.getPath() + ": " + exception.getMessage());
        }
        if (date != null) {
            file2.setLastModified(date.getTime());
        }
    }

    @Override
    public Date getFile(String string, String string2, String string3, Date date) throws Exception {
        this.copyFile(string, string2, string3, date);
        return null;
    }

    @Override
    public void putFile(String string, String string2, String string3, Date date, boolean bl) throws Exception {
        if (bl) {
            this.moveFile(string, string3, string2, date);
        } else {
            this.copyFile(string, string3, string2, date);
        }
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        String string3 = this.fixDir(string) + this.itsPathSeparator + string2;
        try {
            FileUtilities.deleteFile(string3);
        }
        catch (Exception exception) {
            throw new Exception("Error deleting local file " + string3 + ": " + exception.getMessage());
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        String string3 = this.fixDir(string + "/" + string2);
        return new File(string3).exists();
    }

    @Override
    public boolean exists(FtpFileInfo ftpFileInfo) throws Exception {
        return this.exists(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        File file = new File(this.fixDir(string) + this.itsPathSeparator + string2);
        File file2 = new File(this.fixDir(string3) + this.itsPathSeparator + string4);
        try {
            FileUtilities.renameFile(file, file2);
        }
        catch (Exception exception) {
            throw new Exception("Error renaming " + file.getPath() + " to " + file2.getPath() + ": " + exception.getMessage());
        }
    }

    @Override
    public boolean logOperations() {
        return false;
    }

    @Override
    public pdrFileLockInt lockFile(FtpFileInfo ftpFileInfo) {
        pdrFileLockLocal pdrFileLockLocal2 = new pdrFileLockLocal();
        pdrFileLockLocal2.lockFile(ftpFileInfo);
        return pdrFileLockLocal2;
    }

    @Override
    public void releaseFileLock(pdrFileLockInt pdrFileLockInt2) {
        if (pdrFileLockInt2 != null) {
            pdrFileLockInt2.release();
        }
    }
}

