/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryAPI;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryAWS;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryAzure;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryFtp;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryGoogle;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryInt;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryLocal;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryNull;
import au.com.nemmco.Pdr.Batcher.Transport.pdrConnectionFactoryWeb;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrDataSourceFactory {
    private static Logger logger = LoggerFactory.getLogger(pdrDataSourceFactory.class);
    private static Properties itsConfiguration;
    private Map<String, pdrConnectionFactoryInt> itsSources = new HashMap<String, pdrConnectionFactoryInt>();
    private boolean isReady = false;
    private boolean allOK = true;

    private pdrDataSourceFactory() {
        pdrConnectionFactoryFtp.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryFtp.getInstance());
        pdrConnectionFactoryLocal.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryLocal.getInstance());
        pdrConnectionFactoryWeb.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryWeb.getInstance());
        pdrConnectionFactoryNull.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryNull.getInstance());
        pdrConnectionFactoryAzure.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryAzure.getInstance());
        pdrConnectionFactoryAWS.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryAWS.getInstance());
        pdrConnectionFactoryAPI.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryAPI.getInstance());
        pdrConnectionFactoryGoogle.setConfiguration(itsConfiguration);
        this.registerFactory(pdrConnectionFactoryGoogle.getInstance());
        this.isReady = this.allOK;
    }

    public static pdrDataSourceFactory getInstance() {
        return SingletonHolder.instance;
    }

    public static void setConfiguration(Properties properties) {
        itsConfiguration = properties;
    }

    public void registerFactory(pdrConnectionFactoryInt pdrConnectionFactoryInt2) {
        this.itsSources.put(pdrConnectionFactoryInt2.getName().toUpperCase(), pdrConnectionFactoryInt2);
        this.allOK = this.allOK && pdrConnectionFactoryInt2.getIsReady();
    }

    public boolean getIsReady() {
        return this.isReady;
    }

    public pdrConnectionFactoryInt getFactory(String string) {
        return this.itsSources.get(string.toUpperCase());
    }

    public void resetPool() {
        for (pdrConnectionFactoryInt pdrConnectionFactoryInt2 : this.itsSources.values()) {
            pdrConnectionFactoryInt2.resetPool();
        }
    }

    public void clearDataState() {
        for (pdrConnectionFactoryInt pdrConnectionFactoryInt2 : this.itsSources.values()) {
            pdrConnectionFactoryInt2.clearDataState();
        }
    }

    private static class SingletonHolder {
        private static pdrDataSourceFactory instance = new pdrDataSourceFactory();

        private SingletonHolder() {
        }
    }
}

