/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Validator;

import au.com.nemmco.Pdr.Batcher.Validator.pdrFileValidatorInt;
import au.com.nemmco.Pdr.Batcher.Validator.pdrFileValidatorXml;
import au.com.nemmco.Pdr.Batcher.Validator.pdrFileValidatorZip;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileValidatorFactory {
    private static Logger logger = LoggerFactory.getLogger(pdrFileValidatorFactory.class);
    private Map<String, pdrFileValidatorInt> itsValidators = new HashMap<String, pdrFileValidatorInt>();

    private pdrFileValidatorFactory() {
        this.registorValidator(new pdrFileValidatorXml());
        this.registorValidator(new pdrFileValidatorZip());
    }

    public static pdrFileValidatorFactory getInstance() {
        return SingletonHolder.instance;
    }

    public void registorValidator(pdrFileValidatorInt pdrFileValidatorInt2) {
        for (String string : pdrFileValidatorInt2.acceptFileTypes()) {
            this.itsValidators.put(string.toUpperCase(), pdrFileValidatorInt2);
        }
    }

    public pdrFileValidatorInt getValidator(String string) throws Exception {
        pdrFileValidatorInt pdrFileValidatorInt2 = this.itsValidators.get(string.toUpperCase());
        if (pdrFileValidatorInt2 != null) {
            return (pdrFileValidatorInt)pdrFileValidatorInt2.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return null;
    }

    private static class SingletonHolder {
        private static pdrFileValidatorFactory instance = new pdrFileValidatorFactory();

        private SingletonHolder() {
        }
    }
}

