/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher;

import au.com.nemmco.Pdr.Batcher.API.WebAPIBatcherControl;
import au.com.nemmco.Pdr.Batcher.API.WebAPIBatcherThreadConfiguration;
import au.com.nemmco.Pdr.Batcher.API.WebAPIBatcherThreadStatus;
import au.com.nemmco.Pdr.Batcher.API.WebAPIBatcherThreads;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerFactory;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerInt;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerJob;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerManager;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationUtil;
import au.com.nemmco.Pdr.Batcher.Transport.pdrDataSourceFactory;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileCacheManager;
import au.com.nemmco.Pdr.Batcher.Transport.pdrFileWebManager;
import au.com.nemmco.Pdr.Batcher.pdrFileEventInt;
import au.com.nemmco.Pdr.Common.pdrLockManager;
import au.com.nemmco.Pdr.Common.pdrMonitorManager;
import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.ApplicationInt;
import au.com.nemmco.Util.FilePurgeThread;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.InstanceLockManager;
import au.com.nemmco.Util.JobSchedulerManager;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebServer;
import au.com.nemmco.Util.threadMonitor;
import au.com.nemmco.Util.threadMonitorCheckInt;
import au.com.nemmco.Util.threadMonitorStatusItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcher
implements threadMonitorCheckInt,
ApplicationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcher.class);
    public static final String PROPERTIES_FILE = System.getProperty("config", "pdrBatcher.properties");
    public static final String APP_NAME = "pdrBatcher";
    public static final String VERSION = "7.5.0";
    public static final String THREAD_MODE_CONSUMER = "CONSUMER";
    public static final String THREAD_MODE_CONSUMER_RO = "CONSUMER_RO";
    public static final String THREAD_MODE_CONSUMER_CACHE = "CONSUMER_CACHE";
    public static final String THREAD_MODE_SYNCHRONISE = "SYNCHRONISE";
    public static final String THREAD_MODE_PURGE = "PURGE";
    public static final String THREAD_MODE_ASEXML = "ASEXML";
    public static final String THREAD_DELIVERY_PRIMARY = "PRIMARY";
    public static final String THREAD_DELIVERY_BACKUP = "BACKUP";
    public static final String PROTOCOL_FTP = "FTP";
    public static final String PROTOCOL_LOCAL = "LOCAL";
    public static final String PROTOCOL_WEB = "WEB";
    public static final String PROTOCOL_NULL = "NULL";
    public static final String PROTOCOL_AZURE = "AZURE";
    public static final String PROTOCOL_AWS = "AWS";
    public static final String PROTOCOL_API = "API";
    public static final String PROTOCOL_GOOGLE = "GOOGLE";
    public static final String SCHEDULE_MODE_POLL = "POLL";
    public static final String SCHEDULE_MODE_CRON = "CRON";
    public static final String SCHEDULE_MODE_API = "API";
    private boolean itsIsReady = false;
    private volatile Date itsLastBusyTime;
    private int itsInactivityTimeoutSecs;
    private int itsInactivityFailoverCount;
    private String itsHeartbeatFile;
    private Properties itsConfiguration;

    public pdrBatcher() throws Exception {
        Object object;
        Object object22;
        int n2;
        Object object4;
        Object object5;
        Properties properties;
        this.itsConfiguration = properties = Util.getPropertiesObject(PROPERTIES_FILE);
        boolean bl = Util.getProperty(properties, "batcher_single_instance", "true").equalsIgnoreCase("true");
        if (bl && !((InstanceLockManager)(object5 = InstanceLockManager.getInstance())).setLock((String)(object4 = Util.getProperty(properties, "batcher_holding_dir") + "/pdrBatcher.lock"))) {
            Util_Logger.error(logger, "Unable to start PDR batcher, another instance is already running, lock file: " + (String)object4);
        }
        object5 = Util.getProperty(properties, "batcher_lock_manager_engine", "INTERNAL");
        pdrLockManager.getInstance().configure((String)object5);
        object4 = pdrBatcherHandlerManager.getInstance();
        pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
        pdrMonitorManager2.init(properties);
        pdrMonitorManager2.setAppDetails(this);
        this.clearHoldingDirectory();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = Util.getProperty(properties, "batcher_threads_active", null);
        if (Util.isBlank(string)) {
            int n3 = Integer.parseInt(Util.getProperty(properties, "batcher_threads", "1"));
            for (n2 = 1; n2 <= n3; ++n2) {
                arrayList.add(n2);
            }
        } else {
            String[] stringArray;
            for (String object32 : stringArray = Util.getColumns(string, ',')) {
                if (Util.isInteger(object32)) {
                    arrayList.add(Integer.parseInt(object32));
                    continue;
                }
                Util_Logger.warning(logger, "Ignoring invalid batcher thread '" + object32 + "', use integer");
            }
        }
        ArrayList<pdrBatcherHandlerInt> arrayList2 = new ArrayList<pdrBatcherHandlerInt>();
        n2 = 1;
        Object object6 = arrayList.iterator();
        while (object6.hasNext()) {
            int n4 = (Integer)object6.next();
            try {
                pdrBatcherHandlerInt pdrBatcherHandlerInt2 = this.createThread(n4);
                if (pdrBatcherHandlerInt2 == null) continue;
                arrayList2.add(pdrBatcherHandlerInt2);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error creating thread " + n4 + ": " + exception.getMessage());
                n2 = 0;
            }
        }
        if (n2 == 0) {
            Util_Logger.error(logger, "Detected error configuring pdrBatcher, aborting startup");
        }
        object6 = threadMonitor.getInstance();
        JobSchedulerManager jobSchedulerManager = JobSchedulerManager.getInstance();
        for (Object object22 : arrayList2) {
            Object object3;
            ((pdrBatcherHandlerManager)object4).registerHandler((pdrBatcherHandlerInt)object22);
            String string2 = object22.getOperation() + "_" + object22.getId();
            if (Util.isBlank(object22.getSchedulingMode())) {
                Util_Logger.error(logger, "Error starting thread " + object22.getId() + ", scheduling mode is undefined");
            } else if (object22.getSchedulingMode().equalsIgnoreCase(SCHEDULE_MODE_POLL)) {
                object3 = new Thread((Runnable)object22);
                ((Thread)object3).setDaemon(true);
                ((Thread)object3).setName(string2);
                ((Thread)object3).start();
                ((threadMonitor)object6).addThread((Thread)object3);
            } else if (object22.getSchedulingMode().equalsIgnoreCase(SCHEDULE_MODE_CRON)) {
                if (Util.isBlank(object22.getCronJobSchedule())) {
                    Util_Logger.error(logger, "Error starting thread " + object22.getId() + " in CRON mode, CRON expression is not defined");
                }
                object3 = "pdrBatcherThread";
                object = new HashMap();
                object.put("ID", Integer.toString(object22.getId()));
                jobSchedulerManager.scheduleJob((String)object3, string2, object22.getCronJobSchedule(), new pdrBatcherHandlerJob(), (Map<String, String>)object);
            } else if (!object22.getSchedulingMode().equalsIgnoreCase("API")) {
                Util_Logger.error(logger, "Error starting thread " + object22.getId() + ", unrecognised scheduling mode: " + object22.getSchedulingMode());
            }
            Thread.sleep(1000L);
        }
        Util_Logger.info(logger, "Started " + arrayList.size() + " batcher threads");
        jobSchedulerManager.start();
        this.itsLastBusyTime = new Date();
        String string3 = Util.getProperty(properties, "batcher_inactivity_timeout", "");
        object22 = Util.getProperty(properties, "batcher_inactivity_failover_oount", "");
        int n3 = 0;
        int n4 = 0;
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt3 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            if (pdrBatcherHandlerInt3.getActivityMonitor()) {
                ++n3;
            }
            if (!pdrBatcherHandlerInt3.getDelivery().equalsIgnoreCase(THREAD_DELIVERY_BACKUP)) continue;
            ++n4;
        }
        this.itsInactivityTimeoutSecs = -1;
        this.itsInactivityFailoverCount = -1;
        if (!Util.isBlank(string3)) {
            if (n3 > 0) {
                this.itsInactivityTimeoutSecs = Integer.parseInt(string3);
                if (!Util.isBlank((String)object22)) {
                    this.itsInactivityFailoverCount = Integer.parseInt((String)object22);
                }
            } else {
                Util_Logger.warning(logger, "Inactivity monitor is disabled, please enable at least 1 batcher thread for inactivity monitoring");
            }
        } else if (n3 > 0) {
            Util_Logger.warning(logger, "Inactivity monitor is disabled, please specify batcher_inactivity_timeout parameter");
        }
        if (Util.isBlank((String)object22) && n4 > 0) {
            Util_Logger.warning(logger, "Inactivity failover is disabled, please specify batcher_inactivity_failover_oount parameter");
        }
        ((threadMonitor)object6).addCheck(this);
        try {
            object = new FilePurgeThread(properties);
            if (((FilePurgeThread)object).getHasConfiguration()) {
                Thread thread = new Thread((Runnable)object);
                thread.setDaemon(true);
                thread.setName("filesystem_purge");
                thread.start();
                ((threadMonitor)object6).addThread(thread);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error creating filesystem purge thread: " + exception.getMessage(), exception);
        }
        WebServer.getInstance().addHandlersFromPackage("au.com.nemmco.Pdr.Batcher.API");
        WebServer.getInstance().addHandler(WebAPIBatcherThreads.class);
        WebServer.getInstance().addHandler(WebAPIBatcherThreadStatus.class);
        WebServer.getInstance().addHandler(WebAPIBatcherThreadConfiguration.class);
        WebServer.getInstance().addHandler(WebAPIBatcherControl.class);
        this.itsIsReady = true;
    }

    public boolean getIsReady() {
        return this.itsIsReady;
    }

    @Override
    public boolean getCheckIsAvailable() {
        return this.itsInactivityTimeoutSecs > 0;
    }

    @Override
    public Date getCheckTimestamp() {
        return this.itsLastBusyTime;
    }

    @Override
    public int getCheckBusinessCycleSeconds() {
        return this.itsInactivityTimeoutSecs;
    }

    @Override
    public String getCheckDescription() {
        return APP_NAME;
    }

    @Override
    public boolean getCheckIsFatal() {
        return true;
    }

    @Override
    public void resetThread() {
        pdrDataSourceFactory pdrDataSourceFactory2 = pdrDataSourceFactory.getInstance();
        pdrDataSourceFactory2.resetPool();
        if (this.itsInactivityFailoverCount > 0) {
            this.manageBackupDeliveryActiveStatus();
        }
    }

    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = new threadMonitorStatusItem("Threads");
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            threadMonitorStatusItem2.addItem(pdrBatcherHandlerInt2.getStatusReport());
        }
        return threadMonitorStatusItem2;
    }

    private void manageBackupDeliveryActiveStatus() {
        boolean bl = false;
        if (this.itsInactivityFailoverCount > 0) {
            Date date = Util.dateOffset(new Date(), -this.itsInactivityFailoverCount * this.getCheckBusinessCycleSeconds(), 13);
            boolean bl2 = this.getCheckTimestamp().before(date);
            for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
                if (!pdrBatcherHandlerInt2.getDelivery().equalsIgnoreCase(THREAD_DELIVERY_BACKUP) || bl2 == pdrBatcherHandlerInt2.getIsActive()) continue;
                if (!bl && bl2) {
                    pdrDataSourceFactory pdrDataSourceFactory2 = pdrDataSourceFactory.getInstance();
                    pdrDataSourceFactory2.clearDataState();
                    bl = true;
                }
                pdrBatcherHandlerInt2.setIsActive(bl2);
                if (bl2) {
                    Util_Logger.info(logger, "Enabling BACKUP delivery thread " + pdrBatcherHandlerInt2.getId() + " after " + this.itsInactivityFailoverCount + " consecutive inactivity timeout periods on PRIMARY delivery threads");
                    continue;
                }
                Util_Logger.info(logger, "Disabling BACKUP delivery thread " + pdrBatcherHandlerInt2.getId() + " after PRIMARY delivery recovery");
            }
        }
    }

    private void clearHoldingDirectory() {
        Util_Logger.info(logger, "Commencing clean-out of holding directory");
        try {
            String string = Util.getProperty(PROPERTIES_FILE, "batcher_holding_dir");
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    if (!fileArray[i2].exists()) continue;
                    fileArray[i2].delete();
                    Util_Logger.info(logger, "Deleted file " + fileArray[i2].getName() + " in holding directory clean-up");
                }
            } else {
                Util_Logger.warning(logger, "Detected network problem accessing " + string + " in batcher", null);
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error in holding directory clean-up: " + exception.getMessage(), exception);
        }
    }

    private pdrBatcherHandlerInt createThread(int n2) throws IOException, ApplicationException {
        String string;
        String string2;
        String string3;
        String string4;
        pdrBatcherHandlerInt pdrBatcherHandlerInt2 = null;
        pdrBatcherHandlerConfig pdrBatcherHandlerConfig2 = new pdrBatcherHandlerConfig();
        String string5 = Util.getProperty(PROPERTIES_FILE, "batcher_holding_dir");
        String string6 = Util.getProperty(PROPERTIES_FILE, "batcher_timeout");
        String string7 = Util.getProperty(PROPERTIES_FILE, "batcher_polling_interval", "5");
        String string8 = Util.getProperty(PROPERTIES_FILE, "batcher_fail_interval", "60");
        this.itsHeartbeatFile = Util.getProperty(PROPERTIES_FILE, "batcher_heartbeat_file", "");
        pdrFileEventInt pdrFileEventInt2 = null;
        try {
            string4 = Util.getProperty(PROPERTIES_FILE, "batcher_event_class", "");
            if (!Util.isBlank(string4)) {
                pdrFileEventInt2 = (pdrFileEventInt)Class.forName(string4).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error instantiating file event handler class: " + exception.getMessage(), exception);
        }
        string4 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_delivery", THREAD_DELIVERY_PRIMARY);
        String string9 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_inc", null);
        String string10 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_exc", null);
        String string11 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_mask_mode", "EXCLUSIVE");
        int n3 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_min_size_bytes", "-1"));
        int n4 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_max_size_kB", "-1"));
        int n5 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_timeout", string6));
        int n6 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_throttle", "0"));
        int n7 = (int)Double.parseDouble(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_polling_interval", string7)) * 1000;
        int n8 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_fail_interval", string8));
        String string12 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_schedule_mode", SCHEDULE_MODE_POLL);
        String string13 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_cron_job_schedule", null);
        int n9 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_pause_interval", "0"));
        int n10 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_process_limit", "0"));
        String string14 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_process_order", "");
        boolean bl = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_activity_monitor", "N").equalsIgnoreCase("Y");
        if (bl && !string4.equalsIgnoreCase(THREAD_DELIVERY_PRIMARY)) {
            Util_Logger.warning(logger, "Disabling thread activity monitor on non-PRIMARY batcher thread " + n2);
            bl = false;
        }
        boolean bl2 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_allow_overwrite", "N").equalsIgnoreCase("Y");
        String string15 = "remote";
        String string16 = "local";
        String string17 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source", string15);
        String string18 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string17 + "_mode");
        String string19 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_mode", THREAD_MODE_CONSUMER);
        String string20 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest", string16);
        String string21 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string20 + "_mode", PROTOCOL_LOCAL);
        String string22 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest_dir_list_file", null);
        String string23 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_file_translator", "NONE");
        List<Object> list = new ArrayList();
        if (!Util.isBlank(string23)) {
            list = pdrFileTranslationUtil.resolveConfig(string23);
        }
        if (Util.isBlank(string3 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest_dir", ""))) {
            string3 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string20 + "_dir");
        }
        if (Util.isBlank(string2 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_dir", ""))) {
            string2 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string17 + "_dir");
        }
        if (Util.isBlank(string = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_archive_dir", ""))) {
            string = Util.getProperty(PROPERTIES_FILE, "batcher_" + string17 + "_archive_dir", "");
        }
        String string24 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_sub_dir", null);
        List<String> list2 = null;
        if (!Util.isBlank(string24)) {
            list2 = string24.toLowerCase().startsWith("file:") ? Files.readAllLines(Paths.get(string24.substring(5), new String[0])) : Arrays.asList(Util.getColumns(string24, ','));
        }
        boolean bl3 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dir_recurse", "N").equalsIgnoreCase("Y");
        boolean bl4 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dir_create", "N").equalsIgnoreCase("Y");
        boolean bl5 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_sub_dir_dest", "Y").equalsIgnoreCase("Y");
        if (string18.equalsIgnoreCase("API")) {
            bl5 = false;
        }
        boolean bl6 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_check_file_integrity", "Y").equalsIgnoreCase("Y");
        int n11 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_retention_time_mins", "-1"));
        int n12 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_transfer_buffer_size", "-1"));
        String string25 = null;
        string25 = string18.equalsIgnoreCase(PROTOCOL_LOCAL) ? "UPLOAD" : "DOWNLOAD";
        String string26 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_job_type", string25);
        pdrBatcherHandlerConfig2.ThreadId = n2;
        pdrBatcherHandlerConfig2.Name = "Thread " + n2;
        pdrBatcherHandlerConfig2.Description = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_description", pdrBatcherHandlerConfig2.Name);
        pdrBatcherHandlerConfig2.ThreadDelivery = string4;
        pdrBatcherHandlerConfig2.DataSource = string17;
        pdrBatcherHandlerConfig2.DataSourceProtocol = string18;
        pdrBatcherHandlerConfig2.DataDestination = string20;
        pdrBatcherHandlerConfig2.DataDestinationProtocol = string21;
        pdrBatcherHandlerConfig2.SourceDir = string2;
        pdrBatcherHandlerConfig2.DestinationDir = string3;
        pdrBatcherHandlerConfig2.IncludeFileMask = string9;
        pdrBatcherHandlerConfig2.ExcludeFileMask = string10;
        pdrBatcherHandlerConfig2.FileMaskMode = string11;
        pdrBatcherHandlerConfig2.MinFileSizeBytes = n3;
        pdrBatcherHandlerConfig2.MaxFileSizeKB = n4;
        pdrBatcherHandlerConfig2.HoldingDir = string5;
        pdrBatcherHandlerConfig2.PollingIntervalMilliSecs = n7;
        pdrBatcherHandlerConfig2.PauseIntervalSecs = n9;
        pdrBatcherHandlerConfig2.FailWaitIntervalSecs = n8;
        pdrBatcherHandlerConfig2.SchedulingMode = string12;
        pdrBatcherHandlerConfig2.CronJobSchedule = string13;
        pdrBatcherHandlerConfig2.TimeoutSeconds = n5;
        pdrBatcherHandlerConfig2.TrottleBytesPerSecond = n6;
        pdrBatcherHandlerConfig2.ProcessLimitFiles = n10;
        pdrBatcherHandlerConfig2.FileProcessOrder = string14;
        pdrBatcherHandlerConfig2.TransferBufferSize = n12;
        pdrBatcherHandlerConfig2.Parent = this;
        pdrBatcherHandlerConfig2.ThreadActivityMonitor = bl;
        pdrBatcherHandlerConfig2.SubDirList = list2;
        pdrBatcherHandlerConfig2.SubDirListDest = bl5;
        pdrBatcherHandlerConfig2.DirectoryRecurse = bl3;
        pdrBatcherHandlerConfig2.DirectoryCreate = bl4;
        pdrBatcherHandlerConfig2.AllowOverwrite = bl2;
        pdrBatcherHandlerConfig2.SourceArchiveDir = string;
        pdrBatcherHandlerConfig2.DestinationDirListingFile = string22;
        pdrBatcherHandlerConfig2.FileTranslator = list;
        pdrBatcherHandlerConfig2.FileEventHandler = pdrFileEventInt2;
        pdrBatcherHandlerConfig2.CheckFileIntegrity = bl6;
        pdrBatcherHandlerConfig2.JobType = string26;
        pdrBatcherHandlerConfig2.RetentionTimeMins = n11;
        pdrBatcherHandlerFactory pdrBatcherHandlerFactory2 = pdrBatcherHandlerFactory.getInstance();
        try {
            pdrBatcherHandlerInt2 = pdrBatcherHandlerFactory2.getProcessor(string19, pdrBatcherHandlerConfig2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error creating batcher thread " + n2 + ": " + exception.getMessage(), exception);
            System.exit(-1);
        }
        if (pdrBatcherHandlerInt2 != null) {
            pdrBatcherHandlerInt2.setIsActive(!string4.equalsIgnoreCase(THREAD_DELIVERY_BACKUP));
        }
        return pdrBatcherHandlerInt2;
    }

    public synchronized void updateLastBusyTime(String string) {
        Date date;
        this.itsLastBusyTime = date = new Date();
        this.manageBackupDeliveryActiveStatus();
        if (!Util.isBlank(this.itsHeartbeatFile)) {
            File file = new File(this.itsHeartbeatFile);
            try {
                FileUtilities.touch(file);
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error updating heartbeat file: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public String getAppName() {
        return APP_NAME;
    }

    @Override
    public String getAppVersion() {
        return VERSION;
    }

    @Override
    public Properties getConfiguration() {
        return this.itsConfiguration;
    }

    @Override
    public void stop() {
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            pdrBatcherHandlerInt2.stop();
        }
    }

    @Override
    public void finaliseShutdown() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
                bl = bl || !pdrBatcherHandlerInt2.getIsShutdown();
            }
            if (!bl) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
        pdrMonitorManager2.stop();
        pdrFileWebManager.stop();
        pdrFileCacheManager.stop();
        this.clearHoldingDirectory();
    }
}

