/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common;

import au.com.nemmco.Pdr.Common.pdrLockEngineDistributed;
import au.com.nemmco.Pdr.Common.pdrLockEngineInt;
import au.com.nemmco.Pdr.Common.pdrLockEngineInternal;
import au.com.nemmco.Pdr.Common.pdrTaskInt;
import au.com.nemmco.Util.DistributedMessagingManager;
import au.com.nemmco.Util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrLockManager {
    private static Logger logger = LoggerFactory.getLogger(pdrLockManager.class);
    public static final String LOCK_ENGINE_INTERNAL = "INTERNAL";
    public static final String LOCK_ENGINE_DISTRIBUTED = "DISTRIBUTED";
    private pdrLockEngineInt itsLockEngine = new pdrLockEngineInternal();

    private pdrLockManager() {
    }

    public static pdrLockManager getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(String string) throws Exception {
        if (Util.isBlank(string)) {
            throw new Exception("Locking engine is not defined in application configuration");
        }
        if (string.equalsIgnoreCase(LOCK_ENGINE_DISTRIBUTED)) {
            if (!DistributedMessagingManager.getInstance().isEnabled()) throw new Exception("Missing configuration for distributed messaging within application configuration file, cannot use distributed locking engine");
            this.itsLockEngine = new pdrLockEngineDistributed();
        } else {
            if (!string.equalsIgnoreCase(LOCK_ENGINE_INTERNAL)) throw new Exception("Locking engine type " + string + " is not supported");
            this.itsLockEngine = new pdrLockEngineInternal();
        }
        this.itsLockEngine.initialise();
    }

    public boolean addTask(String string) {
        return this.addTask(string, null);
    }

    public boolean addTask(String string, pdrTaskInt pdrTaskInt2) {
        return this.itsLockEngine.addTask(string, pdrTaskInt2);
    }

    public void deleteTask(String string) {
        this.itsLockEngine.deleteTask(string);
    }

    public void cleanQueue(Thread thread) {
        this.itsLockEngine.cleanQueue(thread);
    }

    private static class SingletonHolder {
        private static pdrLockManager instance = new pdrLockManager();

        private SingletonHolder() {
        }
    }
}

