/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common;

import au.com.nemmco.Pdr.Common.pdrMonitorRec;
import au.com.nemmco.Pdr.Common.pdrPerformanceJobSizeUnits;
import au.com.nemmco.Util.Util;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Date;

@XStreamAlias(value="performance")
public class pdrPerformanceRec
extends pdrMonitorRec {
    private String DataSource;
    private String FileId;
    private String Confidentiality;
    private String Filename;
    private String FileExtension;
    private Date StartDate;
    private Date EndDate;
    private double Duration;
    private Integer HourOfDay;
    private String DayOfWeek;
    private String JobType;
    private long JobSize;
    private pdrPerformanceJobSizeUnits JobSizeUnits;
    private Integer NoJobs;
    private Date ContentCreationDate;
    private Date IntervalEndDate;
    private Double TransactionRate;

    public String getFilename() {
        return this.Filename;
    }

    public void setFilename(String string) {
        this.Filename = string;
        if (string != null) {
            this.Confidentiality = string.toUpperCase().startsWith("PUBLIC") ? "PUBLIC" : "PRIVATE";
        }
    }

    private void calculateDuration() {
        if (this.StartDate != null && this.EndDate != null) {
            this.Duration = ((double)this.EndDate.getTime() - (double)this.StartDate.getTime()) / 1000.0;
            this.calculateTransactionRate();
        }
    }

    private void calculateTransactionRate() {
        if (this.JobSize > 0L && this.Duration > 0.0) {
            this.TransactionRate = (double)this.JobSize / this.Duration;
        }
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public void setStartDate(Date date) {
        this.StartDate = date;
        this.calculateDuration();
        if (this.StartDate != null) {
            this.HourOfDay = Integer.parseInt(Util.dateToStr(date, "HH"));
            this.DayOfWeek = Util.dateToStr(date, "E");
        }
    }

    public Date getEndDate() {
        return this.EndDate;
    }

    public void setEndDate(Date date) {
        this.EndDate = date;
        this.calculateDuration();
    }

    public double getDuration() {
        return this.Duration;
    }

    public long getJobSize() {
        return this.JobSize;
    }

    public void setJobSize(long l2) {
        this.JobSize = l2;
        this.calculateTransactionRate();
    }

    public pdrPerformanceJobSizeUnits getJobSizeUnits() {
        return this.JobSizeUnits;
    }

    public void setJobSizeUnits(pdrPerformanceJobSizeUnits pdrPerformanceJobSizeUnits2) {
        this.JobSizeUnits = pdrPerformanceJobSizeUnits2;
    }

    public String getDataSource() {
        return this.DataSource;
    }

    public void setDataSource(String string) {
        this.DataSource = string;
    }

    public String getFileExtension() {
        return this.FileExtension;
    }

    public void setFileExtension(String string) {
        this.FileExtension = string;
    }

    public String getJobType() {
        return this.JobType;
    }

    public void setJobType(String string) {
        this.JobType = string;
    }

    public String getFileId() {
        return this.FileId;
    }

    public void setFileId(String string) {
        this.FileId = string;
    }

    public int getNoJobs() {
        return this.NoJobs;
    }

    public void setNoJobs(int n2) {
        this.NoJobs = n2;
    }

    public Date getContentCreationDate() {
        return this.ContentCreationDate;
    }

    public void setContentCreationDate(Date date) {
        this.ContentCreationDate = date;
    }

    public Date getIntervalEndDate() {
        return this.IntervalEndDate;
    }

    public void setIntervalEndDate(Date date) {
        this.IntervalEndDate = date;
    }

    public String getConfidentiality() {
        return this.Confidentiality;
    }

    public void setConfidentiality(String string) {
        this.Confidentiality = string;
    }

    public Double getTransactionRate() {
        return this.TransactionRate;
    }
}

