/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.AlertConfig;
import au.com.nemmco.Util.AlertDelivery;
import au.com.nemmco.Util.AppConfiguration;
import au.com.nemmco.Util.JobSchedulerManager;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertManager {
    private static Logger logger = LoggerFactory.getLogger(AlertManager.class);

    public static AlertConfig loadConfigFromProperties(Properties properties) {
        AlertConfig alertConfig = new AlertConfig();
        alertConfig.CronJobSchedule = Util.getProperty(properties, "alert_test_message_cron_job_schedule", null);
        alertConfig.TestMessageText = Util.getProperty(properties, "alert_test_message_text", null);
        return alertConfig;
    }

    public static void configureAlert(AppConfiguration appConfiguration) {
        try {
            AlertConfig alertConfig = appConfiguration.Alert;
            if (alertConfig != null && !Util.isBlank(alertConfig.CronJobSchedule)) {
                JobSchedulerManager jobSchedulerManager = JobSchedulerManager.getInstance();
                if (Util.isBlank(alertConfig.TestMessageText)) {
                    alertConfig.TestMessageText = "Alert Test Message: " + appConfiguration.AppName + " v" + appConfiguration.AppVersion + " on " + System.getProperty("hostname");
                }
                String string = "AlertTestMessage";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("MESSAGE", alertConfig.TestMessageText);
                jobSchedulerManager.scheduleJob(string, "AlertTestMessage", alertConfig.CronJobSchedule, new AlertDelivery(), hashMap);
                jobSchedulerManager.start();
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error configuring alert monitor: " + exception.getMessage(), exception);
        }
    }
}

